package com.cloud.tmc.vuid.util

import android.app.Activity
import android.app.Application
import android.content.Context
import android.content.Intent
import android.content.res.Configuration
import android.graphics.Color
import android.net.Uri
import android.os.Build
import android.widget.Toast
import androidx.annotation.ColorRes
import androidx.core.content.ContextCompat
import com.cloud.tmc.vuid.R
import com.cloud.tmc.vuid.VUID
import java.util.*


/**
 *  @author YANG LIN
 *  @Date 2021/12/22
 *  @descript:
 */
internal fun getAppLanguage(application: Application): String {
    val local = getLocal(application.resources.configuration)
    return if (local != null) {
        local.language
    } else {
        ""
    }
}

private fun getLocal(configuration: Configuration): Locale? {
    return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
        configuration.locales[0]
    } else {
        configuration.locale
    }
}


private fun getColor(@ColorRes id: Int): Int {
    return ContextCompat.getColor(VUID.getApplication(), id)
}


/**
 * 判断当前颜色是否为浅色系
 *
 * @return 深色系或者浅色系
 */
internal fun isLightColor(color: Int): Boolean {
    val darkness = 1 - (0.299 * Color.red(color) + 0.587 * Color.green(color) + 0.114 * Color.blue(color)) / 255
    // It's a dark color
    return darkness < 0.5 // It's a light color
}


internal fun openSchemeUrl(context: Context?, url: String?) {

    if (url.isNullOrBlank() || context == null) return

    try {
        val intent = Intent(Intent.ACTION_VIEW, Uri.parse(url))
        if (context !is Activity) {
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
        }
        context.startActivity(intent)
    } catch (e: Exception) {
            Toast.makeText(context, R.string.text_uninstall_app_hint, Toast.LENGTH_LONG).show()

    }
}
