package com.cloud.tmc.vuid.impl

import com.cloud.tmc.vuid.VUIDReal
import com.cloud.tmc.vuid.data.BaseBean
import com.cloud.tmc.vuid.data.LoginBean
import com.cloud.tmc.vuid.data.RefreshBean
import com.cloud.tmc.vuid.listener.IVTokenListener
import com.cloud.tmc.vuid.network.*
import com.cloud.tmc.vuid.network.KEY_BINDING_APP_ID
import com.cloud.tmc.vuid.network.KEY_BINDUID
import com.cloud.tmc.vuid.network.KEY_WUID
import com.cloud.tmc.vuid.network.getWUID
import com.cloud.tmc.vuid.util.ThreadUtils
import com.cloud.tmc.vuid.util.WuidUtil
import com.cloud.tmc.vuid.vtoken.AbstractVTokenAction
import com.google.gson.reflect.TypeToken
import com.tmc.network.HttpRequestor
import com.tmc.utils.LogUtil
import com.tmc.utils.ThreadPoolUtil
import java.lang.Exception
import java.lang.reflect.Type
import java.util.*


/**
 *  @author YANG LIN
 *  @Date 2021/12/09
 *  @descript:
 */

// 5小时
const val DIFF_TIMES = 3600 * 5 * 1000

internal class FileVTokenAction : AbstractVTokenAction() {

    override fun getLocalVTokenAndCheckTime(): String? {
        return when {
            checkLocalToken() -> getVTokenLocal()
            else -> null
        }
    }

    override fun checkLocalToken(): Boolean {
        val lastTokenTime = getLastTokenTime()
        val currentTimeMillis = System.currentTimeMillis()
        return lastTokenTime != 0L && (currentTimeMillis - lastTokenTime < DIFF_TIMES)
    }

    override fun getVTokenNow(vTokenListener: IVTokenListener?) {
        //从网络获取到新的 token  然后 回调
        ThreadPoolUtil.getInstance()?.executeRunable {
            val vTokenLocal = getVTokenLocal()
            when {
                vTokenLocal.isNullOrEmpty() -> requestVtoken(vTokenListener)
                else -> refreshNetworkVToken(vTokenLocal, vTokenListener)
            }
        }
    }

    override fun forceRequestToken(vTokenListener: IVTokenListener?) {
        ThreadUtils.executeBySingle(object : ThreadUtils.SimpleTask<String>() {
            override fun doInBackground(): String {
                try {
                    if (WuidUtil.sAdInfo == null) {
                        WuidUtil.getAdvertisingIdInfo(VUIDReal.getApplication())
                        return WuidUtil.getWuid() ?: ""
                    } else {
                        return WuidUtil.getWuid() ?: ""
                    }
                } catch (e: Exception) {
                    LogUtil.e(e)
                }
                return ""
            }

            override fun onSuccess(result: String?) {
                ThreadPoolUtil.getInstance()?.executeRunable {
                    requestVtoken(vTokenListener)
                }
            }

        })

    }

    private fun requestVtoken(vTokenListener: IVTokenListener?) {
        requestNetworkVToken(vTokenListener)
    }

    private val loginLockList: Vector<IVTokenListener?> = Vector()
    private fun requestNetworkVToken(vTokenListener: IVTokenListener?) {
        if (loginLockList.isNotEmpty()) {
            loginLockList.add(vTokenListener)
            return
        }
        loginLockList.add(vTokenListener)
        val map = mutableMapOf(
            KEY_WUID to getWUID(),
            KEY_BINDING_APP_ID to VUIDReal.getAppId(),
            KEY_PACKAGENAME to VUIDReal.getPackageName()
        )
        if (VUIDReal.getUid()?.isNotEmpty() == true) {
            map[KEY_BINDUID] = VUIDReal.getUid() ?: ""
        }
        HttpRequestor.getInstance()?.postJSON(URL_FEDERATED_LOGIN, null, null, map, object : ResponseCallback<LoginBean>() {
            override fun onSuccess(bean: BaseBean<LoginBean>) {
                saveVTokenLocal(bean.data?.vuidToken ?: "")
                saveVuidLocal(bean.data?.vuid ?: "")
                saveSuidLocal(bean.data?.suid ?: "")
                loginLockList.forEach { listener ->
                    listener?.onSuccess(bean.data?.vuidToken,true)
                }
                loginLockList.clear()
            }

            override fun onFail(fail: BaseBean<Any>) {
                vTokenListener?.onFailure(fail.code, fail.message)
                loginLockList.clear()
            }

            override fun getType(): Type {
                return object : TypeToken<BaseBean<LoginBean>>() {}.type
            }
        })
    }

    var errorReloadNum = 0
    private val refreshLockList: Vector<IVTokenListener?> = Vector()
    private fun refreshNetworkVToken(vToken: String, vTokenListener: IVTokenListener?) {
        if (refreshLockList.isNotEmpty()) {
            refreshLockList.add(vTokenListener)
            return
        }
        refreshLockList.add(vTokenListener)
        val map = mutableMapOf(KEY_VTOKEN to vToken)
        HttpRequestor.getInstance()?.postJSON(URL_REFRESH_TOKEN, null, null, map, object : ResponseCallback<RefreshBean>() {
            override fun onSuccess(bean: BaseBean<RefreshBean>) {
                saveVTokenLocal(bean.data?.newVuidToken ?: "")
                refreshLockList.forEach { listener ->
                    listener?.onSuccess(bean.data?.newVuidToken,true)
                }
                refreshLockList.clear()

            }

            override fun onFail(fail: BaseBean<Any>) {
                errorReloadNum++
                if (errorReloadNum < 3) {
                    refreshNetworkVToken(vToken, vTokenListener)
                } else {
                    vTokenListener?.onFailure(fail.code, fail.message)
                    errorReloadNum = 0
                }
                refreshLockList.clear()
            }

            override fun getType(): Type {
                return object : TypeToken<BaseBean<RefreshBean>>() {}.type
            }
        })
    }


}