package com.cloud.tmc.vuid.network

import com.cloud.tmc.vuid.BuildConfig
import com.cloud.tmc.vuid.util.WuidUtil
import com.google.gson.Gson


/**
 *  @author YANG LIN
 *  @Date 2021/12/16
 *  @descript:
 */

internal const val KEY_WUID = "wuid"  //等同于 gaid
internal const val KEY_HEADER_VTOKEN = "access-token"
internal const val KEY_VTOKEN = "vuidToken"
internal val KEY_VUIDS = "vuids"
internal val KEY_AUTHORIZATION = "authorization"
internal val KEY_BINDING_APP_ID = "bindingAppId"
internal val KEY_BINDUID = "bindingUid"
internal val KEY_PACKAGENAME = "packageName"


private const val BASE_URL = BuildConfig.BASE_COMMON_URL

//获取 vToken 接口
internal const val URL_FEDERATED_LOGIN = "${BASE_URL}sunnbird/member/v1/consumer-not-login/virtualUser/cmd/federatedLogin"

//刷新 vToken 接口
internal const val URL_REFRESH_TOKEN = "${BASE_URL}sunnbird/member/v1/consumer-not-login/virtualUser/cmd/refreshVuidToken"

//登出 vToken 接口
internal const val URL_SUNNBIRD_LOGOUT = "${BASE_URL}sunnbird/member/v1/consumer/virtualUser/cmd/loginOut"

internal const val URL_GAME_TRYING = "${BASE_URL}sunnbird/mission/v1/consumer-not-login/gametrying/cmd/gameTrying"

internal const val URL_BROWSER_MISSION = "${BASE_URL}sunnbird/mission/v1/consumer-not-login/missionaction/cmd/actionFinished"



internal fun getWUID() = WuidUtil.getWuid() ?: ""

internal fun getGson() = Gson()


/**服务请求解析code码**/
const val HTTP_GATE_WAY_TOKEN_ERROR = "GW.4401"//网关定义token失效码
const val HTTP_GATE_WAY_TERRITORY_ERROR = "GW.4451"//网关定义国内禁止访问
const val HTTP_PALM_TOKEN_ERROR = 40055 //palmId定义token失效
const val HTTP_GATE_WAY_EXCEPTION = -4
const val HTTP_SERVER_ERROR = -1
const val HTTP_RESPONSE_NULL = -2
const val HTTP_RESPONSE_EXCEPTION = -3
const val HTTP_TOKEN_ERROR = 401
const val HTTP_SUCCESS = 200
const val HTTP_TERRITORY_ERROR = 451
const val HTTP_TOKEN_EMPTY = -5