package com.cloud.tmc.vuid.util

import android.content.ComponentName
import android.content.ServiceConnection
import android.os.*
import com.tmc.utils.LogUtil
import java.util.concurrent.LinkedBlockingQueue


/**
 *  @author YANG LIN
 *  @Date 2022/02/16
 *  @descript:
 */
object WuidIdClient {


    class AdInfo internal constructor(
        private val advertisingId: String?,
        private val limitAdTrackingEnabled: Boolean
    ) {
        fun getId(): String? {
            return advertisingId
        }

        fun isLimitAdTrackingEnabled(): Boolean {
            return limitAdTrackingEnabled
        }
    }

    class AdvertisingConnection : ServiceConnection {
        var retrieved = false
        private val queue: LinkedBlockingQueue<IBinder?>? = LinkedBlockingQueue(
            1
        )

        override fun onServiceConnected(name: ComponentName?, service: IBinder?) {
            try {
                queue?.put(service)
            } catch (localInterruptedException: InterruptedException) {
                LogUtil.e(localInterruptedException)
            }
        }

        override fun onServiceDisconnected(name: ComponentName?) {}

        @Throws(InterruptedException::class)
        fun getBinder(): IBinder? {
            check(!retrieved)
            retrieved = true
            return queue?.take() as IBinder?
        }
    }

    class AdvertisingInterface internal constructor(private val binder: IBinder?) : IInterface {
        override fun asBinder(): IBinder? {
            return binder
        }

        @Throws(RemoteException::class)
        fun getId(): String? {
            val data = Parcel.obtain()
            val reply = Parcel.obtain()
            val id: String?
            id = try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService")
                binder?.transact(1, data, reply, 0)
                reply.readException()
                reply.readString()
            } finally {
                reply.recycle()
                data.recycle()
            }
            return id
        }

        @Throws(RemoteException::class)
        fun isLimitAdTrackingEnabled(paramBoolean: Boolean): Boolean {
            val data = Parcel.obtain()
            val reply = Parcel.obtain()
            val limitAdTracking: Boolean
            limitAdTracking = try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService")
                data.writeInt(if (paramBoolean) 1 else 0)
                binder?.transact(2, data, reply, 0)
                reply.readException()
                0 != reply.readInt()
            } finally {
                reply.recycle()
                data.recycle()
            }
            return limitAdTracking
        }
    }
}