package com.cloud.tmc.vuid.util

import android.content.Context
import android.content.Intent
import android.os.Looper
import com.tmc.utils.LogUtil
import com.tmc.utils.ThreadPoolUtil
import java.io.IOException
import java.lang.Exception


/**
 *  @author YANG LIN
 *  @Date 2022/02/16
 *  @descript:
 */
internal object WuidUtil {

    @Volatile
    var sAdInfo: WuidIdClient.AdInfo? = null
    fun getWuid(): String? {
        return if (sAdInfo == null) {
            return ""
        } else sAdInfo?.getId()
    }

    fun intAdvertisingIdInfo(context: Context?) {
        ThreadPoolUtil.Companion.getInstance()?.executeRunable(Runnable {
            try {
                getAdvertisingIdInfo(context)
            } catch (e: Exception) {
                LogUtil.e(e)
            }
        })
    }

    @Throws(Exception::class)
    fun getAdvertisingIdInfo(context: Context?) {
        check(Looper.myLooper() != Looper.getMainLooper()) { "Cannot be called from the main thread" }
        try {
            val pm = context?.getPackageManager()
            pm?.getPackageInfo("com.android.vending", 0)
        } catch (var12: Exception) {
            throw var12
        }
        val connection = WuidIdClient.AdvertisingConnection()
        val intent = Intent("com.google.android.gms.ads.identifier.service.START")
        intent.setPackage("com.google.android.gms")
        if (context?.bindService(intent, connection, Context.BIND_AUTO_CREATE) == true) {
            val var5: WuidIdClient.AdInfo
            var5 = try {
                val adInterface = WuidIdClient.AdvertisingInterface(connection.getBinder())
                val adInfo = WuidIdClient.AdInfo(
                    adInterface.getId(),
                    adInterface.isLimitAdTrackingEnabled(true)
                )
                adInfo
            } catch (var10: Exception) {
                throw var10
            } finally {
                context.unbindService(connection)
            }
            sAdInfo = var5
        } else {
            throw IOException("Google Play connection failed")
        }
    }
}