package com.cloud.tmc.vuid

import android.app.Application
import android.content.Context
import android.content.Intent
import android.net.Uri
import android.widget.Toast
import com.cloud.tmc.vuid.data.BaseBean
import com.cloud.tmc.vuid.impl.FileVTokenAction
import com.cloud.tmc.vuid.listener.*
import com.cloud.tmc.vuid.listener.IVTokenListener
import com.cloud.tmc.vuid.network.*
import com.cloud.tmc.vuid.network.KEY_HEADER_VTOKEN
import com.cloud.tmc.vuid.network.ResponseCallback
import com.cloud.tmc.vuid.network.URL_GAME_TRYING
import com.cloud.tmc.vuid.ui.activity.ActionActivity
import com.cloud.tmc.vuid.util.*
import com.cloud.tmc.vuid.util.WuidUtil
import com.cloud.tmc.vuid.util.getAppLanguage
import com.cloud.tmc.vuid.vtoken.AbstractVTokenAction
import com.cloud.tmc.vuid.vtoken.SP_SUID_LAST
import com.cloud.tmc.vuid.vtoken.SP_VTOKEN_LAST
import com.cloud.tmc.vuid.vtoken.SP_VUID_LAST
import com.google.gson.reflect.TypeToken
import com.cloud.tmc.vuid.networklite.network.HttpRequestor
import com.cloud.tmc.vuid.networklite.utils.LogUtil
import com.cloud.tmc.vuid.networklite.utils.ThreadPoolUtil
import java.lang.Exception
import java.lang.reflect.Type
import kotlin.properties.Delegates


/**
 *  @author YANG LIN
 *  @Date 2021/12/08
 *  @descript:
 */
internal object VUIDReal {
    private val vTokenAction: AbstractVTokenAction

    init {
        vTokenAction = FileVTokenAction()
    }

    private lateinit var APPLICATION: Application
    private var UID: String? = null
    private var APPID: String? = null
    private var COUNTRY_CODE: String? = null
    private var SCHEMA_URL: String? = null

    private var PACKAGE_NAME: String = ""

    private var mLoginListener: IJumpLoginListener? = null
    private var mGetPageExposureInfoListener: IGetPageExposureInfoListener? = null
    private var isLogined: Boolean = false
    private var isInit: Boolean = false
    private var testMode: Boolean = false


    fun init(app: Application, appId: String?, packageName: String?, init: Boolean) {
        isInit = true
        APPLICATION = app
        WuidUtil.intAdvertisingIdInfo(APPLICATION)
        if (appId.isNullOrEmpty()) {
            ThreadUtils.runOnUiThread {
                Toast.makeText(app, "Please set the appId", Toast.LENGTH_SHORT).show()
                LogUtil.e("Please set the appId")
            }
        }
        APPID = appId
        PACKAGE_NAME = if (packageName.isNullOrEmpty()) app.packageName else packageName
        if (init) {
            initHttpRequestor()
        }
        AthenaUtil.initAthena(APPLICATION)
    }

    fun getCountryCode(): String {
        return COUNTRY_CODE ?: ""
    }

    fun setCountryCode(countryCode: String?) {
        COUNTRY_CODE = countryCode
    }

    fun getSchemaUrl(): String {
        return SCHEMA_URL ?: ""
    }

    fun setSchemaUrl(schemaUrl: String?) {
        SCHEMA_URL = schemaUrl
    }

    fun setUid(uid: String, isLogined: Boolean) {
        if (!isInit) {
            LogUtil.e("Please initialize first...")
            return
        }
        vTokenAction.clearLocalVToken()
        UID = uid
        this.isLogined = isLogined
    }


    /**
     * @param listener 接入方设置强制登录回调
     */
    fun setJumpLoginListener(listener: IJumpLoginListener) {
        mLoginListener = listener
    }

    fun getJumpLoginListener(): IJumpLoginListener? {
        return mLoginListener
    }

    /**
     * @param listener 接入方获取页面曝光的活动ID和活动名称
     */
    fun setGetPageExposureInfoListener(listener: IGetPageExposureInfoListener) {
        mGetPageExposureInfoListener = listener
    }

    fun getPageExposureInfoListener(): IGetPageExposureInfoListener? {
        return mGetPageExposureInfoListener
    }

    /**
     *  判断宿主是否需要强制登录
     */
    fun isCheckHostLogined(): Boolean {
        if (mLoginListener != null) {
            return isLogined
        }
        return true
    }

    fun getUid(): String? {
        return UID
    }

    fun getAppId(): String {
        return APPID ?: ""
    }


    fun getApplication(): Application {
        return APPLICATION
    }

    fun getStorage(): SPUtils {
        return SPUtils.getInstance()
    }

    fun getLatestVToken(vTokenListener: IVTokenListener?) {
        vTokenAction.getVToken(vTokenListener)
    }

    private fun forceRequestToken() {
        vTokenAction.forceRequestToken(null)
    }

    fun getPackageName(): String {
        return PACKAGE_NAME
    }

    fun getLanguage(): String {
        return getAppLanguage(APPLICATION)
    }

    private var VUID: String = ""
    fun getVuidFromMemory(): String {
        return if (VUID.isEmpty()) getStorage().getString(SP_VUID_LAST, "") else VUID
    }

    fun setVuidToMemory(vuid: String) {
        VUID = vuid
    }

    private var SUID: String = ""
    fun getSuidFromMemory(): String {
        return if (SUID.isEmpty()) getStorage().getString(SP_SUID_LAST, "") else SUID
    }

    fun setSuidToMemory(suid: String) {
        SUID = suid
    }

    private var vToken: String = ""
    fun getVTokenFromMemory(): String {
        return if (vToken.isEmpty()) getStorage().getString(SP_VTOKEN_LAST, vToken) else vToken
    }

    fun setVTokenToMemory(token: String) {
        vToken = token
    }

    var notifyTokenRefresh: INotifyTokenRefresh? = null
    fun setTokenRefreshListener(listener: INotifyTokenRefresh?) {
        notifyTokenRefresh = listener
    }

    var retryCount = 0 //重试次数
    fun launchWeb(context: Context, webUrl: String) {
        retryCount = 0
        if (!isInit) {
            Toast.makeText(context, "Please initialize first...", Toast.LENGTH_SHORT).show()
            LogUtil.e("Please initialize first...")
            return
        }
//        if (getUid().isNullOrEmpty()) {
//            Toast.makeText(context, "uid not null", Toast.LENGTH_SHORT).show()
//            LogUtil.e("uid not null")
//            return
//        }
        getToken(context)
        ThreadUtils.runOnUiThread {
            ActionActivity.launch(context = context, webUrl)
        }
    }

    fun launchBrowser(context: Context?, url: String?) {
        if (context == null) {
            return
        }
        try {
            val intent = Intent()
            intent.action = "android.intent.action.VIEW"
            val content_url = Uri.parse(url)
            intent.data = content_url
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
            context.startActivity(intent)

        } catch (e: Exception) {
            LogUtil.e(e)
        }

    }


    fun getToken(context: Context) {
        getLatestVToken(object : IVTokenListener {
            override fun onSuccess(vtoken: String?, fromNetwork: Boolean) {
                notifyTokenRefresh?.onSuccess()
            }

            override fun onFailure(code: Int, msg: String?) {
                retryCount++
                if (retryCount < 3) {
                    getToken(context)
                    return
                }
                ThreadUtils.runOnUiThread {
                    LogUtil.e("$code $msg")
                    notifyTokenRefresh?.onError(code, msg)
                    Toast.makeText(context, msg, Toast.LENGTH_SHORT).show()
                }
            }
        })
    }

    fun logOut(listener: IVTokenLogoutListener?) {
        if (!isInit) {
            LogUtil.e("Please initialize first...")
            return
        }
        vTokenAction.logOut(listener)
    }

    private fun initHttpRequestor() {
        HttpRequestor.setLoggable(isTest())
        HttpRequestor.getInstance()?.setLanguage(getLanguage())
        HttpRequestor.getInstance()?.setIfTestWorkMode(isTest())

    }

    fun gameTrying(
        actionAuthCode: String?,
        tryingSecond: Long?,
        tryStartTime: String?,
        thirdTryingActionCode: String?
    ) {
        ThreadPoolUtil.getInstance()?.executeRunable {
            gameTryingRequest(actionAuthCode, tryingSecond, tryStartTime, thirdTryingActionCode)
        }
    }

    var errorGameTryingReloadNum = 0
    private fun gameTryingRequest(
        actionAuthCode: String?,
        tryingSecond: Long?,
        tryStartTime: String?,
        thirdTryingActionCode: String?
    ) {
        val map = mutableMapOf<String, Any>()
        if (actionAuthCode?.isNotEmpty() == true) {
            map["actionAuthCode"] = actionAuthCode
        }
        if (tryingSecond != null) {
            map["tryingSecond"] = tryingSecond
        }
        if (tryStartTime?.isNotEmpty() == true) {
            map["tryStartTime"] = tryStartTime
        }
        if (thirdTryingActionCode?.isNotEmpty() == true) {
            map["thirdTryingActionCode"] = thirdTryingActionCode
        }

        val header = mutableMapOf(KEY_HEADER_VTOKEN to VUIDReal.getVTokenFromMemory())

        HttpRequestor.getInstance()?.postJSON(URL_GAME_TRYING, header, null, map, object :
            ResponseCallback<Any>() {
            override fun onSuccess(bean: BaseBean<Any>) {
            }

            override fun onFail(fail: BaseBean<Any>) {
                errorGameTryingReloadNum++
                if (errorGameTryingReloadNum < 3) {
                    gameTryingRequest(
                        actionAuthCode,
                        tryingSecond,
                        tryStartTime,
                        thirdTryingActionCode
                    )
                }
            }

            override fun getType(): Type {
                return object : TypeToken<BaseBean<Any>>() {}.type
            }
        })

    }

    fun browserMission(
        actionAuthCode: String?,
        actionType: Int?,
        actionTime: String?,
        thirdActionCode: String?
    ) {
        ThreadPoolUtil.getInstance()?.executeRunable {
            browserMissionRequest(actionAuthCode, actionType, actionTime, thirdActionCode)
        }
    }

    var errorBrowserMissionReloadNum = 0
    private fun browserMissionRequest(
        actionAuthCode: String?,
        actionType: Int?,
        actionTime: String?,
        thirdActionCode: String?
    ) {
        val map = mutableMapOf<String, Any?>()
        if (actionAuthCode?.isNotEmpty() == true) {
            map["actionAuthCode"] = actionAuthCode
        }
        if (actionType != null) {
            map["actionType"] = actionType
        }
        if (actionTime?.isNotEmpty() == true) {
            map["actionTime"] = actionTime
        }
        if (thirdActionCode?.isNotEmpty() == true) {
            map["thirdActionCode"] = thirdActionCode
        }

        val header = mutableMapOf(KEY_HEADER_VTOKEN to VUIDReal.getVTokenFromMemory())

        HttpRequestor.getInstance()?.postJSON(URL_BROWSER_MISSION, header, null, map, object :
            ResponseCallback<Any>() {
            override fun onSuccess(bean: BaseBean<Any>) {
            }

            override fun onFail(fail: BaseBean<Any>) {
                errorBrowserMissionReloadNum++
                if (errorBrowserMissionReloadNum < 3) {
                    browserMissionRequest(actionAuthCode, actionType, actionTime, thirdActionCode)
                }
            }

            override fun getType(): Type {
                return object : TypeToken<BaseBean<Any>>() {}.type
            }
        })

    }

    fun setTest(testMode: Boolean) {
        this.testMode = testMode

    }

    fun isTest(): Boolean {
        return testMode
    }

    fun getBaseCommonUrl(): String {
        if (testMode) {
            return "http://api.test.sunnbird.com/"
        }
        return "https://api.sunnbird.com/"
    }

    fun getBaseH5Url(): String {
        if (testMode) {
            return "http://h5.test.sunnbird.com/"
        }
        return "https://h5.sunnbird.com/"
    }

}