package com.cloud.tmc.vuid.networklite.utils

import java.util.concurrent.ExecutorService
import java.util.concurrent.Executors
import java.util.concurrent.RejectedExecutionException

class ThreadPoolUtil private constructor() {
    private var mExecutorService: ExecutorService? = null

    private object ThreadPoolUtilsHolder {
        val instance: ThreadPoolUtil? = ThreadPoolUtil()
    }

    /**
     * 初始化线程池
     */
    private fun initThreadPool() {
        if (mExecutorService == null) {
            mExecutorService = Executors.newCachedThreadPool()
        }
    }

    /**
     * 执行任务
     *
     * @param runnable 任务
     */
    fun executeRunable(runnable: Runnable?) {
        try {
            if (!mExecutorService?.isShutdown()!!) {
                mExecutorService?.execute(runnable)
            }
        } catch (e: RejectedExecutionException) {
            // 打印当前线程池中活跃的线程数量
            LogUtil.e(e)
        }
    }

    /**
     * 关闭线程池
     */
    fun shutdownExecutor() {
        if (!mExecutorService?.isShutdown()!!) {
            mExecutorService!!.shutdown()
            mExecutorService = null
        }
    }

    companion object {
        fun getInstance(): ThreadPoolUtil? {
            return ThreadPoolUtilsHolder.instance
        }
    }

    /**
     * 私有化构造方法
     */
    init {
        initThreadPool()
    }
}