package com.cloud.tmc.vuid.ui.activity

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.viewbinding.ViewBinding
import com.cloud.tmc.vuid.util.StatusBarUtil
import kotlin.properties.Delegates


/**
 *  @author YANG LIN
 *  @Date 2021/12/13
 *  @descript:
 */
internal abstract class AbstractBaseActivity : AppCompatActivity() {
    protected var mBinding: ViewBinding by Delegates.notNull()
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mBinding = getBinding()
        setContentView(mBinding.root)
        StatusBarUtil.transparencyBar(this)
        initView(savedInstanceState)
    }

    abstract fun getBinding(): ViewBinding
    abstract fun initView(savedInstanceState: Bundle?)
}