package com.cloud.tmc.vuid.ui.view

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.ViewGroup
import android.widget.Button
import android.widget.FrameLayout
import com.cloud.tmc.vuid.R


/**
 *  @author YANG LIN
 *  @Date 2021/12/13
 *  @descript:
 */
class StatusLayout(context: Context, attributeSet: AttributeSet) : FrameLayout(context, attributeSet) {
    /** 主布局  */
    private var mMainLayout: ViewGroup? = null
    var mBtnReload: Button? = null

    /** 重试监听  */
    private var mListener: OnReloadListener? = null

    private fun initLayout() {
        mMainLayout = LayoutInflater.from(context).inflate(R.layout.layout_status_vuid, this, false) as ViewGroup
        mBtnReload = mMainLayout?.findViewById<Button>(R.id.error_reload_btn)
        mBtnReload?.setOnClickListener(mClickWrapper)
        addView(mMainLayout)
    }

    fun show() {
        if (mMainLayout == null) {
            //初始化布局
            initLayout()
        }
        if (isShow()) {
            return
        }
        mBtnReload?.visibility = if (mListener == null) INVISIBLE else VISIBLE
        // 显示布局
        mMainLayout?.visibility = VISIBLE
    }

    fun isShow(): Boolean {
        return mMainLayout != null && mMainLayout?.visibility == VISIBLE
    }

    fun hide() {
        if (mMainLayout == null || !isShow()) {
            return
        }
        mMainLayout?.visibility = INVISIBLE
    }


    /**
     * 设置重试监听器
     */
    fun setOnReloadListener(listener: OnReloadListener) {
        mListener = listener
        if (isShow()) {
            mBtnReload?.visibility = if (mListener == null) INVISIBLE else VISIBLE
        }
    }

    private val mClickWrapper = OnClickListener {
        if (mListener == null) {
            return@OnClickListener
        }
        mListener?.onReload(this@StatusLayout)
    }



    interface OnReloadListener {
        fun onReload(layout: StatusLayout)
    }
}