package com.cloud.tmc.vuid.util

import android.content.Context
import android.os.Bundle
import com.cloud.tmc.vuid.BuildConfig
import com.cloud.tmc.vuid.VUIDReal
import com.transsion.athenacust.AthenaCust
import com.transsion.ga.AthenaAnalytics


/**
 *  @author YANG LIN
 *  @Date 2022/03/07
 *  @descript:
 */
internal object AthenaUtil {

    //
    private const val TID = 4466
    fun initAthena(context: Context?) {
        //Athena初始化方法，建议在宿主应用的application.onCreate方法中调用，否则可能影响Athena功能
        //@param context 上下文
        //@param channel 渠道号 用户统计的维度(比如OS，GP等)，不确定可以填写应用名称
        //@param appId   appId tid/eid的前4位整数区分不同app，只能传四位整数
        //@param isDebug 开启日志
        //@param isHost  开启Crash/日活上报。如果是Application调用初始化函数，需要设置isHost为true。如果是library(比如广告、支付、推送等功能性SDK），需要设置isHost为false。对于isHost为true的模块，Athena SDK会自动采集并上报Crash信息（appid+7998/7999），日活信息(appid+9999)。
//        AthenaAnalytics.init(context, Settings.Global.APP_ID, Global.TID, BuildConfig.ATHENA_IS_DEBUG, true)
        AthenaAnalytics.init(context, VUIDReal.getPackageName(), TID, VUIDReal.isTest(), false)
        AthenaAnalytics.setTest(VUIDReal.isTest())
        AthenaAnalytics.setDebug(VUIDReal.isTest())
    }

    fun trackWebPage(bundle: Bundle) {
        AthenaCust("sunnbird_vuid_request", TID).trackCommon(bundle, null).submit()
    }

}