package com.cloud.tmc.vuid.util;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;

import com.cloud.tmc.vuid.VUID;
import com.cloud.tmc.vuid.VUIDReal;

/**
 * @author YANG LIN
 * @Date 2021/12/13
 * @descript:
 */
public class ClipboardUtils {

    private ClipboardUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    /**
     * Copy the text to clipboard.
     * <p>The label equals name of package.</p>
     *
     * @param text The text.
     */
    public static void copyText(final CharSequence text) {
        if (VUID.Companion.getApplication() == null) return;
        ClipboardManager cm = (ClipboardManager) VUID.Companion.getApplication().getSystemService(Context.CLIPBOARD_SERVICE);
        //noinspection ConstantConditions
        cm.setPrimaryClip(ClipData.newPlainText(VUID.Companion.getApplication().getPackageName(), text));
    }



    /**
     * Clear the clipboard.
     */
    public static void clear() {
        ClipboardManager cm = (ClipboardManager) VUIDReal.INSTANCE.getApplication().getSystemService(Context.CLIPBOARD_SERVICE);
        //noinspection ConstantConditions
        cm.setPrimaryClip(ClipData.newPlainText(null, ""));
    }


    /**
     * Return the text for clipboard.
     *
     * @return the text for clipboard
     */
    public static CharSequence getText() {
        ClipboardManager cm = (ClipboardManager) VUIDReal.INSTANCE.getApplication().getSystemService(Context.CLIPBOARD_SERVICE);
        //noinspection ConstantConditions
        ClipData clip = cm.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            CharSequence text = clip.getItemAt(0).coerceToText(VUIDReal.INSTANCE.getApplication());
            if (text != null) {
                return text;
            }
        }
        return "";
    }

    /**
     * Add the clipboard changed listener.
     */
    public static void addChangedListener(final ClipboardManager.OnPrimaryClipChangedListener listener) {
        ClipboardManager cm = (ClipboardManager) VUIDReal.INSTANCE.getApplication().getSystemService(Context.CLIPBOARD_SERVICE);
        //noinspection ConstantConditions
        cm.addPrimaryClipChangedListener(listener);
    }

    /**
     * Remove the clipboard changed listener.
     */
    public static void removeChangedListener(final ClipboardManager.OnPrimaryClipChangedListener listener) {
        ClipboardManager cm = (ClipboardManager) VUIDReal.INSTANCE.getApplication().getSystemService(Context.CLIPBOARD_SERVICE);
        //noinspection ConstantConditions
        cm.removePrimaryClipChangedListener(listener);
    }
}
