package com.cloud.tmc.vuid.vtoken

import com.cloud.tmc.vuid.VUIDReal
import com.cloud.tmc.vuid.data.BaseBean
import com.cloud.tmc.vuid.listener.IVTokenListener
import com.cloud.tmc.vuid.listener.IVTokenLogoutListener
import com.cloud.tmc.vuid.network.KEY_HEADER_VTOKEN
import com.cloud.tmc.vuid.network.ResponseCallback
import com.cloud.tmc.vuid.network.URL_SUNNBIRD_LOGOUT
import com.google.gson.reflect.TypeToken
import com.cloud.tmc.vuid.networklite.network.HttpRequestor
import com.cloud.tmc.vuid.networklite.utils.ThreadPoolUtil
import java.lang.reflect.Type


/**
 *  @author YANG LIN
 *  @Date 2021/12/09
 *  @descript:
 */
internal abstract class AbstractVTokenAction : VTokenCacheProvider, VTokenProvider {

    fun getVToken(vTokenListener: IVTokenListener?) {
        val vToken = getLocalVTokenAndCheckTime()
        when {
            vToken.isNullOrEmpty() -> getVTokenNow(vTokenListener)
            else -> vTokenListener?.onSuccess(vToken,false)
        }
    }

    fun logOut(listener: IVTokenLogoutListener?) {
        ThreadPoolUtil.getInstance()?.executeRunable {
            logoutVTokenRequest(listener)
        }
    }

    private fun logoutVTokenRequest(listener: IVTokenLogoutListener?) {
        val header = mutableMapOf(KEY_HEADER_VTOKEN to VUIDReal.getVTokenFromMemory())
        clearLocalVToken()
        HttpRequestor.getInstance()?.postJSON(URL_SUNNBIRD_LOGOUT, header, null, null, object : ResponseCallback<Any>() {
            override fun onSuccess(bean: BaseBean<Any>) {
                listener?.onSuccess()
            }

            override fun onFail(fail: BaseBean<Any>) {
                listener?.onFailure(fail.code, fail.message)
            }

            override fun getType(): Type {
                return object : TypeToken<BaseBean<Any>>() {}.type
            }
        })
    }


}