package com.cloud.tmc.vuid.listener

import com.cloud.tmc.vuid.ui.view.StatusLayout


/**
 *  @author YANG LIN
 *  @Date 2021/12/13
 *  @descript:
 */
internal interface StatusAction {

    fun getStatusLayout(): StatusLayout?
    fun showComplete() {
        val layout = getStatusLayout()
        if (layout == null || !layout.isShow()) {
            return
        }
        layout.hide()
    }

    fun showError(listener: StatusLayout.OnReloadListener) {
        val layout = getStatusLayout()
        layout?.show()
        layout?.setOnReloadListener(listener)
    }
}