package com.cloud.tmc.vuid.network

import com.cloud.tmc.vuid.data.BaseBean
import com.cloud.tmc.vuid.data.GatwayBean
import com.google.gson.reflect.TypeToken
import com.cloud.tmc.vuid.networklite.utils.LogUtil
import com.transsion.http.impl.StringCallback
import java.lang.Exception
import java.lang.reflect.Type


/**
 *  @author YANG LIN
 *  @Date 2021/12/16
 *  @descript:
 */

val failType = object : TypeToken<BaseBean<Any>>() {}.type
val gatewayType = object : TypeToken<GatwayBean>() {}.type

internal abstract class ResponseCallback<T> : StringCallback(true) {
    override fun onFailure(statusCode: Int, response: String?, e: Throwable?) {
        LogUtil.e(e)
        val failBean = BaseBean<Any>(HTTP_SERVER_ERROR, null, e.toString())
        onFail(failBean)
    }

    override fun onSuccess(statusCode: Int, responseStr: String?) {
        try {
            if (responseStr == null) {
                val failBean = BaseBean<Any>(HTTP_RESPONSE_NULL, null, "response body is null")
                onFail(failBean)
                LogUtil.i("onResponse body is null")
            } else if (responseStr.contains("error_code") == true) {
                val gatewayBean = getGson().fromJson<GatwayBean>(responseStr, gatewayType)
                onFail(getFailBean(gatewayBean))
            } else {
                if (statusCode == HTTP_SUCCESS){
                    onSuccess(getGson().fromJson(responseStr, getType()))
                }else{
                    onFail(getGson().fromJson(responseStr, failType))
                }
            }
        } catch (e: Exception) {
            LogUtil.i("onResponse e = $e")
            val failBean = BaseBean<Any>(HTTP_RESPONSE_EXCEPTION, null, "response Exception : $e")
            onFail(failBean)
        }
    }

    private fun getFailBean(gatewayBean: GatwayBean): BaseBean<Any> {
        return BaseBean(
            when (gatewayBean.error_code) {
                HTTP_GATE_WAY_TOKEN_ERROR -> HTTP_TOKEN_ERROR
                else -> HTTP_GATE_WAY_EXCEPTION
            },
            null,
            gatewayBean.error_message
        )
    }

    abstract fun onSuccess(bean: BaseBean<T>)
    abstract fun onFail(fail: BaseBean<Any>)
    abstract fun getType():Type
}