package com.cloud.tmc.vuid.vtoken

import com.cloud.tmc.vuid.VUIDReal


/**
 *  @author YANG LIN
 *  @Date 2021/12/09
 *  @descript:
 */

const val SP_VTOKEN_LAST_TIME = "vTokenTime"
const val SP_VTOKEN_LAST = "vTokenInfo"
const val SP_VUID_LAST = "vtoken_vuid"
const val SP_SUID_LAST = "vtoken_suid"

internal interface VTokenCacheProvider {
    fun getLocalVTokenAndCheckTime(): String?
    fun saveVuidLocal(vuid: String){
        VUIDReal.setVuidToMemory(vuid)
        VUIDReal.getStorage().put(SP_VUID_LAST, vuid)
    }
    fun saveSuidLocal(suid: String){
        VUIDReal.setSuidToMemory(suid)
        VUIDReal.getStorage().put(SP_SUID_LAST, suid)
    }
    fun saveVTokenLocal(vToken: String) {
        VUIDReal.setVTokenToMemory(vToken)
        VUIDReal.getStorage().put(SP_VTOKEN_LAST, vToken)
        setLastTokenTime(System.currentTimeMillis())
    }
    fun getVTokenLocal(): String? {
        val vToken = VUIDReal.getStorage().getString(SP_VTOKEN_LAST)
        VUIDReal.setVTokenToMemory(vToken ?: "")
        return vToken
    }

    fun setLastTokenTime(time: Long) {
        VUIDReal.getStorage().put(SP_VTOKEN_LAST_TIME, time)
    }

    fun getLastTokenTime(): Long {
        return VUIDReal.getStorage().getLong(SP_VTOKEN_LAST_TIME, 0L)
    }

    fun clearLocalVToken() {
        VUIDReal.setVTokenToMemory("")
        VUIDReal.setVuidToMemory("")
        VUIDReal.setSuidToMemory("")
        VUIDReal.getStorage().put(SP_VTOKEN_LAST, "")
        VUIDReal.getStorage().put(SP_SUID_LAST, "")
        VUIDReal.getStorage().put(SP_VUID_LAST, "")
        clearVTokenTime()
    }


    private fun clearVTokenTime() {
        VUIDReal.getStorage().put(SP_VTOKEN_LAST_TIME, 0L)
    }

    fun checkLocalToken(): Boolean

}