package com.cloud.tmc.vuid

import android.app.Activity
import android.app.Application
import android.content.Context
import com.cloud.tmc.vuid.listener.IGetPageExposureInfoListener
import com.cloud.tmc.vuid.listener.IJumpLoginListener
import com.cloud.tmc.vuid.listener.INotifyTokenRefresh
import com.cloud.tmc.vuid.listener.IVTokenListener
import com.cloud.tmc.vuid.util.ThreadUtils
import com.tmc.corewebview.ActionWebView
import org.jetbrains.annotations.NotNull
import kotlin.properties.Delegates


/**
 *  @author YANG LIN
 *  @Date 2021/12/08
 *  @descript: VUID sdk
 */
class VUID private constructor() {

    companion object {

        private var APPLICATION: Application by Delegates.notNull()

        //浏览任务 行为类型 1:浏览
        const val ACTION_TYPE_BROWSER = 1

        //浏览任务 行为类型 2:游戏下载
        const val ACTION_TYPE_GAME_DOWNLOAD = 2

        //浏览任务 行为类型 3:活动任务(录音)
        const val ACTION_TYPE_ACTIVITY_MISSION = 3

        /**
         * 跳转到指定活动页面
         * @param mActivity 当前的 Activity
         * @param webUrl 活动 URL 链接
         **/
        fun launchWebActivity(@NotNull mActivity: Activity, @NotNull webUrl: String?) {
            ThreadUtils.runOnUiThread {
                ActionWebView.setDebug(VUIDReal.isTest())
                VUIDReal.launchWeb(mActivity, webUrl ?: "")
            }
        }

        /**
         *  跳转到奖品列表页面
         * @param mActivity 当前的 Activity
         **/
        fun launchAwardListCenter(@NotNull mActivity: Activity) {
            launchWebActivity(mActivity, "${VUIDReal.getBaseH5Url()}activity/awardlist")
        }

        /**
         *  跳转到aha活动页
         * @param mActivity 当前的 Activity
         **/
        fun launchAhaActivity(@NotNull mActivity: Activity) {
            launchWebActivity(mActivity, "${VUIDReal.getBaseH5Url()}activity/aha")
        }

        /**
         *  跳转到xshare活动页
         * @param mActivity 当前的 Activity
         **/
        fun launchXShareActivity(@NotNull mActivity: Activity) {
            launchWebActivity(mActivity, "${VUIDReal.getBaseH5Url()}activity/xshare")
        }

        fun getApplication(): Application {
            return APPLICATION
        }

        /**
         *  设置接入方用户 uid
         * @param uid 设置用户 ID
         * @param isLogined 是否是登录状态
         */
        fun setUID(@NotNull uid: String?, isLogined: Boolean) {
            VUIDReal.setUid(uid ?: "", isLogined)
        }

        /**
         *  设置用户当前国家码
         * @param countryCode 设置国家码  例如中国为CN，尼日利亚为NG
         */
        fun setCounutryCode(@NotNull countryCode: String?) {
            VUIDReal.setCountryCode(countryCode)
        }

        /**
         *  设置 SchemaUrl 用于分享，打开宿主 APP
         * @param SchemaUrl 打开宿主 APP 的链接
         */
        fun setSchemaUrl(@NotNull SchemaUrl: String?) {
            VUIDReal.setSchemaUrl(SchemaUrl)
        }

        /**
         * 登出 VUID
         */
        fun logOut() {
            VUIDReal.logOut(null)
        }

        /**
         * 领取奖品前让用户强制登录
         * @param listener 强制登录回调
         */
        fun setJumpLoginListener(@NotNull listener: IJumpLoginListener?) {
            if (listener == null) return
            VUIDReal.setJumpLoginListener(listener)
        }

        /**
         * 获取页面曝光的活动ID和活动名称
         * @param listener 获取页面曝光的活动ID和活动名称回调
         */
        fun setGetPageExposureInfoListener(@NotNull listener: IGetPageExposureInfoListener?) {
            if (listener == null) return
            VUIDReal.setGetPageExposureInfoListener(listener)
        }

        /**
         * 游戏试玩 VUID
         * @param actionAuthCode 行为授权码
         * @param tryingSecond 试玩秒数
         * @param tryStartTime 开始时间
         * @param thirdTryingActionCode 试玩流水号
         */
        @JvmOverloads
        fun gameTrying(
            actionAuthCode: String?,
            tryingSecond: Long?,
            tryStartTime: String? = "",
            thirdTryingActionCode: String? = ""
        ) {
            VUIDReal.gameTrying(actionAuthCode, tryingSecond, tryStartTime, thirdTryingActionCode)
        }

        /**
         * 浏览任务 VUID
         * @param actionAuthCode 行为授权码
         * @param actionTime actionTime
         * @param actionType 行为类型 1:浏览2:游戏下载3:活动任务(录音)
         * @param thirdActionCode 流水号
         */
        @JvmOverloads
        fun browserMission(
            actionAuthCode: String?,
            actionType: Int?,
            actionTime: String? = "",
            thirdActionCode: String? = ""
        ) {
            VUIDReal.browserMission(actionAuthCode, actionType, actionTime, thirdActionCode)
        }

        /**
         * 获取vToken(可能通过网络获取)
         */
        fun getToken(context: Context) {
            if (VUIDReal.getAppId().isNotBlank()) {
                VUIDReal.getToken(context)
            }
        }

        /**
         * 获取vToken带回调
         */
        fun getLatestVToken(vTokenListener: IVTokenListener?) {
            if (VUIDReal.getAppId().isNotBlank()) {
                VUIDReal.getLatestVToken(vTokenListener)
            }
        }

        /**
         * 注册token更新的监听
         */
        fun setTokenRefreshListener(listener: INotifyTokenRefresh?) {
            VUIDReal.setTokenRefreshListener(listener)
        }

        /**
         * 获取vToken(本地缓存的)
         */
        fun getVTokenFromMemory(): String {
            return VUIDReal.getVTokenFromMemory()
        }

        /**
         * 页面展示信息
         */
        fun getPageExposureInfo(activityId: String?, activityName: String?) {
            VUIDReal.getPageExposureInfoListener()?.getPageExposureInfo(activityId, activityName)
        }
    }

    class Builder(private val app: Application) {
        private var mAppId: String? = null
        private var mPackageName: String? = null
        private var mInit: Boolean = true

        /**
         * @param appId 请设置 AppId
         **/
        fun setAppId(@NotNull appId: String?): Builder {
            mAppId = appId
            return this
        }

        /**
         * @param packageName 请设置包名
         **/
        fun setPackageName(@NotNull packageName: String?): Builder {
            mPackageName = packageName
            return this
        }

        /**
         *  设置测试环境
         */
        fun setTest(testMode:Boolean):Builder {
            VUIDReal.setTest(testMode)
            return this
        }

        /**
         * 设置是否初始化 SDK 内部网关
         *@param 默认为使用 SDK 内部网关
         */
        fun initHttpRequestor(init: Boolean) {
            mInit = init
        }

        fun build() {
            APPLICATION = app
            VUIDReal.init(
                app = app, appId = mAppId,
                packageName = mPackageName, mInit
            )
        }
    }

}