package com.cloud.tmc.vuid.listener

import android.webkit.JavascriptInterface
import com.cloud.tmc.vuid.BuildConfig
import com.cloud.tmc.vuid.VUIDReal
import com.cloud.tmc.vuid.network.getWUID
import com.cloud.tmc.vuid.util.ThreadUtils
import com.tmc.corewebview.CoreJsBridge


/**
 *  @author YANG LIN
 *  @Date 2021/12/13
 *  @descript:
 */
abstract class ActionJsHelper : CoreJsBridge() {
    @JavascriptInterface
    fun getLanguage(): String? {
        return VUIDReal.getLanguage()
    }

    @JavascriptInterface
    fun getGaid(): String? {
        return getWUID()
    }


    @JavascriptInterface
    fun getVuid(): String? {
        return VUIDReal.getVuidFromMemory()
    }

    @JavascriptInterface
    fun getCountryCode(): String? {
        return VUIDReal.getCountryCode()
    }

    @JavascriptInterface
    fun getSchemaUrl(): String? {
        return VUIDReal.getSchemaUrl()
    }

    @JavascriptInterface
    fun isCheckHostLogined(): Boolean? {
        return VUIDReal.isCheckHostLogined()
    }
    @JavascriptInterface
    fun jumpHostLogin() {
        ThreadUtils.runOnUiThread {
            VUIDReal.getJumpLoginListener()?.jumpLogin()
        }
    }

    @JavascriptInterface
    fun getSDKVersionNum(): String? {
        return BuildConfig.VUID_SDK_VERSION_NUM
    }

    @JavascriptInterface
    fun getAppVersion(): String? {
        return BuildConfig.VUID_SDK_VERSION
    }

    @JavascriptInterface
    fun getSuid(): String? {
        return VUIDReal.getSuidFromMemory()
    }
}