package com.cloud.tmc.vuid.ui.activity

import android.app.Activity
import android.content.ClipboardManager
import android.content.Context
import android.content.Intent
import android.graphics.Bitmap
import android.graphics.Color
import android.graphics.Rect
import android.os.Build
import android.os.Bundle
import android.util.Log
import android.view.View
import android.view.Window
import android.view.WindowManager
import android.webkit.*
import android.widget.FrameLayout
import android.widget.LinearLayout
import android.widget.Toast
import androidx.viewbinding.ViewBinding
import com.cloud.tmc.vuid.VUIDReal
import com.cloud.tmc.vuid.databinding.ActivityActionVuidBinding
import com.cloud.tmc.vuid.listener.ActionJsHelper
import com.cloud.tmc.vuid.listener.INotifyTokenRefresh
import com.cloud.tmc.vuid.listener.IVTokenListener
import com.cloud.tmc.vuid.listener.StatusAction
import com.cloud.tmc.vuid.ui.view.StatusLayout
import com.cloud.tmc.vuid.util.*
import com.cloud.tmc.vuid.util.isLightColor
import com.cloud.tmc.vuid.networklite.utils.LogUtil
import com.tmc.hlks.utils.HAthenaUtil
import com.tmc.corewebview.ActionWebView
import com.tmc.corewebview.ActionWebViewClient
import java.lang.Exception
import kotlin.math.abs
import kotlin.properties.Delegates
import android.view.ViewGroup
import android.webkit.WebView

const val BUNDLE_WEB_URL = "web_url";

internal class ActionActivity : AbstractBaseActivity(), StatusAction {

    var webUrl: String by Delegates.notNull()
    private var binding: ActivityActionVuidBinding by Delegates.notNull()
    private var mWebView: ActionWebView? = null
    private var title = ""
    var isBackPage = true

    private var ATHENA_LOAD_STATUS = 0
    private val ATHENA_LOAD_STATUS_SUCCESS = 1
    private val ATHENA_LOAD_STATUS_ERROR = 2
    private var ATHENA_LOAD_DURATION = 0L // 页面加载的时间
    private var ATHENA_UPLOAD_URL: String? = "" //上报当前 url 地址
    private var ATHENA_EVENT_TS = 0L //页面启动时间戳
    private var ATHENA_BACK_PRESS = false // 用户是否执行回退动作
    private var ATHENA_FINISH_UPLOAD = false // 用户是否已经上传数据

    private var startTime: Long = 0


    override fun getBinding(): ViewBinding {
        return ActivityActionVuidBinding.inflate(layoutInflater)
    }

    var copyCode: String? = null
    var copyCodeCallback: String? = null
    fun copyToClipboard(code: String?, js: String?) {
        copyCode = code
        copyCodeCallback = js
        ClipboardUtils.addChangedListener(listener)
        ClipboardUtils.copyText(code)
    }

    val listener: ClipboardManager.OnPrimaryClipChangedListener = object : ClipboardManager.OnPrimaryClipChangedListener {
        override fun onPrimaryClipChanged() {
            if (ClipboardUtils.getText() == copyCode) {
                copyCodeCallback?.let {
                    mWebView?.loadUrl("javascript:${it}()")
                }
            }
            ClipboardUtils.removeChangedListener(this)
        }
    }

    override fun initView(savedInstanceState: Bundle?) {
        binding = mBinding as ActivityActionVuidBinding
        fixAndroidBug5497(this.window)
        webUrl = intent.getStringExtra(BUNDLE_WEB_URL) ?: ""
        HAthenaUtil.trackWebViewLoadCountEvent(webUrl)
        val titleLayoutParams = binding.layoutTitle.layoutParams as LinearLayout.LayoutParams
        val statusBarHeight: Int = StatusBarUtil.getStatusBarHeight()
        titleLayoutParams.setMargins(0, statusBarHeight, 0, 0)

        if (webUrl.contains("isNativeHeader=true")) {
            showNativeTitleLayout(binding, statusBarHeight)
        } else {
            showWebTitleLayout(binding, statusBarHeight)
        }

        if (webUrl.contains("isBackPage=false")) {
            isBackPage = false
        }

        if (!webUrl.contains("isNativeLoading=false")) {
            binding.pbBrowserProgress.visibility = View.VISIBLE
        }
        binding.imBack.setOnClickListener { view -> onBackPressed() }
        if (sWebview == null) {
            mWebView = ActionWebView(this)
            initJs(mWebView, webUrl)
        } else {
            mWebView = sWebview
        }
        if (mWebView?.parent != null) {
            (mWebView?.parent as ViewGroup).removeView(mWebView)
        }
        binding.wvPay.addView(mWebView)

        mWebView?.setOnLongClickListener {
            LogUtil.i("long click")
            true
        }

        VUIDReal.setTokenRefreshListener(object : INotifyTokenRefresh {
            override fun onSuccess() {
                ThreadUtils.runOnUiThread {
                    LogUtil.i("javascript:tokenSuccess")
                    mWebView?.loadUrl("javascript:tokenSuccess()")
                }
            }

            override fun onError(code: Int, msg: String?) {
                LogUtil.i("javascript:tokenError")
//                mWebView?.loadUrl("javascript:tokenError()")
                ThreadUtils.runOnUiThread {
                    Toast.makeText(VUIDReal.getApplication(), "${code},${msg}", Toast.LENGTH_SHORT).show()
                    finish()
                }

            }

        })

        mWebView?.webChromeClient = object : WebChromeClient() {
            override fun onReceivedTitle(view: WebView, title: String) {
                super.onReceivedTitle(view, title)
                if (title.isEmpty() || view.url?.contains(title) == true) {
                    return
                }
                this@ActionActivity.title = title
            }

            override fun onProgressChanged(view: WebView, newProgress: Int) {
                super.onProgressChanged(view, newProgress)
                binding.pbBrowserProgress.progress = newProgress
                if (newProgress == 100) {
                    if (!ATHENA_FINISH_UPLOAD && ATHENA_LOAD_STATUS != ATHENA_LOAD_STATUS_ERROR) { //没有上传过，并且没有失败回调
                        ATHENA_UPLOAD_URL = view.url
                        ATHENA_LOAD_DURATION = System.currentTimeMillis()
                        ATHENA_LOAD_STATUS = ATHENA_LOAD_STATUS_SUCCESS
                        athenaUpload()
                    }
                    ThreadUtils.runOnUiThreadDelayed({
                        binding.pbBrowserProgress.visibility = View.GONE
                    }, 300)
                }
            }
        }
        ATHENA_EVENT_TS = System.currentTimeMillis()
        ATHENA_UPLOAD_URL = webUrl
        if (sWebview == null) {
            mWebView?.webViewClient = LoadingWebViewClent(this)
            mWebView?.loadUrl(webUrl)
        }
    }

    private fun showNativeTitleLayout(webviewBinding: ActivityActionVuidBinding?, statusBarHeight: Int) {
        val titleLayoutParams = webviewBinding?.layoutTitle?.layoutParams as LinearLayout.LayoutParams
        titleLayoutParams.setMargins(0, statusBarHeight, 0, 0)
        //        webviewBinding.layoutContent.setPadding(0, statusBarHeight, 0, 0);
        webviewBinding.layoutTitle.visibility = View.VISIBLE
    }

    private fun showWebTitleLayout(webviewBinding: ActivityActionVuidBinding?, statusBarHeight: Int) {
        webviewBinding?.layoutTitle?.visibility = View.GONE
        webviewBinding?.llContent?.setPadding(0, statusBarHeight, 0, 0)
        webviewBinding?.root?.setBackgroundColor(Color.WHITE)
    }


    inner class LoadingWebViewClent(var context: Context) : ActionWebViewClient(context) {
        override fun shouldOverrideUrlLoading(view: WebView?, url: String?): Boolean {
            webUrl = url ?: ""
            return super.shouldOverrideUrlLoading(view, url)
        }

        override fun onPageStarted(view: WebView?, url: String?, favicon: Bitmap?) {
            super.onPageStarted(view, url, favicon)
            startTime = System.currentTimeMillis()
        }


        override fun onPageFinished(view: WebView, url: String) {
            val webviewBinding = mBinding as? ActivityActionVuidBinding
            webviewBinding?.tvTitle?.text = title
            showComplete()
            if (mWebView?.progress == 100) {
                val loadingTime = System.currentTimeMillis() - startTime
                HAthenaUtil.trackWebViewLoadTime(this@ActionActivity,url,loadingTime)
            }
        }

        override fun onReceivedError(view: WebView?, errorCode: Int, description: String?, failingUrl: String?) {
            super.onReceivedError(view, errorCode, description, failingUrl)
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                return
            }
            ATHENA_LOAD_STATUS = ATHENA_LOAD_STATUS_ERROR
            ATHENA_LOAD_DURATION = System.currentTimeMillis()
            athenaUpload()
            ThreadUtils.runOnUiThreadDelayed({
                showError(object : StatusLayout.OnReloadListener {
                    override fun onReload(layout: StatusLayout) {
                        mWebView?.reload()
                    }

                })
            }, 200)
        }

        override fun onReceivedError(view: WebView?, request: WebResourceRequest?, error: WebResourceError?) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP && request?.isForMainFrame == true) {
                ATHENA_LOAD_STATUS = ATHENA_LOAD_STATUS_ERROR
                ATHENA_LOAD_DURATION = System.currentTimeMillis()
                athenaUpload()
                ThreadUtils.runOnUiThreadDelayed({
                    showError(object : StatusLayout.OnReloadListener {
                        override fun onReload(layout: StatusLayout) {
                            mWebView?.reload()
                        }

                    })
                }, 200)
            }
        }
    }

    private fun athenaUpload() {
        if (ATHENA_FINISH_UPLOAD) {
            LogUtil.i("Athena repeat upload...")
            return
        }
        ATHENA_FINISH_UPLOAD = true
        val bundle = Bundle()
        bundle.putLong("event_ts", ATHENA_EVENT_TS)
        bundle.putString("vuid", VUIDReal.getVuidFromMemory())
        val dur = when (ATHENA_LOAD_STATUS) {
            ATHENA_LOAD_STATUS_SUCCESS -> {
                bundle.putInt("status", 1)
                ATHENA_LOAD_DURATION - ATHENA_EVENT_TS
            }
            ATHENA_LOAD_STATUS_ERROR -> {
                bundle.putInt("status", 0)
                bundle.putString("error", "timeout")
                ATHENA_LOAD_DURATION - ATHENA_EVENT_TS
            }
            else -> {
                bundle.putInt("status", 0)
                bundle.putString("error", "manual")
                System.currentTimeMillis() - ATHENA_EVENT_TS
            }
        }
        bundle.putLong("dur", dur)
        bundle.putString("url", ATHENA_UPLOAD_URL)
        bundle.putString("channel_type", VUIDReal.getPackageName())
        AthenaUtil.trackWebPage(bundle)
    }

    override fun onBackPressed() {
        if (isBackPage && mWebView?.canGoBack() == true) {
            mWebView?.goBack()
        } else {
            ATHENA_BACK_PRESS = true
            finish()
        }
    }

    //是否在webview 页面退到后台
    var isBackground = false
    override fun onStop() {
        super.onStop()
        isBackground = true
    }

    override fun onResume() {
        super.onResume()
        if (isBackground) {
            isBackground = false
            VUIDReal.getLatestVToken(object : IVTokenListener {
                override fun onSuccess(vtoken: String?, fromNetwork: Boolean) {
                    if (fromNetwork) {
                        ThreadUtils.runOnUiThread {
                            mWebView?.reload()
                        }
                    }
                }

                override fun onFailure(code: Int, msg: String?) {

                }

            })

        }
    }

    override fun onDestroy() {
        athenaUpload()
        VUIDReal.setTokenRefreshListener(null)
        super.onDestroy()
        webDestroy()
        releaseWeb(false)
    }

    private fun webDestroy() {
        // 停止加载网页
        mWebView?.stopLoading()
        // 清除历史记录
        mWebView?.clearHistory()
        // 取消监听引用
        mWebView?.webChromeClient = null
        // 移除WebView所有的View对象
        mWebView?.removeAllViews()
        // 销毁此的WebView的内部状态
        mWebView?.destroy()
    }

    companion object {
        var sWebview: ActionWebView? = null

        fun launch(context: Context, webUrl: String) {
            val intent = Intent(context, ActionActivity::class.java)
            intent.putExtra(BUNDLE_WEB_URL, webUrl)
            if (context !is Activity) {
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
            }
            context.startActivity(intent)
        }

        fun prepareWeb(context: Context, webUrl: String) {
            sWebview = ActionWebView(context)
            initJs(sWebview, webUrl)
            sWebview?.loadUrl(webUrl)
        }

        fun releaseWeb(ifDestroy: Boolean) {
            if (sWebview == null) {
                return
            }
            if (sWebview?.parent != null) {
                (sWebview?.parent as ViewGroup).removeView(sWebview)
            }
            if (ifDestroy) {
                // 停止加载网页
                sWebview?.stopLoading()
                // 清除历史记录
                sWebview?.clearHistory()
                // 取消监听引用
                sWebview?.webChromeClient = null
                // 移除WebView所有的View对象
                sWebview?.removeAllViews()
                // 销毁此的WebView的内部状态
                sWebview?.destroy()
            }
            sWebview = null
        }

        fun initJs(mWebView: ActionWebView?, webUrl: String) {
            val jsName = "login"
            ActionWebView.setJsHelper(jsName, object : ActionJsHelper() {
                @JavascriptInterface
                fun copyCode(code: String, js: String) {
                    ThreadUtils.runOnUiThread {
                        if (mWebView == null || mWebView.parent == null) {
                            return@runOnUiThread
                        }
                        var activity = (mWebView.parent as ViewGroup).context as ActionActivity
                        activity.copyToClipboard(code, js)
                    }
                }

                @JavascriptInterface
                fun getToken(): String? {
                    return VUIDReal.getVTokenFromMemory()
                }

                @JavascriptInterface
                override fun getSystemInfo(): String? {
                    return ""
                }

                @JavascriptInterface
                override fun goBack() {
                    ThreadUtils.runOnUiThread {
                        if (mWebView == null || mWebView.parent == null) {
                            return@runOnUiThread
                        }
                        var activity = (mWebView.parent as ViewGroup).context as ActionActivity
                        activity.ATHENA_BACK_PRESS = true
                        if (activity.isBackPage && mWebView?.canGoBack() == true) {
                            mWebView?.goBack()
                        } else {
                            activity.finish()
                        }
                    }
                }

                @JavascriptInterface
                fun openNewWebView(url: String?) {
                    if (url.isNullOrEmpty()) return
                    ThreadUtils.runOnUiThread {
                        if (mWebView == null || mWebView.parent == null) {
                            return@runOnUiThread
                        }
                        VUIDReal.launchWeb((mWebView.parent as ViewGroup).context, url)
                    }
                }

                @JavascriptInterface
                fun setStatusBarColor(colorValue: String?) {
                    ThreadUtils.runOnUiThread {
                        try {
                            if (mWebView == null || mWebView.parent == null) {
                                return@runOnUiThread
                            }
                            var activity = (mWebView.parent as ViewGroup).context as ActionActivity
                            val colorNum = Color.parseColor(colorValue)
                            val lightColor = isLightColor(colorNum)
                            StatusBarUtil.setStatusBarLightMode(activity, lightColor)
                            StatusBarUtil.setStatusBarColor(activity.window, colorNum)
                        } catch (e: Exception) {
                            LogUtil.e(e)
                        }
                    }
                }

                @JavascriptInterface
                fun shareBySchemaUrl(url: String?) {
                    ThreadUtils.runOnUiThread {
                        if (mWebView == null || mWebView.parent == null) {
                            return@runOnUiThread
                        }
                        var activity = (mWebView.parent as ViewGroup).context as ActionActivity
                        openSchemeUrl(activity, url)
                    }
                }

                @JavascriptInterface
                fun getPageExposureInfo(activityId: String?, activityName: String?) {
                    VUIDReal.getPageExposureInfoListener()
                        ?.getPageExposureInfo(activityId, activityName)
                }

                @JavascriptInterface
                fun nativeDoTask(dumpUrlType: Int, url: String?) {
                    ThreadUtils.runOnUiThread {
                        if (mWebView == null || mWebView.parent == null) {
                            return@runOnUiThread
                        }
                        var activity = (mWebView.parent as ViewGroup).context as ActionActivity
                        activity.jumpRouter(dumpUrlType, url)
                    }

                }
            })
        }
    }

    override fun getStatusLayout(): StatusLayout {
        return binding?.layoutContent
    }

    private fun fixAndroidBug5497(window: Window) {
        val softInputMode = window.attributes.softInputMode
        window.setSoftInputMode(
            softInputMode and WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE.inv()
        )
        val contentView = window.findViewById<FrameLayout>(android.R.id.content)
        val contentViewChild = contentView.getChildAt(0)
        val paddingBottom = contentViewChild.paddingBottom
        val contentViewInvisibleHeightPre5497 = intArrayOf(getContentViewInvisibleHeight(window))
        contentView.viewTreeObserver.addOnGlobalLayoutListener {
            val height = getContentViewInvisibleHeight(window)
            if (contentViewInvisibleHeightPre5497[0] != height) {
                contentViewChild.setPadding(
                    contentViewChild.paddingLeft,
                    contentViewChild.paddingTop, contentViewChild.paddingRight,
                    paddingBottom + getDecorViewInvisibleHeight(window)
                )
                contentViewInvisibleHeightPre5497[0] = height
            }
        }
    }

    private var sDecorViewDelta = 0
    private fun getDecorViewInvisibleHeight(window: Window): Int {
        val decorView = window.decorView
        val outRect = Rect()
        decorView.getWindowVisibleDisplayFrame(outRect)
        Log.d(
            "KeyboardUtils",
            "getDecorViewInvisibleHeight: " + (decorView.bottom - outRect.bottom)
        )
        val delta = abs(decorView.bottom - outRect.bottom)
        if (delta <= StatusBarUtil.getNavBarHeight(this) + StatusBarUtil.getStatusBarHeight()) {
            sDecorViewDelta = delta
            return 0
        }
        return delta - sDecorViewDelta
    }

    private fun getContentViewInvisibleHeight(window: Window): Int {
        val contentView = window.findViewById<View>(android.R.id.content) ?: return 0
        val outRect = Rect()
        contentView.getWindowVisibleDisplayFrame(outRect)
        Log.d(
            "KeyboardUtils",
            "getContentViewInvisibleHeight: " + (contentView.bottom - outRect.bottom)
        )
        val delta = abs(contentView.bottom - outRect.bottom)
        return if (delta <= StatusBarUtil.getStatusBarHeight() + StatusBarUtil.getNavBarHeight(this)) {
            0
        } else delta
    }

    private fun jumpRouter(type: Int, url: String?) {
        when (type) {
            1 -> {
                url?.let { VUIDReal.launchWeb(this@ActionActivity, it) }
            }
            2 -> {
                VUIDReal.launchBrowser(this@ActionActivity, url)
            }
            3 -> {
                openSchemeUrl(this@ActionActivity, url)
            }
        }
    }
}