/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.tmc.vuid.util;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import android.widget.Toast;
import androidx.annotation.ColorRes;
import androidx.core.content.ContextCompat;
import com.cloud.tmc.vuid.R;
import com.cloud.tmc.vuid.VUID;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0019\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\b\u0010\t\u001a\u0019\u0010\f\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a!\u0010\u0016\u001a\u00020\u00152\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Landroid/app/Application;", "application", "", "getAppLanguage", "(Landroid/app/Application;)Ljava/lang/String;", "Landroid/content/res/Configuration;", "configuration", "Ljava/util/Locale;", "getLocal", "(Landroid/content/res/Configuration;)Ljava/util/Locale;", "", "id", "getColor", "(I)I", "color", "", "isLightColor", "(I)Z", "Landroid/content/Context;", "context", "url", "", "openSchemeUrl", "(Landroid/content/Context;Ljava/lang/String;)V", "corevuid_release"})
public final class MixUtilsKt {
    @NotNull
    public static final String getAppLanguage(@NotNull Application object) {
        Application application = object;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Configuration configuration = application.getResources().getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"application.resources.configuration");
        object = MixUtilsKt.getLocal(configuration);
        if (object != null) {
            object = ((Locale)object).getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n        local.language\n    }");
        } else {
            object = "";
        }
        return object;
    }

    private static final Locale getLocal(Configuration configuration) {
        return Build.VERSION.SDK_INT >= 24 ? configuration.getLocales().get(0) : configuration.locale;
    }

    private static final int getColor(@ColorRes int n) {
        return ContextCompat.getColor((Context)VUID.Companion.getApplication(), (int)n);
    }

    public static final boolean isLightColor(int n) {
        return 1.0 - ((double)Color.red((int)n) * 0.299 + (double)Color.green((int)n) * 0.587 + (double)Color.blue((int)n) * 0.114) / (double)255 < 0.5;
    }

    public static final void openSchemeUrl(@Nullable Context context, @Nullable String string2) {
        if (!(string2 == null || StringsKt.isBlank((CharSequence)string2)) && context != null) {
            Intent intent;
            block6: {
                Intent intent2;
                Context context2 = context;
                intent = intent2;
                String string3 = string2;
                string2 = "android.intent.action.VIEW";
                intent2 = new Intent(string2, Uri.parse((String)string3));
                if (context2 instanceof Activity) break block6;
                intent.addFlags(0x10000000);
            }
            try {
                context.startActivity(intent);
            }
            catch (Exception exception) {
                Toast.makeText((Context)context, (int)R.string.text_uninstall_app_hint_vuid, (int)1).show();
            }
            return;
        }
    }
}

