/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.tmc.vuid.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b#\u0010$J!\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0019\u0010\u001b\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0016\u0010!\u001a\u00020 8\u0002@\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b!\u0010\"\u00a8\u0006%"}, d2={"Lcom/cloud/tmc/vuid/util/StatusBarUtil;", "", "Landroid/content/Context;", "context", "", "color", "Landroid/view/View;", "createStatusBarView", "(Landroid/content/Context;I)Landroid/view/View;", "Landroid/view/Window;", "window", "", "transparentStatusBar", "(Landroid/view/Window;)V", "", "isLightMode", "setStatusBarLightMode", "(Landroid/view/Window;Z)V", "setStatusBarColor", "(Landroid/view/Window;I)Landroid/view/View;", "getStatusBarHeight", "()I", "dp", "dp2px", "(Landroid/content/Context;I)I", "Landroid/app/Activity;", "activity", "transparencyBar", "(Landroid/app/Activity;)V", "(Landroid/app/Activity;Z)V", "getNavBarHeight", "(Landroid/content/Context;)I", "", "TAG_STATUS_BAR", "Ljava/lang/String;", "<init>", "()V", "corevuid_release"})
public final class StatusBarUtil {
    @NotNull
    public static final StatusBarUtil INSTANCE = new StatusBarUtil();
    @NotNull
    private static final String TAG_STATUS_BAR = "TAG_STATUS_BAR";

    private StatusBarUtil() {
    }

    private final View createStatusBarView(Context context, int n) {
        View view = new View(context);
        view.setLayoutParams(new ViewGroup.LayoutParams(-1, this.getStatusBarHeight()));
        view.setBackgroundColor(n);
        view.setTag((Object)TAG_STATUS_BAR);
        return view;
    }

    private final void transparentStatusBar(Window window) {
        int n = Build.VERSION.SDK_INT;
        if (n < 19) {
            return;
        }
        if (n >= 21) {
            Window window2 = window;
            window2.clearFlags(0x4000000);
            window2.addFlags(Integer.MIN_VALUE);
            n = window2.getDecorView().getSystemUiVisibility();
            window2.getDecorView().setSystemUiVisibility(n | 0x500);
            window2.setStatusBarColor(0);
        } else {
            window.addFlags(0x4000000);
        }
    }

    private final void setStatusBarLightMode(Window window, boolean bl) {
        StatusBarUtil statusBarUtil = window.getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)statusBarUtil, (String)"window.decorView");
        int n = statusBarUtil.getSystemUiVisibility();
        n = bl ? (n |= 0x2000) : (n &= 0xFFFFDFFF);
        statusBarUtil.setSystemUiVisibility(n);
    }

    @Nullable
    public final View setStatusBarColor(@NotNull Window window, int n) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        statusBarUtil2.transparentStatusBar(window);
        View view = window.findViewById(0x1020002);
        if (view != null) {
            View view2 = (view = (ViewGroup)view).findViewWithTag((Object)TAG_STATUS_BAR);
            if (view2 != null) {
                if (view2.getVisibility() == 8) {
                    view2.setVisibility(0);
                }
                view2.setBackgroundColor(n);
            } else {
                StatusBarUtil statusBarUtil = statusBarUtil2;
                StatusBarUtil statusBarUtil2 = window.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)statusBarUtil2, (String)"window.context");
                view2 = statusBarUtil.createStatusBarView((Context)statusBarUtil2, n);
                view.addView(view2);
            }
            return view2;
        }
        throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
    }

    public final int getStatusBarHeight() {
        int n;
        block3: {
            n = 0;
            int n2 = Resources.getSystem().getIdentifier("status_bar_height", "dimen", "android");
            if (n2 <= 0) break block3;
            try {
                n = Resources.getSystem().getDimensionPixelSize(n2);
            }
            catch (Resources.NotFoundException notFoundException) {
                notFoundException.printStackTrace();
            }
        }
        return n;
    }

    public final int dp2px(@Nullable Context context, int n) {
        int n2;
        if (context == null) {
            n2 = 0;
        } else {
            float f = n;
            context = context.getResources().getDisplayMetrics();
            n2 = (int)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)context);
        }
        return n2;
    }

    @TargetApi(value=19)
    public final void transparencyBar(@Nullable Activity activity) {
        if (activity == null) {
            return;
        }
        int n = Build.VERSION.SDK_INT;
        if (n >= 21) {
            Window window = activity.getWindow();
            window.clearFlags(0x4000000);
            window.getDecorView().setSystemUiVisibility(1280);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0);
        } else if (n >= 19) {
            activity.getWindow().setFlags(0x4000000, 0x4000000);
        }
        this.setStatusBarLightMode(activity, true);
    }

    public final void setStatusBarLightMode(@NotNull Activity activity, boolean bl) {
        StatusBarUtil statusBarUtil = statusBarUtil2;
        Activity activity2 = activity;
        Intrinsics.checkNotNullParameter((Object)activity2, (String)"activity");
        StatusBarUtil statusBarUtil2 = activity2.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)statusBarUtil2, (String)"activity.window");
        statusBarUtil.setStatusBarLightMode((Window)statusBarUtil2, bl);
    }

    public final int getNavBarHeight(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        StatusBarUtil statusBarUtil = context2.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)statusBarUtil, (String)"context.resources");
        int n = statusBarUtil.getIdentifier("navigation_bar_height", "dimen", "android");
        return n != 0 ? statusBarUtil.getDimensionPixelSize(n) : 0;
    }
}

