/*
 * Decompiled with CFR 0.152.
 */
package com.tmc.webview;

import android.content.Context;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u000b"}, d2={"Lcom/tmc/webview/CollectionUtil;", "", "()V", "getLanguage", "", "resources", "Landroid/content/res/Resources;", "isNetworkConnected", "", "context", "Landroid/content/Context;", "com.tmc.webview"})
public final class CollectionUtil {
    @NotNull
    public static final CollectionUtil INSTANCE = new CollectionUtil();

    private CollectionUtil() {
    }

    public final boolean isNetworkConnected(@Nullable Context context) {
        if (context != null) {
            Object object = context.getApplicationContext().getSystemService("connectivity");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
            }
            ConnectivityManager mConnectivityManager = (ConnectivityManager)object;
            NetworkInfo mNetworkInfo = mConnectivityManager.getActiveNetworkInfo();
            if (mNetworkInfo != null) {
                return mNetworkInfo.isAvailable();
            }
        }
        return false;
    }

    @NotNull
    public final String getLanguage(@NotNull Resources resources) {
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        Locale locale = null;
        locale = Build.VERSION.SDK_INT >= 24 ? resources.getConfiguration().getLocales().get(0) : resources.getConfiguration().locale;
        String string = locale.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"locale.language");
        return string;
    }
}

