package com.tmc.webview

import android.annotation.SuppressLint
import android.content.*
import android.net.ConnectivityManager
import android.os.Build
import android.text.TextUtils
import android.view.ViewGroup
import android.util.AttributeSet
import android.webkit.*

open class ActionWebView : WebView {
    constructor(context: Context) : super(context)
    @SuppressLint("JavascriptInterface")
    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        setWebContentsDebuggingEnabled(sIfDebug)
        val webSettings = settings
        if (webSettings != null) {
            webSettings.setUserAgentString(
                webSettings
                    .userAgentString
                        + USERAGENT_AGENTWEB + USERAGENT_UC
            )
            webSettings.javaScriptEnabled = true
            webSettings.setSupportZoom(true)
            webSettings.builtInZoomControls = false
            webSettings.savePassword = false
            if (isNetworkConnected(context)) {
                //根据cache-control获取数据。
                webSettings.cacheMode = WebSettings.LOAD_DEFAULT
            } else {
                //没网，则从本地获取，即离线加载
                webSettings.cacheMode = WebSettings.LOAD_CACHE_ELSE_NETWORK
            }
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                //适配5.0不允许http和https混合使用情况
                webSettings.mixedContentMode = WebSettings.MIXED_CONTENT_ALWAYS_ALLOW
                setLayerType(LAYER_TYPE_HARDWARE, null)
            } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                setLayerType(LAYER_TYPE_HARDWARE, null)
            } else if (Build.VERSION.SDK_INT < Build.VERSION_CODES.KITKAT) {
                setLayerType(LAYER_TYPE_SOFTWARE, null)
            }
            webSettings.textZoom = 100
            webSettings.databaseEnabled = true
            webSettings.setAppCacheEnabled(true)
            webSettings.loadsImagesAutomatically = true
            webSettings.setSupportMultipleWindows(false)
            // 是否阻塞加载网络图片  协议http or https
            webSettings.blockNetworkImage = false
            // 允许加载本地文件html  file协议
            webSettings.allowFileAccess = true
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                // 通过 file url 加载的 Javascript 读取其他的本地文件 .建议关闭
                webSettings.allowFileAccessFromFileURLs = false
                // 允许通过 file url 加载的 Javascript 可以访问其他的源，包括其他的文件和 http，https 等其他的源
                webSettings.allowUniversalAccessFromFileURLs = false
            }
            webSettings.javaScriptCanOpenWindowsAutomatically = true
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                webSettings.layoutAlgorithm = WebSettings.LayoutAlgorithm.SINGLE_COLUMN
            } else {
                webSettings.layoutAlgorithm = WebSettings.LayoutAlgorithm.NORMAL
            }
            //            webSettings.setLoadWithOverviewMode(false);
//            webSettings.setUseWideViewPort(false);
            webSettings.domStorageEnabled = true
            webSettings.setNeedInitialFocus(true)
            webSettings.defaultTextEncodingName = "utf-8" //设置编码格式
            webSettings.defaultFontSize = 16
            webSettings.minimumFontSize = 12 //设置 WebView 支持的最小字体大小，默认为 8
            webSettings.setGeolocationEnabled(true)
            val dir = getCachePath(getContext())
            //设置数据库路径  api19 已经废弃,这里只针对 webkit 起作用
            webSettings.setGeolocationDatabasePath(dir)
            webSettings.databasePath = dir
            webSettings.setAppCachePath(dir)
            //缓存文件最大值
            webSettings.setAppCacheMaxSize(Long.MAX_VALUE)
            webSettings.javaScriptEnabled = true
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                webSettings.mixedContentMode = WebSettings.MIXED_CONTENT_ALWAYS_ALLOW
            }
            webSettings.useWideViewPort = true
            webSettings.loadWithOverviewMode = true
        }
        if (sCoreJsBridge != null && !TextUtils.isEmpty(sJsName)) {
            addJavascriptInterface(sCoreJsBridge!!, sJsName!!)
        }
        if (sWebViewClient != null) {
            setWebViewClient(sWebViewClient!!)
        } else {
            webViewClient = ActionWebViewClient(context)
        }
    }

    fun isNetworkConnected(context: Context?): Boolean {
        if (context != null) {
            val mConnectivityManager = context
                .getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
            val mNetworkInfo = mConnectivityManager.activeNetworkInfo
            if (mNetworkInfo != null) {
                return mNetworkInfo.isAvailable
            }
        }
        return false
    }

    override fun destroy() {
        sWebViewClient = null
        setJsHelper(null, null)
        loadDataWithBaseURL(null, "", "text/html", "utf-8", null)
        (parent as ViewGroup).removeView(this)
        super.destroy()
    }

    companion object {
        val CACHE_PATCH: String? = "/web"
        val USERAGENT_AGENTWEB: String? = " Web "
        val USERAGENT_UC: String? = " UCBrowser/11.6.4.950 "
        var sWebViewClient: WebViewClient? = null
        var sIfDebug: Boolean = false

        @JvmStatic
        fun setDebug(ifDebug: Boolean) {
            sIfDebug = ifDebug
        }

        @JvmStatic
        fun setClient(webViewClient: WebViewClient?) {
            sWebViewClient = webViewClient
        }

        private var sCoreJsBridge: CoreJsBridge? = null

        private var sJsName: String? = null

        @JvmStatic
        fun setJsHelper(name: String?, coreJsBridge: CoreJsBridge?) {
            sCoreJsBridge = coreJsBridge
            sJsName = name
        }

        @JvmStatic
        fun getCachePath(context: Context?): String? {
            return context?.getCacheDir()?.absolutePath + CACHE_PATCH
        }
    }
}