package com.tmc.corewebview

import android.content.*
import android.content.pm.PackageManager
import android.webkit.WebView
import android.webkit.WebViewClient
import android.net.Uri
import android.text.TextUtils
import android.util.Log
import java.io.PrintWriter
import java.io.StringWriter
import java.lang.Exception


open class ActionWebViewClient(private val context: Context?) : WebViewClient() {
    override fun shouldOverrideUrlLoading(view: WebView?, url: String?): Boolean {
        if (url == null) {
            return false
        }


        if (url.startsWith(HTTP_SCHEME) || url.startsWith(HTTPS_SCHEME)) {
            return false
        }
        if (handleCommonLink(url)) {
            return true
        }
        if (url.startsWith(INTENT_SCHEME)) {
            handleIntentUrl(url)
            return true
        }
        if (url.startsWith(WEBCHAT_PAY_SCHEME)) {
            startActivity(url)
            return true
        }
        if (url.startsWith(ALIPAYS_SCHEME) && lookup(url)) {
            return true
        }
        return if (queryActiviesNumber(url) > 0 && deepLink(url)) {
            true
        } else super.shouldOverrideUrlLoading(view, url)
    }

    private fun handleIntentUrl(intentUrl: String?) {
        try {
            if (TextUtils.isEmpty(intentUrl) || !intentUrl!!.startsWith(INTENT_SCHEME)) {
                return
            }
            if (lookup(intentUrl)) {
                return
            }
        } catch (e: Throwable) {
            e(e)
        }
    }

    private fun handleCommonLink(url: String?): Boolean {
        if (url == null) {
            return false
        }

        if (url.startsWith(WebView.SCHEME_TEL)
            || url.startsWith(SCHEME_SMS)
            || url.startsWith(WebView.SCHEME_MAILTO)
            || url.startsWith(WebView.SCHEME_GEO)
        ) {
            try {
                val intent = Intent(Intent.ACTION_VIEW)
                intent.data = Uri.parse(url)
                context?.startActivity(intent)
            } catch (ignored: ActivityNotFoundException) {
                e(ignored)
            }
            return true
        }
        return false
    }

    private fun lookup(url: String?): Boolean {
        try {
            val intent: Intent?
            val packageManager = context?.getPackageManager()
            intent = Intent.parseUri(url, Intent.URI_INTENT_SCHEME)
            val info = packageManager?.resolveActivity(intent, PackageManager.MATCH_DEFAULT_ONLY)
            // 跳到该应用
            if (info != null) {
                context?.startActivity(intent)
                return true
            }
        } catch (e: Throwable) {
            e(e)
        }
        return false
    }

    private fun queryActiviesNumber(url: String?): Int {
        try {
            val intent = Intent.parseUri(url, Intent.URI_INTENT_SCHEME)
            val mPackageManager = context?.getPackageManager()
            val mResolveInfos =
                mPackageManager?.queryIntentActivities(intent, PackageManager.MATCH_DEFAULT_ONLY)
            return mResolveInfos?.size ?: 0
        } catch (e: Throwable) {
            e(e)
        }
        return 0
    }

    private fun deepLink(url: String?): Boolean {
        //看是否需要管理跳转到其他APP
        return lookup(url)
    }

    private fun startActivity(url: String?) {
        try {
            val intent = Intent()
            intent.action = Intent.ACTION_VIEW
            intent.data = Uri.parse(url)
            context?.startActivity(intent)
        } catch (e: Exception) {
            e(e)
        }
    }

    fun e(e: Throwable?) {
        val sw = StringWriter()
        PrintWriter(sw).use { pw -> e?.printStackTrace(pw) }
        Log.e("ActionWebViewClient", sw.toString())
    }

    companion object {
        val HTTP_SCHEME: String = "http://"
        val HTTPS_SCHEME: String = "https://"
        val INTENT_SCHEME: String = "intent://"
        val WEBCHAT_PAY_SCHEME: String = "weixin://wap/pay?"
        val ALIPAYS_SCHEME: String = "alipays://"
        val SCHEME_SMS: String = "sms:"
    }
}