/*
 * Decompiled with CFR 0.152.
 */
package com.tmc.corewebview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.tmc.corewebview.ActionWebViewClient;
import com.tmc.corewebview.CollectionUtil;
import com.tmc.corewebview.CoreJsBridge;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lcom/tmc/corewebview/ActionWebView;", "Landroid/webkit/WebView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "destroy", "", "init", "Companion", "com.tmc.corewebview"})
public class ActionWebView
extends WebView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static final String CACHE_PATCH = "/web";
    @Nullable
    private static final String USERAGENT_AGENTWEB = " Web ";
    @Nullable
    private static final String USERAGENT_UC = " UCBrowser/11.6.4.950 ";
    @Nullable
    private static WebViewClient sWebViewClient;
    private static boolean sIfDebug;
    @Nullable
    private static CoreJsBridge sCoreJsBridge;
    @Nullable
    private static String sJsName;

    public ActionWebView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.init();
    }

    @SuppressLint(value={"JavascriptInterface"})
    public ActionWebView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.init();
    }

    private final void init() {
        WebView.setWebContentsDebuggingEnabled((boolean)sIfDebug);
        WebSettings webSettings = this.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)webSettings, (String)"settings");
        WebSettings webSettings2 = webSettings;
        webSettings2.setUserAgentString(webSettings2.getUserAgentString() + USERAGENT_AGENTWEB + USERAGENT_UC);
        webSettings2.setJavaScriptEnabled(true);
        webSettings2.setSupportZoom(true);
        webSettings2.setBuiltInZoomControls(false);
        webSettings2.setSavePassword(false);
        if (CollectionUtil.INSTANCE.isNetworkConnected(this.getContext())) {
            webSettings2.setCacheMode(-1);
        } else {
            webSettings2.setCacheMode(1);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings2.setMixedContentMode(0);
            this.setLayerType(2, null);
        } else if (Build.VERSION.SDK_INT >= 19) {
            this.setLayerType(2, null);
        } else if (Build.VERSION.SDK_INT < 19) {
            this.setLayerType(1, null);
        }
        webSettings2.setTextZoom(100);
        webSettings2.setDatabaseEnabled(true);
        webSettings2.setAppCacheEnabled(true);
        webSettings2.setLoadsImagesAutomatically(true);
        webSettings2.setSupportMultipleWindows(false);
        webSettings2.setBlockNetworkImage(false);
        webSettings2.setAllowFileAccess(true);
        if (Build.VERSION.SDK_INT >= 16) {
            webSettings2.setAllowFileAccessFromFileURLs(false);
            webSettings2.setAllowUniversalAccessFromFileURLs(false);
        }
        webSettings2.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 19) {
            webSettings2.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        } else {
            webSettings2.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        }
        webSettings2.setDomStorageEnabled(true);
        webSettings2.setNeedInitialFocus(true);
        webSettings2.setDefaultTextEncodingName("utf-8");
        webSettings2.setDefaultFontSize(16);
        webSettings2.setMinimumFontSize(12);
        webSettings2.setGeolocationEnabled(true);
        String dir = Companion.getCachePath(this.getContext());
        webSettings2.setGeolocationDatabasePath(dir);
        webSettings2.setDatabasePath(dir);
        webSettings2.setAppCachePath(dir);
        webSettings2.setAppCacheMaxSize(Long.MAX_VALUE);
        webSettings2.setJavaScriptEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings2.setMixedContentMode(0);
        }
        webSettings2.setUseWideViewPort(true);
        webSettings2.setLoadWithOverviewMode(true);
        if (sCoreJsBridge != null && !TextUtils.isEmpty((CharSequence)sJsName)) {
            CoreJsBridge coreJsBridge = sCoreJsBridge;
            Intrinsics.checkNotNull((Object)coreJsBridge);
            String string = sJsName;
            Intrinsics.checkNotNull((Object)string);
            this.addJavascriptInterface(coreJsBridge, string);
        }
        if (sWebViewClient != null) {
            WebViewClient webViewClient = sWebViewClient;
            Intrinsics.checkNotNull((Object)webViewClient);
            this.setWebViewClient(webViewClient);
        } else {
            this.setWebViewClient(new ActionWebViewClient(this.getContext()));
        }
    }

    public void destroy() {
        sWebViewClient = null;
        Companion.setJsHelper(null, null);
        this.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
        ViewParent viewParent = this.getParent();
        if (viewParent == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ((ViewGroup)viewParent).removeView((View)this);
        super.destroy();
    }

    @JvmStatic
    public static final void setDebug(boolean ifDebug) {
        Companion.setDebug(ifDebug);
    }

    @JvmStatic
    public static final void setClient(@Nullable WebViewClient webViewClient) {
        Companion.setClient(webViewClient);
    }

    @JvmStatic
    public static final void setJsHelper(@Nullable String name, @Nullable CoreJsBridge coreJsBridge) {
        Companion.setJsHelper(name, coreJsBridge);
    }

    @JvmStatic
    @Nullable
    public static final String getCachePath(@Nullable Context context) {
        return Companion.getCachePath(context);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0007J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0015H\u0007J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u000eH\u0007J\u001c\u0010\"\u001a\u00020\u001e2\b\u0010#\u001a\u0004\u0018\u00010\u00042\b\u0010$\u001a\u0004\u0018\u00010\fH\u0007R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0016\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lcom/tmc/corewebview/ActionWebView$Companion;", "", "()V", "CACHE_PATCH", "", "getCACHE_PATCH", "()Ljava/lang/String;", "USERAGENT_AGENTWEB", "getUSERAGENT_AGENTWEB", "USERAGENT_UC", "getUSERAGENT_UC", "sCoreJsBridge", "Lcom/tmc/corewebview/CoreJsBridge;", "sIfDebug", "", "getSIfDebug", "()Z", "setSIfDebug", "(Z)V", "sJsName", "sWebViewClient", "Landroid/webkit/WebViewClient;", "getSWebViewClient", "()Landroid/webkit/WebViewClient;", "setSWebViewClient", "(Landroid/webkit/WebViewClient;)V", "getCachePath", "context", "Landroid/content/Context;", "setClient", "", "webViewClient", "setDebug", "ifDebug", "setJsHelper", "name", "coreJsBridge", "com.tmc.corewebview"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getCACHE_PATCH() {
            return CACHE_PATCH;
        }

        @Nullable
        public final String getUSERAGENT_AGENTWEB() {
            return USERAGENT_AGENTWEB;
        }

        @Nullable
        public final String getUSERAGENT_UC() {
            return USERAGENT_UC;
        }

        @Nullable
        public final WebViewClient getSWebViewClient() {
            return sWebViewClient;
        }

        public final void setSWebViewClient(@Nullable WebViewClient webViewClient) {
            sWebViewClient = webViewClient;
        }

        public final boolean getSIfDebug() {
            return sIfDebug;
        }

        public final void setSIfDebug(boolean bl) {
            sIfDebug = bl;
        }

        @JvmStatic
        public final void setDebug(boolean ifDebug) {
            this.setSIfDebug(ifDebug);
        }

        @JvmStatic
        public final void setClient(@Nullable WebViewClient webViewClient) {
            this.setSWebViewClient(webViewClient);
        }

        @JvmStatic
        public final void setJsHelper(@Nullable String name, @Nullable CoreJsBridge coreJsBridge) {
            sCoreJsBridge = coreJsBridge;
            sJsName = name;
        }

        @JvmStatic
        @Nullable
        public final String getCachePath(@Nullable Context context) {
            File file;
            Context context2 = context;
            return Intrinsics.stringPlus(context2 == null ? null : ((file = context2.getCacheDir()) == null ? null : file.getAbsolutePath()), (Object)this.getCACHE_PATCH());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

