/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.exo;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.view.Surface;
import android.view.SurfaceHolder;
import androidx.media3.common.PlaybackException;
import androidx.media3.common.PlaybackParameters;
import androidx.media3.common.Player;
import androidx.media3.common.VideoSize;
import androidx.media3.common.util.Clock;
import androidx.media3.exoplayer.DefaultLoadControl;
import androidx.media3.exoplayer.DefaultRenderersFactory;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.LoadControl;
import androidx.media3.exoplayer.RenderersFactory;
import androidx.media3.exoplayer.analytics.AnalyticsCollector;
import androidx.media3.exoplayer.analytics.AnalyticsListener;
import androidx.media3.exoplayer.analytics.DefaultAnalyticsCollector;
import androidx.media3.exoplayer.source.DefaultMediaSourceFactory;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.trackselection.DefaultTrackSelector;
import androidx.media3.exoplayer.trackselection.MappingTrackSelector;
import androidx.media3.exoplayer.trackselection.TrackSelector;
import androidx.media3.exoplayer.upstream.BandwidthMeter;
import androidx.media3.exoplayer.upstream.DefaultBandwidthMeter;
import androidx.media3.exoplayer.util.EventLogger;
import androidx.media3.exoplayer.video.PlaceholderSurface;
import com.talpa.exo.ExoMediaSourceHelper;
import com.talpa.tplayer_core.config.VideoViewConfig;
import com.talpa.tplayer_core.tplayer.AbstractPlayer;
import com.talpa.tplayer_core.tplayer.VideoViewManager;
import com.talpa.tplayer_core.util.ExtensionKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\"H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0010H\u0016J\u0010\u0010*\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0010H\u0016J\u0010\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020 H\u0016J\u0010\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020(H\u0016J\b\u00101\u001a\u00020(H\u0016J\u0010\u00102\u001a\u00020(2\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020(2\u0006\u00106\u001a\u00020%H\u0016J\b\u00107\u001a\u00020(H\u0016J\b\u00108\u001a\u00020(H\u0016J\b\u00109\u001a\u00020(H\u0016J\b\u0010:\u001a\u00020(H\u0016J\u0010\u0010;\u001a\u00020(2\u0006\u0010<\u001a\u00020\"H\u0016J\u0012\u0010=\u001a\u00020(2\b\u0010>\u001a\u0004\u0018\u00010?H\u0016J0\u0010=\u001a\u00020(2\b\u0010@\u001a\u0004\u0018\u00010\f2\u0014\u0010A\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010B\u001a\u00020\u0010H\u0016J\u0012\u0010C\u001a\u00020(2\b\u0010D\u001a\u0004\u0018\u00010EH\u0016J\u0010\u0010F\u001a\u00020(2\b\u0010G\u001a\u0004\u0018\u00010\u0013J\u0010\u0010H\u001a\u00020(2\u0006\u0010I\u001a\u00020\u0010H\u0016J\b\u0010J\u001a\u00020(H\u0016J\u0010\u0010K\u001a\u00020(2\b\u0010L\u001a\u0004\u0018\u00010\u0019J\u0010\u0010M\u001a\u00020(2\u0006\u0010N\u001a\u00020%H\u0016J\u0012\u0010O\u001a\u00020(2\b\u0010P\u001a\u0004\u0018\u00010QH\u0016J\u0010\u0010R\u001a\u00020(2\b\u0010S\u001a\u0004\u0018\u00010\u001dJ\u0018\u0010T\u001a\u00020(2\u0006\u0010U\u001a\u00020%2\u0006\u0010V\u001a\u00020%H\u0016J\b\u0010W\u001a\u00020(H\u0016J\b\u0010X\u001a\u00020(H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00158\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00178\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lcom/talpa/exo/ExoMediaPlayer;", "Lcom/talpa/tplayer_core/tplayer/AbstractPlayer;", "Landroidx/media3/common/Player$Listener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "dummySurface", "Landroidx/media3/exoplayer/video/PlaceholderSurface;", "mHeaders", "", "", "mInternalPlayer", "Landroidx/media3/exoplayer/ExoPlayer;", "mIsPlaying", "", "mIsPreparing", "mLoadControl", "Landroidx/media3/exoplayer/LoadControl;", "mMediaSource", "Landroidx/media3/exoplayer/source/MediaSource;", "mMediaSourceHelper", "Lcom/talpa/exo/ExoMediaSourceHelper;", "mRenderersFactory", "Landroidx/media3/exoplayer/RenderersFactory;", "mSpeedPlaybackParameters", "Landroidx/media3/common/PlaybackParameters;", "mTrackSelector", "Landroidx/media3/exoplayer/trackselection/TrackSelector;", "mUrl", "getBufferedPercentage", "", "getCurrentPosition", "", "getDuration", "getSpeed", "", "getTcpSpeed", "initPlayer", "", "isPlaying", "onIsPlayingChanged", "onPlaybackStateChanged", "playbackState", "onPlayerError", "error", "Landroidx/media3/common/PlaybackException;", "onRenderedFirstFrame", "onSeekProcessed", "onVideoSizeChanged", "videoSize", "Landroidx/media3/common/VideoSize;", "onVolumeChanged", "volume", "pause", "prepareAsync", "release", "reset", "seekTo", "time", "setDataSource", "fd", "Landroid/content/res/AssetFileDescriptor;", "path", "headers", "isCache", "setDisplay", "holder", "Landroid/view/SurfaceHolder;", "setLoadControl", "loadControl", "setLooping", "isLooping", "setOptions", "setRenderersFactory", "renderersFactory", "setSpeed", "speed", "setSurface", "surface", "Landroid/view/Surface;", "setTrackSelector", "trackSelector", "setVolume", "leftVolume", "rightVolume", "start", "stop", "exo_release"})
public class ExoMediaPlayer
extends AbstractPlayer
implements Player.Listener {
    @NotNull
    private final Context context;
    @JvmField
    @Nullable
    protected ExoPlayer mInternalPlayer;
    @JvmField
    @Nullable
    protected MediaSource mMediaSource;
    @JvmField
    @Nullable
    protected ExoMediaSourceHelper mMediaSourceHelper;
    @Nullable
    private PlaybackParameters mSpeedPlaybackParameters;
    private boolean mIsPreparing;
    @Nullable
    private LoadControl mLoadControl;
    @Nullable
    private RenderersFactory mRenderersFactory;
    @Nullable
    private TrackSelector mTrackSelector;
    @Nullable
    private PlaceholderSurface dummySurface;
    private boolean mIsPlaying;
    @NotNull
    private Map<String, String> mHeaders;
    @Nullable
    private String mUrl;

    public ExoMediaPlayer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.dummySurface = PlaceholderSurface.newInstanceV17((Context)this.context, (boolean)false);
        this.mHeaders = new LinkedHashMap();
        this.mMediaSourceHelper = ExoMediaSourceHelper.Companion.getInstance(this.context);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public void initPlayer() {
        block6: {
            LoadControl loadControl;
            TrackSelector trackSelector;
            this.mRenderersFactory = this.mRenderersFactory == null ? (RenderersFactory)new DefaultRenderersFactory(this.context.getApplicationContext()).setEnableDecoderFallback(true) : this.mRenderersFactory;
            Context context = this.context.getApplicationContext();
            RenderersFactory renderersFactory = this.mRenderersFactory;
            Intrinsics.checkNotNull((Object)renderersFactory);
            MediaSource.Factory factory = (MediaSource.Factory)new DefaultMediaSourceFactory(this.context.getApplicationContext());
            if (this.mTrackSelector == null) {
                trackSelector = (TrackSelector)new DefaultTrackSelector(this.context.getApplicationContext());
            } else {
                TrackSelector trackSelector2 = this.mTrackSelector;
                trackSelector = trackSelector2;
                Intrinsics.checkNotNull((Object)trackSelector2);
            }
            if (this.mLoadControl == null) {
                loadControl = (LoadControl)new DefaultLoadControl();
            } else {
                LoadControl loadControl2 = this.mLoadControl;
                loadControl = loadControl2;
                Intrinsics.checkNotNull((Object)loadControl2);
            }
            ExoPlayer.Builder exoBuilder = new ExoPlayer.Builder(context, renderersFactory, factory, trackSelector, loadControl, (BandwidthMeter)DefaultBandwidthMeter.getSingletonInstance((Context)this.context.getApplicationContext()), (AnalyticsCollector)new DefaultAnalyticsCollector(Clock.DEFAULT));
            exoBuilder.setVideoScalingMode(1);
            this.mInternalPlayer = exoBuilder.build();
            VideoViewConfig videoViewConfig = VideoViewManager.Companion.getConfig();
            if (ExtensionKt.toDefaultValue$default((Boolean)(videoViewConfig != null ? Boolean.valueOf(videoViewConfig.mIsEnableLog) : null), (boolean)false, (int)1, null) && this.mTrackSelector instanceof MappingTrackSelector) {
                ExoPlayer exoPlayer = this.mInternalPlayer;
                if (exoPlayer != null) {
                    exoPlayer.addAnalyticsListener((AnalyticsListener)new EventLogger((MappingTrackSelector)this.mTrackSelector, "ExoPlayer"));
                }
            }
            ExoPlayer exoPlayer = this.mInternalPlayer;
            if (exoPlayer == null) break block6;
            exoPlayer.addListener((Player.Listener)this);
        }
    }

    public final void setTrackSelector(@Nullable TrackSelector trackSelector) {
        this.mTrackSelector = trackSelector;
    }

    public final void setRenderersFactory(@Nullable RenderersFactory renderersFactory) {
        this.mRenderersFactory = renderersFactory;
    }

    public final void setLoadControl(@Nullable LoadControl loadControl) {
        this.mLoadControl = loadControl;
    }

    public void setDataSource(@Nullable String path, @Nullable Map<String, String> headers, boolean isCache) {
        CharSequence charSequence = path;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
            if (playerEventListener != null) {
                playerEventListener.onError(1, "Invalid video link");
            }
            return;
        }
        this.mUrl = path;
        ExoMediaSourceHelper exoMediaSourceHelper = this.mMediaSourceHelper;
        this.mMediaSource = exoMediaSourceHelper != null ? exoMediaSourceHelper.getMediaSource(path, headers, isCache) : null;
    }

    public void setDataSource(@Nullable AssetFileDescriptor fd) {
    }

    public void start() {
        ExoPlayer exoPlayer = this.mInternalPlayer;
        if (exoPlayer != null) {
            exoPlayer.setPlayWhenReady(true);
        }
    }

    public void pause() {
        ExoPlayer exoPlayer = this.mInternalPlayer;
        if (exoPlayer != null) {
            exoPlayer.setPlayWhenReady(false);
        }
    }

    public void stop() {
        block1: {
            ExoPlayer exoPlayer = this.mInternalPlayer;
            if (exoPlayer != null) {
                exoPlayer.stop();
            }
            ExoPlayer exoPlayer2 = this.mInternalPlayer;
            if (exoPlayer2 == null) break block1;
            exoPlayer2.clearMediaItems();
        }
    }

    public void prepareAsync() {
        block6: {
            PlaybackParameters it;
            if (this.mInternalPlayer == null) {
                return;
            }
            if (this.mMediaSource == null) {
                return;
            }
            PlaybackParameters playbackParameters = this.mSpeedPlaybackParameters;
            if (playbackParameters != null) {
                it = playbackParameters;
                boolean bl = false;
                ExoPlayer exoPlayer = this.mInternalPlayer;
                if (exoPlayer != null) {
                    exoPlayer.setPlaybackParameters(it);
                }
            }
            this.mIsPreparing = true;
            MediaSource mediaSource = this.mMediaSource;
            if (mediaSource != null) {
                it = mediaSource;
                boolean bl = false;
                ExoPlayer exoPlayer = this.mInternalPlayer;
                if (exoPlayer != null) {
                    exoPlayer.setMediaSource((MediaSource)it);
                }
            }
            ExoPlayer exoPlayer = this.mInternalPlayer;
            if (exoPlayer == null) break block6;
            exoPlayer.prepare();
        }
    }

    public void reset() {
        if (this.mInternalPlayer != null) {
            ExoPlayer exoPlayer = this.mInternalPlayer;
            if (exoPlayer != null) {
                exoPlayer.stop();
            }
            ExoPlayer exoPlayer2 = this.mInternalPlayer;
            if (exoPlayer2 != null) {
                exoPlayer2.clearMediaItems();
            }
            ExoPlayer exoPlayer3 = this.mInternalPlayer;
            if (exoPlayer3 != null) {
                exoPlayer3.setVideoSurface(null);
            }
            this.mIsPreparing = false;
        }
    }

    public boolean isPlaying() {
        return this.mIsPlaying;
    }

    public void seekTo(long time) {
        block0: {
            ExoPlayer exoPlayer = this.mInternalPlayer;
            if (exoPlayer == null) break block0;
            exoPlayer.seekTo(time);
        }
    }

    public void release() {
        ExoPlayer exoPlayer = this.mInternalPlayer;
        if (exoPlayer != null) {
            exoPlayer.removeListener((Player.Listener)this);
        }
        ExoPlayer exoPlayer2 = this.mInternalPlayer;
        if (exoPlayer2 != null) {
            exoPlayer2.release();
        }
        this.mInternalPlayer = null;
        this.mIsPreparing = false;
        this.mSpeedPlaybackParameters = null;
        PlaceholderSurface placeholderSurface = this.dummySurface;
        if (placeholderSurface != null) {
            placeholderSurface.release();
        }
        this.dummySurface = null;
    }

    public long getCurrentPosition() {
        ExoPlayer exoPlayer = this.mInternalPlayer;
        return ExtensionKt.toDefaultValue$default((Long)(exoPlayer != null ? Long.valueOf(exoPlayer.getCurrentPosition()) : null), (long)0L, (int)1, null);
    }

    public long getDuration() {
        ExoPlayer exoPlayer = this.mInternalPlayer;
        return ExtensionKt.toDefaultValue$default((Long)(exoPlayer != null ? Long.valueOf(exoPlayer.getDuration()) : null), (long)0L, (int)1, null);
    }

    public int getBufferedPercentage() {
        ExoPlayer exoPlayer = this.mInternalPlayer;
        return ExtensionKt.toDefaultValue$default((Integer)(exoPlayer != null ? Integer.valueOf(exoPlayer.getBufferedPercentage()) : null), (int)0, (int)1, null);
    }

    public void setSurface(@Nullable Surface surface) {
        block2: {
            block1: {
                if (surface != null && surface.isValid()) break block1;
                if (this.dummySurface == null) {
                    this.dummySurface = PlaceholderSurface.newInstanceV17((Context)this.context.getApplicationContext(), (boolean)false);
                }
                ExoPlayer exoPlayer = this.mInternalPlayer;
                if (exoPlayer == null) break block2;
                exoPlayer.setVideoSurface((Surface)this.dummySurface);
                break block2;
            }
            ExoPlayer exoPlayer = this.mInternalPlayer;
            if (exoPlayer == null) break block2;
            exoPlayer.setVideoSurface(surface);
        }
    }

    public void setDisplay(@Nullable SurfaceHolder holder) {
        SurfaceHolder surfaceHolder = holder;
        if (surfaceHolder == null) {
            this.setSurface(null);
        } else {
            this.setSurface(surfaceHolder.getSurface());
        }
    }

    public void setVolume(float leftVolume, float rightVolume) {
        ExoPlayer exoPlayer = this.mInternalPlayer;
        if (exoPlayer != null) {
            exoPlayer.setVolume((leftVolume + rightVolume) / (float)2);
        }
    }

    public void setLooping(boolean isLooping) {
        ExoPlayer exoPlayer = this.mInternalPlayer;
        if (exoPlayer != null) {
            exoPlayer.setRepeatMode(isLooping ? 2 : 0);
        }
    }

    public void setOptions() {
        ExoPlayer exoPlayer = this.mInternalPlayer;
        if (exoPlayer != null) {
            exoPlayer.setPlayWhenReady(true);
        }
    }

    public void setSpeed(float speed) {
        PlaybackParameters playbackParameters;
        this.mSpeedPlaybackParameters = playbackParameters = new PlaybackParameters(speed);
        ExoPlayer exoPlayer = this.mInternalPlayer;
        if (exoPlayer != null) {
            exoPlayer.setPlaybackParameters(playbackParameters);
        }
    }

    public float getSpeed() {
        PlaybackParameters playbackParameters = this.mSpeedPlaybackParameters;
        return ExtensionKt.toDefaultValue((Float)(playbackParameters != null ? Float.valueOf(playbackParameters.speed) : null), (float)1.0f);
    }

    public long getTcpSpeed() {
        return 0L;
    }

    public void onVolumeChanged(float volume) {
        block0: {
            AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
            if (playerEventListener == null) break block0;
            playerEventListener.onVolumeChanged(volume);
        }
    }

    public void onPlaybackStateChanged(int playbackState) {
        if (this.mPlayerEventListener == null) {
            return;
        }
        switch (playbackState) {
            case 2: {
                AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
                if (playerEventListener != null) {
                    playerEventListener.onInfo(701, this.getBufferedPercentage());
                }
                break;
            }
            case 3: {
                if (this.mIsPreparing) {
                    AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
                    if (playerEventListener != null) {
                        playerEventListener.onPrepared();
                    }
                    AbstractPlayer.PlayerEventListener playerEventListener2 = this.mPlayerEventListener;
                    if (playerEventListener2 != null) {
                        playerEventListener2.onInfo(3, 0);
                    }
                    this.mIsPreparing = false;
                }
                AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
                if (playerEventListener != null) {
                    playerEventListener.onInfo(702, this.getBufferedPercentage());
                }
                break;
            }
            case 4: {
                AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
                if (playerEventListener == null) break;
                playerEventListener.onCompletion();
                break;
            }
        }
    }

    public void onIsPlayingChanged(boolean isPlaying) {
        block0: {
            this.mIsPlaying = isPlaying;
            AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
            if (playerEventListener == null) break block0;
            AbstractPlayer.PlayerEventListener it = playerEventListener;
            boolean bl = false;
            it.onIsPlayingChanged(isPlaying);
        }
    }

    public void onPlayerError(@NotNull PlaybackException error) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
            if (playerEventListener == null) break block6;
            AbstractPlayer.PlayerEventListener it = playerEventListener;
            boolean bl = false;
            if (error instanceof ExoPlaybackException) {
                switch (((ExoPlaybackException)error).type) {
                    case 0: {
                        it.onError(1, error.getMessage());
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        it.onError(3, error.getMessage());
                        break;
                    }
                    default: {
                        it.onError(3, error.getMessage());
                        break;
                    }
                }
            } else {
                it.onError(3, error.getMessage());
            }
        }
    }

    public void onVideoSizeChanged(@NotNull VideoSize videoSize) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)videoSize, (String)"videoSize");
            AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
            if (playerEventListener == null) break block1;
            AbstractPlayer.PlayerEventListener it = playerEventListener;
            boolean bl = false;
            it.onVideoSizeChanged(videoSize.width, videoSize.height);
            if (videoSize.unappliedRotationDegrees > 0) {
                it.onInfo(10001, videoSize.unappliedRotationDegrees);
            }
        }
    }

    public void onRenderedFirstFrame() {
        block0: {
            super.onRenderedFirstFrame();
            AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
            if (playerEventListener == null) break block0;
            playerEventListener.onInfo(10002, 0);
        }
    }

    public void onSeekProcessed() {
        block0: {
            AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
            if (playerEventListener == null) break block0;
            playerEventListener.onInfo(703, 0);
        }
    }
}

