package com.tmc.network

import android.text.TextUtils
import com.google.gson.Gson
import com.tmc.sign.HttpSigner
import com.tmc.utils.CollectionUtil
import com.tmc.utils.LogUtil
import com.transsion.http.HttpClient
import com.transsion.http.impl.StringCallback
import javax.net.ssl.SSLSocketFactory

open class HttpRequestor protected constructor() {
    val UNKNOWN_ERROR_CODE = 10000
    private var ifCommonHeader = true
    private var ifTestMode = true
    private var loggable = false
    private var appName: String = ""
    private var appVersion: String = ""
    private var versionCode: Int = 0
    private var language: String = ""
    private var country: String = ""
    private var sslSocketFactory: SSLSocketFactory? = null

    private object HttpRequestorHolder {
        open val sInstance: HttpRequestor = HttpRequestor()
    }

    /*
     * set gateway and analosys work mode
     *
     * @param workMode WorkMode.MODE_TEST/WorkMode.MODE_PRE/WorkMode.MODE_ONLINE
     */
    fun setIfTestWorkMode(ifTestMode: Boolean) {
        this.ifTestMode = ifTestMode
        HttpSigner.setTest(ifTestMode)
    }

    /*
     * set if empty header for
     *
     * @param commonHeader true will
     */
    fun setIfCommonHeader(commonHeader: Boolean) {
        this.ifCommonHeader = commonHeader;
    }

    fun setSSLSocketFactory(sslSocketFactory: SSLSocketFactory?) {
        this.sslSocketFactory = sslSocketFactory
    }

    /**
     * set if print log
     *
     * @param loggable
     */
    fun setLoggable(loggable: Boolean) {
        this.loggable = loggable
    }

    /*
     * set appName and appVersion for header
     *
     * @param appName
     * @param appVersion
     */
    fun setAppInfo(appName: String, appVersion: String, versionCode: Int) {
        this.appName = appName
        this.appVersion = appVersion
        this.versionCode = versionCode
    }

    /*
     * set language
     *
     * @param language
     */
    fun setLanguage(language: String) {
        this.language = language
    }

    /*
     * set country
     *
     * @param country
     */
    fun setCountry(country: String) {
        this.country = country
    }

    fun postJSON(
        url: String,
        headers: MutableMap<String, String>?,
        params: MutableMap<String, String>?,
        json: Any?, callback: StringCallback
    ) {
        try {
            var mUrl = url
            if (!TextUtils.isEmpty(url) && CollectionUtil.isNotEmpty(params)) {
                mUrl = mUrl + "?" + CollectionUtil.getUrlParamsByMap(params)
            }

            var postBodyString = Gson().toJson(json)
            HttpSigner.setTest(ifTestMode)
            val signStr =
                HttpSigner.doSign("post", "", "application/json", mUrl, postBodyString)
            var builder = HttpClient.postJson() //必须方法体
                .log(loggable)
                .sslSocketFactory(sslSocketFactory) //Tan 需要私有证书校验,Adx不需要
                .content(postBodyString) //必须方法体，上传的String类型的数据文本，目前只提供上传String接口
                .connectTimeout(TIMEOUT_IN_MILLIONS) //网络连接超时时间，单位毫秒，非必须默认10s
                .readTimeout(TIMEOUT_IN_MILLIONS) //读取数据超时时间，单位毫秒，非必须默认10s
                .addHeader("x-tr-signature", signStr)
                .url(mUrl)

            if (ifCommonHeader) {
                builder.addHeader(TIME_ZONE, CollectionUtil.getTimeZone())

                if (!TextUtils.isEmpty(appName)) {
                    builder.addHeader(APP_NAME, appName)
                }
                if (!TextUtils.isEmpty(appVersion)) {
                    builder.addHeader(APP_VERSION, appVersion)
                }
                if (versionCode > 0) {
                    builder.addHeader(VERSION_CODE, "" + versionCode)
                }
                if (!TextUtils.isEmpty(language)) {
                    builder.addHeader(LANGUAGE, language)
                }
                if (!TextUtils.isEmpty(country)) {
                    builder.addHeader(COUNTRY, country)
                }
            }
            if (CollectionUtil.isNotEmpty(headers)) {
                for ((key, value) in headers!!) {
                    builder.addHeader(key, value)
                }
            }
            builder.build().execute(callback)
        } catch (e: Throwable) {
            LogUtil.e(e)
            callback.onFailure(UNKNOWN_ERROR_CODE, "", e)
        }
    }

    companion object {
        private val TIME_ZONE: String = "Accept-Timezone"
        private val LANGUAGE: String = "Accept-Language"
        private val COUNTRY: String = "Accept-Country"
        private val APP_NAME: String = "appName"
        private val APP_VERSION: String = "appVersion"
        private val VERSION_CODE: String = "versionCode"
        private const val TIMEOUT_IN_MILLIONS = 15 * 1000

        /**
         * set if print log
         *
         * @param loggable
         */
        fun setLoggable(loggable: Boolean) {
            LogUtil.setLoggable(loggable)
        }

        fun getInstance(): HttpRequestor? {
            return HttpRequestorHolder.sInstance
        }
    }
}