package com.tmc.utils

import java.util.*

/**
 *
 * map工具类
 */
object CollectionUtil {
    private var zoneStr: String? = ""

    /**
     * 判断不为空
     * @return
     */
    fun isNotEmpty(map: MutableMap<*, *>?): Boolean {
        return map != null && !map.isEmpty()
    }

    fun isEmpty(info: String?): Boolean {
        return info == null || info.length == 0
    }

    fun getUrlParamsByMap(map: Map<String, Any>?): String? {
        if (map == null) {
            return ""
        }
        val sb = StringBuffer()
        for ((key, value) in map) {
            sb.append("$key=$value")
            sb.append("&")
        }
        var s = sb.toString()
        if (s.endsWith("&")) {
            s = s.substring(0, s.length - 2)
        }
        return s
    }

    fun getTimeZone(): String {
        if (!isEmpty(zoneStr)) {
            return zoneStr!!
        }
        val tz = TimeZone.getDefault()
        val id = tz.id
        return if (isEmpty(id)) {
            val name = tz.getDisplayName(false, TimeZone.SHORT)
            if (isEmpty(name)) {
                zoneStr = ""
                "unknown"
            } else {
                zoneStr = name
                name
            }
        } else {
            zoneStr = id
            id
        }
    }
}