package com.tmc.utils

import android.util.Log
import java.io.PrintWriter
import java.io.StringWriter

/**
 *
 * 日志封装
 */
object LogUtil {
    var className //类名
            : String? = null
    var methodName //方法名
            : String? = null
    var lineNumber //行数
            = 0
    var isLoggable = false

    /**
     * 设置是否打日志
     * @return
     */
    @JvmName("setLoggable1")
    fun setLoggable(loggable: Boolean) {
        isLoggable = loggable
    }

    private fun createLog(log: String?): String? {
        val buffer = StringBuffer()
        buffer.append("================")
        buffer.append(methodName)
        buffer.append("(").append(className).append(":").append(lineNumber)
            .append(")================:")
        buffer.append(log)
        return buffer.toString()
    }

    /**
     * 获取文件名、方法名、所在行数
     * @param sElements
     */
    private fun getMethodNames(sElements: Array<StackTraceElement?>?) {
        className = sElements?.get(1)?.getFileName()
        methodName = sElements?.get(1)?.getMethodName()
        lineNumber = sElements?.get(1)!!.getLineNumber()
    }

    fun e(e: Throwable?) {
        if (!isLoggable) return
        val sw = StringWriter()
        PrintWriter(sw).use { pw -> e?.printStackTrace(pw) }
        val errorInfo = sw.toString()
        e(errorInfo)
    }

    fun e(message: String?) {
        if (!isLoggable) return
        getMethodNames(Throwable().stackTrace)
        Log.e(className, createLog(message)!!)
    }

    fun i(message: String?) {
        if (!isLoggable) return
        getMethodNames(Throwable().stackTrace)
        Log.i(className, createLog(message)!!)
    }

    fun d(message: String?) {
        if (!isLoggable) return
        getMethodNames(Throwable().stackTrace)
        Log.d(className, createLog(message)!!)
    }

    fun v(message: String?) {
        if (!isLoggable) return
        getMethodNames(Throwable().stackTrace)
        Log.v(className, createLog(message)!!)
    }

    fun w(message: String?) {
        if (!isLoggable) return
        getMethodNames(Throwable().stackTrace)
        Log.w(className, createLog(message)!!)
    }
}