/*
 * Decompiled with CFR 0.152.
 */
package com.tmc.sign;

import android.util.Base64;
import com.tmc.sign.SignAlgorithm;
import com.tmc.sign.Signer;
import com.tmc.utils.LogUtil;
import java.nio.charset.Charset;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class BasicSigner
extends Signer {
    private final String secret;

    public BasicSigner(String secret) {
        this.secret = secret;
    }

    @Override
    public String sign(SignAlgorithm algo, String content) {
        try {
            Mac hmac = Mac.getInstance(algo.name());
            hmac.init(new SecretKeySpec(Base64.decode((String)this.secret, (int)2), algo.name()));
            byte[] md5Result = hmac.doFinal(content.getBytes(Charset.forName("UTF-8")));
            return Base64.encodeToString((byte[])md5Result, (int)2);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.INSTANCE.e(e);
            return "";
        }
    }
}

