package com.tmc.sign;

import android.os.Build;
import android.util.Base64;

import androidx.annotation.RequiresApi;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Crypto {


    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    public static String Decrypt(String encryptedString) throws InvalidAlgorithmParameterException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] bytes = Base64.decode(encryptedString, Base64.NO_WRAP);
        byte[] iv = new byte[12];
        byte[] data = new byte[bytes.length - 12];
        System.arraycopy(bytes, 0, iv, 0, iv.length);
        System.arraycopy(bytes, iv.length, data, 0, data.length);
        Cipher cipher = null;
        cipher = getCipher(Cipher.DECRYPT_MODE, iv);
        return new String(cipher.doFinal(data));
    }

    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    private static Cipher getCipher(int cipherMode, byte[] iv) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        SecretKey secretKey = new SecretKeySpec(HttpSigner.getSecret().substring(0, 16).getBytes(StandardCharsets.UTF_8), "AES");
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv); //128 bit auth tag length
        cipher.init(cipherMode, secretKey, parameterSpec);
        return cipher;
    }

}
