/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.tplayer_core.render;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.TextureView;
import com.talpa.tplayer_core.render.IRenderView;
import com.talpa.tplayer_core.render.MeasureHelper;
import com.talpa.tplayer_core.tplayer.AbstractPlayer;
import com.talpa.tplayer_core.util.ExtensionKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0000H\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0014J \u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0017H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J \u0010\u001f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0017H\u0016J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J\b\u0010!\u001a\u00020\u0010H\u0016J\u0012\u0010\"\u001a\u00020\u00102\b\b\u0001\u0010#\u001a\u00020\u0017H\u0016J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0017H\u0016J\u0018\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0017H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/talpa/tplayer_core/render/TextureRenderView;", "Landroid/view/TextureView;", "Lcom/talpa/tplayer_core/render/IRenderView;", "Landroid/view/TextureView$SurfaceTextureListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mMeasureHelper", "Lcom/talpa/tplayer_core/render/MeasureHelper;", "mMediaPlayer", "Lcom/talpa/tplayer_core/tplayer/AbstractPlayer;", "mSurface", "Landroid/view/Surface;", "mSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "attachToPlayer", "", "player", "doScreenShot", "Landroid/graphics/Bitmap;", "getView", "onMeasure", "widthMeasureSpec", "", "heightMeasureSpec", "onSurfaceTextureAvailable", "surface", "width", "height", "onSurfaceTextureDestroyed", "", "onSurfaceTextureSizeChanged", "onSurfaceTextureUpdated", "release", "setScaleType", "scaleType", "setVideoRotation", "degree", "setVideoSize", "videoWidth", "videoHeight", "tplayer-core_release"})
public class TextureRenderView
extends TextureView
implements IRenderView,
TextureView.SurfaceTextureListener {
    @Nullable
    private MeasureHelper mMeasureHelper;
    @Nullable
    private SurfaceTexture mSurfaceTexture;
    @Nullable
    private AbstractPlayer mMediaPlayer;
    @Nullable
    private Surface mSurface;

    @JvmOverloads
    public TextureRenderView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.mMeasureHelper = new MeasureHelper();
        this.setSurfaceTextureListener(this);
    }

    @Override
    public void attachToPlayer(@Nullable AbstractPlayer player) {
        this.mMediaPlayer = player;
    }

    @Override
    public void setVideoSize(int videoWidth, int videoHeight) {
        if (videoWidth > 0 && videoHeight > 0) {
            MeasureHelper measureHelper = this.mMeasureHelper;
            if (measureHelper != null) {
                measureHelper.setVideoSize(videoWidth, videoHeight);
            }
            this.requestLayout();
        }
    }

    @Override
    public void setVideoRotation(int degree) {
        MeasureHelper measureHelper = this.mMeasureHelper;
        if (measureHelper != null) {
            measureHelper.setVideoRotation(degree);
        }
        this.setRotation(degree);
    }

    @Override
    public void setScaleType(int scaleType) {
        MeasureHelper measureHelper = this.mMeasureHelper;
        if (measureHelper != null) {
            measureHelper.setScreenScale(scaleType);
        }
        this.requestLayout();
    }

    @NotNull
    public TextureRenderView getView() {
        return this;
    }

    @Override
    @Nullable
    public Bitmap doScreenShot() {
        return this.getBitmap();
    }

    @Override
    public void release() {
        block1: {
            Surface surface = this.mSurface;
            if (surface != null) {
                surface.release();
            }
            SurfaceTexture surfaceTexture = this.mSurfaceTexture;
            if (surfaceTexture == null) break block1;
            surfaceTexture.release();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        MeasureHelper measureHelper = this.mMeasureHelper;
        int[] measuredSize = measureHelper != null ? measureHelper.doMeasure(widthMeasureSpec, heightMeasureSpec) : null;
        this.setMeasuredDimension(ExtensionKt.toDefaultValue$default(measuredSize != null ? Integer.valueOf(measuredSize[0]) : null, 0, 1, null), ExtensionKt.toDefaultValue$default(measuredSize != null ? Integer.valueOf(measuredSize[1]) : null, 0, 1, null));
    }

    public void onSurfaceTextureAvailable(@NotNull SurfaceTexture surface, int width, int height) {
        block1: {
            block0: {
                Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
                if (this.mSurfaceTexture == null) break block0;
                SurfaceTexture surfaceTexture = this.mSurfaceTexture;
                if (surfaceTexture == null) break block1;
                SurfaceTexture it = surfaceTexture;
                boolean bl = false;
                this.setSurfaceTexture(it);
                break block1;
            }
            this.mSurfaceTexture = this.getSurfaceTexture();
            this.mSurface = new Surface(this.getSurfaceTexture());
            AbstractPlayer abstractPlayer = this.mMediaPlayer;
            if (abstractPlayer == null) break block1;
            abstractPlayer.setSurface(this.mSurface);
        }
    }

    public void onSurfaceTextureSizeChanged(@NotNull SurfaceTexture surface, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
    }

    public boolean onSurfaceTextureDestroyed(@NotNull SurfaceTexture surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        return false;
    }

    public void onSurfaceTextureUpdated(@NotNull SurfaceTexture surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
    }
}

