/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.tplayer_core.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.WindowManager;
import com.talpa.tplayer_core.util.ExtensionKt;
import com.talpa.tplayer_core.util.L;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0003J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J\u0012\u0010\u0015\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u0012\u0010\u0016\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u001a\u0010\u0017\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u001a\u0010\u001a\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001c\"\u0004\b\u0000\u0010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001fH\u0007J\u0012\u0010 \u001a\u00020!2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u0012\u0010\"\u001a\u00020!2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u0014\u0010#\u001a\u0004\u0018\u00010$2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u0012\u0010%\u001a\u00020\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u0012\u0010&\u001a\u00020\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u001a\u0010'\u001a\u00020\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010(\u001a\u00020)H\u0007J\u0014\u0010*\u001a\u0004\u0018\u00010+2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u001a\u0010,\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/talpa/tplayer_core/util/PlayerUtils;", "", "()V", "NETWORK_CLOSED", "", "NETWORK_ETHERNET", "NETWORK_MOBILE", "NETWORK_UNKNOWN", "NETWORK_WIFI", "NO_NETWORK", "dp2px", "context", "Landroid/content/Context;", "dpValue", "", "getActiveNetworkInfo", "Landroid/net/NetworkInfo;", "getApplication", "Landroid/app/Application;", "getCurrentSystemTime", "", "getNavigationBarHeight", "getNetworkType", "getScreenHeight", "isIncludeNav", "", "getScreenWidth", "getSnapshot", "", "T", "other", "", "getStatusBarHeight", "", "getStatusBarHeightPortrait", "getWindowManager", "Landroid/view/WindowManager;", "hasNavigationBar", "isConnected", "isEdge", "e", "Landroid/view/MotionEvent;", "scanForActivity", "Landroid/app/Activity;", "sp2px", "stringForTime", "timeMs", "tplayer-core_release"})
public final class PlayerUtils {
    @NotNull
    public static final PlayerUtils INSTANCE = new PlayerUtils();
    public static final int NO_NETWORK = 0;
    public static final int NETWORK_CLOSED = 1;
    public static final int NETWORK_ETHERNET = 2;
    public static final int NETWORK_WIFI = 3;
    public static final int NETWORK_MOBILE = 4;
    public static final int NETWORK_UNKNOWN = -1;

    private PlayerUtils() {
    }

    @JvmStatic
    public static final double getStatusBarHeight(@Nullable Context context) {
        int statusBarHeight = 0;
        Context context2 = context;
        int resourceId = ExtensionKt.toDefaultValue$default(context2 != null && (context2 = context2.getResources()) != null ? Integer.valueOf(context2.getIdentifier("status_bar_height", "dimen", "android")) : null, 0, 1, null);
        if (resourceId > 0) {
            Context context3 = context;
            statusBarHeight = ExtensionKt.toDefaultValue$default(context3 != null && (context3 = context3.getResources()) != null ? Integer.valueOf(context3.getDimensionPixelSize(resourceId)) : null, 0, 1, null);
        }
        return statusBarHeight;
    }

    @JvmStatic
    public static final double getStatusBarHeightPortrait(@Nullable Context context) {
        int statusBarHeight = 0;
        Context context2 = context;
        int resourceId = ExtensionKt.toDefaultValue$default(context2 != null && (context2 = context2.getResources()) != null ? Integer.valueOf(context2.getIdentifier("status_bar_height_portrait", "dimen", "android")) : null, 0, 1, null);
        if (resourceId > 0) {
            Context context3 = context;
            statusBarHeight = ExtensionKt.toDefaultValue$default(context3 != null && (context3 = context3.getResources()) != null ? Integer.valueOf(context3.getDimensionPixelSize(resourceId)) : null, 0, 1, null);
        }
        return statusBarHeight;
    }

    @JvmStatic
    public static final int getNavigationBarHeight(@Nullable Context context) {
        Resources resources;
        if (!PlayerUtils.hasNavigationBar(context)) {
            return 0;
        }
        Context context2 = context;
        Resources resources2 = resources = context2 != null ? context2.getResources() : null;
        int resourceId = ExtensionKt.toDefaultValue$default(resources2 != null ? Integer.valueOf(resources2.getIdentifier("navigation_bar_height", "dimen", "android")) : null, 0, 1, null);
        Resources resources3 = resources;
        return ExtensionKt.toDefaultValue$default(resources3 != null ? Integer.valueOf(resources3.getDimensionPixelSize(resourceId)) : null, 0, 1, null);
    }

    @JvmStatic
    public static final boolean hasNavigationBar(@Nullable Context context) {
        boolean bl;
        if (Build.VERSION.SDK_INT >= 17) {
            WindowManager windowManager = PlayerUtils.getWindowManager(context);
            Display display = windowManager != null ? windowManager.getDefaultDisplay() : null;
            Point size = new Point();
            Point realSize = new Point();
            Display display2 = display;
            if (display2 != null) {
                display2.getSize(size);
            }
            Display display3 = display;
            if (display3 != null) {
                display3.getRealSize(realSize);
            }
            bl = realSize.x != size.x || realSize.y != size.y;
        } else {
            boolean menu = ViewConfiguration.get((Context)context).hasPermanentMenuKey();
            boolean back = KeyCharacterMap.deviceHasKey((int)4);
            bl = !menu && !back;
        }
        return bl;
    }

    @JvmStatic
    public static final int getScreenWidth(@Nullable Context context, boolean isIncludeNav) {
        Context context2;
        Context context3;
        return isIncludeNav ? ExtensionKt.toDefaultValue$default((context3 = context) != null && (context3 = context3.getResources()) != null && (context3 = context3.getDisplayMetrics()) != null ? Integer.valueOf(context3.widthPixels) : null, 0, 1, null) + PlayerUtils.getNavigationBarHeight(context) : ExtensionKt.toDefaultValue$default((context2 = context) != null && (context2 = context2.getResources()) != null && (context2 = context2.getDisplayMetrics()) != null ? Integer.valueOf(context2.widthPixels) : null, 0, 1, null);
    }

    @JvmStatic
    public static final int getScreenHeight(@Nullable Context context, boolean isIncludeNav) {
        Context context2;
        Context context3;
        return isIncludeNav ? ExtensionKt.toDefaultValue$default((context3 = context) != null && (context3 = context3.getResources()) != null && (context3 = context3.getDisplayMetrics()) != null ? Integer.valueOf(context3.heightPixels) : null, 0, 1, null) + PlayerUtils.getNavigationBarHeight(context) : ExtensionKt.toDefaultValue$default((context2 = context) != null && (context2 = context2.getResources()) != null && (context2 = context2.getDisplayMetrics()) != null ? Integer.valueOf(context2.heightPixels) : null, 0, 1, null);
    }

    @JvmStatic
    @Nullable
    public static final Activity scanForActivity(@Nullable Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return PlayerUtils.scanForActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    @JvmStatic
    public static final int dp2px(@Nullable Context context, float dpValue) {
        if (context == null) {
            return 0;
        }
        Resources resources = context.getResources();
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)(resources != null ? resources.getDisplayMetrics() : null));
    }

    @JvmStatic
    public static final int sp2px(@Nullable Context context, float dpValue) {
        if (context == null) {
            return 0;
        }
        Resources resources = context.getResources();
        return (int)TypedValue.applyDimension((int)2, (float)dpValue, (DisplayMetrics)(resources != null ? resources.getDisplayMetrics() : null));
    }

    @JvmStatic
    @Nullable
    public static final WindowManager getWindowManager(@Nullable Context context) {
        Context context2 = context;
        return (WindowManager)(context2 != null ? context2.getSystemService("window") : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isEdge(@Nullable Context context, @NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        int edgeSize = PlayerUtils.dp2px(context, 40.0f);
        if (e.getRawX() < (float)edgeSize) return true;
        if (e.getRawX() > (float)(PlayerUtils.getScreenWidth(context, true) - edgeSize)) return true;
        if (e.getRawY() < (float)edgeSize) return true;
        if (!(e.getRawY() > (float)(PlayerUtils.getScreenHeight(context, true) - edgeSize))) return false;
        return true;
    }

    @JvmStatic
    public static final boolean isConnected(@Nullable Context context) {
        NetworkInfo info;
        NetworkInfo networkInfo = info = PlayerUtils.getActiveNetworkInfo(context);
        return ExtensionKt.toDefaultValue$default(networkInfo != null ? Boolean.valueOf(networkInfo.isConnected()) : null, false, 1, null);
    }

    @JvmStatic
    private static final NetworkInfo getActiveNetworkInfo(Context context) {
        ConnectivityManager manager;
        Context context2 = context;
        ConnectivityManager connectivityManager = manager = (ConnectivityManager)(context2 != null && (context2 = context2.getApplicationContext()) != null ? context2.getSystemService("connectivity") : null);
        return connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
    }

    @JvmStatic
    public static final int getNetworkType(@Nullable Context context) {
        Context context2;
        ConnectivityManager connectivityManager = (ConnectivityManager)(context != null && (context2 = context.getApplicationContext()) != null ? context2.getSystemService("connectivity") : null);
        if (connectivityManager == null) {
            return 0;
        }
        ConnectivityManager connectMgr = connectivityManager;
        NetworkInfo networkInfo = connectMgr.getActiveNetworkInfo();
        if (networkInfo == null) {
            return 0;
        }
        NetworkInfo networkInfo2 = networkInfo;
        if (!networkInfo2.isConnected()) {
            return 1;
        }
        if (networkInfo2.getType() == 9) {
            return 2;
        }
        if (networkInfo2.getType() == 1) {
            return 3;
        }
        if (networkInfo2.getType() == 0) {
            switch (networkInfo2.getSubtype()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 20: {
                    return 4;
                }
            }
        }
        return -1;
    }

    @Deprecated(message="")
    @JvmStatic
    @SuppressLint(value={"PrivateApi"})
    @Nullable
    public static final Application getApplication() {
        try {
            Object object = Class.forName("android.app.ActivityThread").getMethod("currentApplication", new Class[0]).invoke(null, new Object[0]);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.Application");
            }
            return (Application)object;
        }
        catch (Exception e) {
            L.i("getApplication e = " + e);
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final String getCurrentSystemTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm", Locale.getDefault());
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    @JvmStatic
    @NotNull
    public static final String stringForTime(int timeMs) {
        String string;
        int totalSeconds = timeMs / 1000;
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        if (hours > 0) {
            Locale locale = Locale.getDefault();
            String string2 = "%d:%02d:%02d";
            Object[] objectArray = new Object[]{hours, minutes, seconds};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
        } else {
            Locale locale = Locale.getDefault();
            String string4 = "%02d:%02d";
            Object[] objectArray = new Object[]{minutes, seconds};
            String string5 = String.format(locale, string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(locale, format, *args)");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final <T> List<T> getSnapshot(@NotNull Collection<? extends T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        List result = new ArrayList(other.size());
        for (T item : other) {
            if (item == null) continue;
            result.add(item);
        }
        return result;
    }
}

