/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.tplayer_core.render;

import android.view.View;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004J\u0010\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0004J\u0016\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/talpa/tplayer_core/render/MeasureHelper;", "", "()V", "mCurrentScreenScale", "", "mVideoHeight", "mVideoRotationDegree", "mVideoWidth", "doMeasure", "", "widthMeasureSpec", "heightMeasureSpec", "setScreenScale", "", "screenScale", "setVideoRotation", "videoRotationDegree", "setVideoSize", "width", "height", "tplayer-core_release"})
public final class MeasureHelper {
    private int mVideoWidth;
    private int mVideoHeight;
    private int mCurrentScreenScale;
    private int mVideoRotationDegree;

    public final void setVideoRotation(int videoRotationDegree) {
        this.mVideoRotationDegree = videoRotationDegree;
    }

    public final void setVideoSize(int width, int height) {
        this.mVideoWidth = width;
        this.mVideoHeight = height;
    }

    public final void setScreenScale(int screenScale) {
        this.mCurrentScreenScale = screenScale;
    }

    @NotNull
    public final int[] doMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMeasureSpec2 = widthMeasureSpec;
        int heightMeasureSpec2 = heightMeasureSpec;
        if (this.mVideoRotationDegree == 90 || this.mVideoRotationDegree == 270) {
            widthMeasureSpec2 += heightMeasureSpec2;
            heightMeasureSpec2 = widthMeasureSpec2 - heightMeasureSpec2;
            widthMeasureSpec2 -= heightMeasureSpec2;
        }
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec2);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec2);
        if (this.mVideoHeight == 0 || this.mVideoWidth == 0) {
            int[] nArray = new int[]{width, height};
            return nArray;
        }
        switch (this.mCurrentScreenScale) {
            case 0: {
                if (this.mVideoWidth * height < width * this.mVideoHeight) {
                    width = height * this.mVideoWidth / this.mVideoHeight;
                    break;
                }
                if (this.mVideoWidth * height <= width * this.mVideoHeight) break;
                height = width * this.mVideoHeight / this.mVideoWidth;
                break;
            }
            case 4: {
                width = this.mVideoWidth;
                height = this.mVideoHeight;
                break;
            }
            case 1: {
                if (height > width / 16 * 9) {
                    height = width / 16 * 9;
                    break;
                }
                width = height / 9 * 16;
                break;
            }
            case 2: {
                if (height > width / 4 * 3) {
                    height = width / 4 * 3;
                    break;
                }
                width = height / 3 * 4;
                break;
            }
            case 3: {
                width = widthMeasureSpec2;
                height = heightMeasureSpec2;
                break;
            }
            case 5: {
                if (this.mVideoWidth * height > width * this.mVideoHeight) {
                    width = height * this.mVideoWidth / this.mVideoHeight;
                    break;
                }
                height = width * this.mVideoHeight / this.mVideoWidth;
                break;
            }
            default: {
                if (this.mVideoWidth * height < width * this.mVideoHeight) {
                    width = height * this.mVideoWidth / this.mVideoHeight;
                    break;
                }
                if (this.mVideoWidth * height <= width * this.mVideoHeight) break;
                height = width * this.mVideoHeight / this.mVideoWidth;
            }
        }
        int[] nArray = new int[]{width, height};
        return nArray;
    }
}

