/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.tplayer_core.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.DisplayCutout;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import com.talpa.tplayer_core.util.ExtensionKt;
import com.talpa.tplayer_core.util.PlayerUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0012\u0010\f\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u0010\r\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u0010\u000e\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0003J\u0012\u0010\u000f\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0003\u00a8\u0006\u0010"}, d2={"Lcom/talpa/tplayer_core/util/CutoutUtil;", "", "()V", "adaptCutoutAboveAndroidP", "", "context", "Landroid/content/Context;", "isAdapt", "", "allowDisplayToCutout", "activity", "Landroid/app/Activity;", "hasCutoutHuawei", "hasCutoutOPPO", "hasCutoutVIVO", "hasCutoutXIAOMI", "tplayer-core_release"})
public final class CutoutUtil {
    @NotNull
    public static final CutoutUtil INSTANCE = new CutoutUtil();

    private CutoutUtil() {
    }

    public final boolean allowDisplayToCutout(@Nullable Activity activity) {
        boolean bl;
        if (Build.VERSION.SDK_INT >= 28) {
            Activity activity2 = activity;
            Object window = activity2 != null ? activity2.getWindow() : null;
            Window window2 = window;
            WindowInsets windowInsets = window2 != null && (window2 = window2.getDecorView()) != null ? window2.getRootWindowInsets() : null;
            if (windowInsets == null) {
                return false;
            }
            WindowInsets windowInsets2 = windowInsets;
            DisplayCutout displayCutout = windowInsets2.getDisplayCutout();
            if (displayCutout == null) {
                return false;
            }
            DisplayCutout displayCutout2 = displayCutout;
            List list = displayCutout2.getBoundingRects();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"displayCutout.boundingRects");
            List boundingRects = list;
            bl = boundingRects.size() > 0;
        } else {
            bl = this.hasCutoutHuawei(activity) || this.hasCutoutOPPO(activity) || this.hasCutoutVIVO(activity) || this.hasCutoutXIAOMI(activity);
        }
        return bl;
    }

    private final boolean hasCutoutHuawei(Activity activity) {
        boolean bl;
        if (!StringsKt.equals((String)Build.MANUFACTURER, (String)"HUAWEI", (boolean)true)) {
            bl = false;
        } else {
            boolean bl2;
            try {
                Class<?> HwNotchSizeUtil;
                ClassLoader cl;
                Activity activity2 = activity;
                ClassLoader classLoader = cl = activity2 != null ? activity2.getClassLoader() : null;
                Class<Object> clazz = HwNotchSizeUtil = classLoader != null ? classLoader.loadClass("com.huawei.android.util.HwNotchSizeUtil") : null;
                if (HwNotchSizeUtil != null) {
                    Method get = HwNotchSizeUtil.getMethod("hasNotchInScreen", new Class[0]);
                    Object object = get.invoke(HwNotchSizeUtil, new Object[0]);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    return (Boolean)object;
                }
                bl2 = false;
            }
            catch (Exception e) {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    private final boolean hasCutoutOPPO(Activity activity) {
        Activity activity2;
        return !StringsKt.equals((String)Build.MANUFACTURER, (String)"oppo", (boolean)true) ? false : ExtensionKt.toDefaultValue$default((activity2 = activity) != null && (activity2 = activity2.getPackageManager()) != null ? Boolean.valueOf(activity2.hasSystemFeature("com.oppo.feature.screen.heteromorphism")) : null, false, 1, null);
    }

    @SuppressLint(value={"PrivateApi"})
    private final boolean hasCutoutVIVO(Activity activity) {
        boolean bl;
        if (!StringsKt.equals((String)Build.MANUFACTURER, (String)"vivo", (boolean)true)) {
            bl = false;
        } else {
            boolean bl2;
            try {
                Class<?> ftFeatureUtil;
                ClassLoader cl;
                Activity activity2 = activity;
                ClassLoader classLoader = cl = activity2 != null ? activity2.getClassLoader() : null;
                Class<Object> clazz = ftFeatureUtil = classLoader != null ? classLoader.loadClass("android.util.FtFeature") : null;
                if (ftFeatureUtil != null) {
                    Class[] classArray = new Class[]{Integer.TYPE};
                    Method get = ftFeatureUtil.getMethod("isFeatureSupport", classArray);
                    Object[] objectArray = new Object[]{32};
                    Object object = get.invoke(ftFeatureUtil, objectArray);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    return (Boolean)object;
                }
                bl2 = false;
            }
            catch (Exception e) {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    @SuppressLint(value={"PrivateApi"})
    private final boolean hasCutoutXIAOMI(Activity activity) {
        boolean bl;
        if (!StringsKt.equals((String)Build.MANUFACTURER, (String)"xiaomi", (boolean)true)) {
            bl = false;
        } else {
            boolean bl2;
            try {
                Integer hasCutout;
                ClassLoader cl;
                Activity activity2 = activity;
                ClassLoader classLoader = cl = activity2 != null ? activity2.getClassLoader() : null;
                Class<?> SystemProperties = classLoader != null ? classLoader.loadClass("android.os.SystemProperties") : null;
                Class[] paramTypes = new Class[]{String.class, Integer.TYPE};
                Class<?> clazz = SystemProperties;
                Method getInt = clazz != null ? clazz.getMethod("getInt", Arrays.copyOf(paramTypes, paramTypes.length)) : null;
                Object[] params = new Object[]{"ro.miui.notch", 0};
                Method method = getInt;
                Integer n = hasCutout = (Integer)(method != null ? method.invoke(SystemProperties, Arrays.copyOf(params, params.length)) : null);
                int n2 = 1;
                bl2 = n != null && n == n2;
            }
            catch (Exception e) {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    public final void adaptCutoutAboveAndroidP(@Nullable Context context, boolean isAdapt) {
        Activity activity = PlayerUtils.scanForActivity(context);
        if (activity == null) {
            return;
        }
        Activity activity2 = activity;
        if (Build.VERSION.SDK_INT >= 28) {
            WindowManager.LayoutParams lp = activity2.getWindow().getAttributes();
            lp.layoutInDisplayCutoutMode = isAdapt ? 1 : 0;
            activity2.getWindow().setAttributes(lp);
        }
    }
}

