/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.tplayer_core.tplayer;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import android.media.PlaybackParams;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.talpa.tplayer_core.tplayer.AbstractPlayer;
import com.talpa.tplayer_core.util.ExtensionKt;
import com.talpa.tplayer_core.util.L;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u00062\u00020\u0007B\r\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0012\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u000fH\u0016J\b\u0010\u001c\u001a\u00020\u000fH\u0002J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\rH\u0016J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J \u0010!\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\rH\u0016J \u0010$\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\rH\u0016J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J \u0010&\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\rH\u0016J\b\u0010)\u001a\u00020\u001aH\u0016J\b\u0010*\u001a\u00020\u001aH\u0016J\b\u0010+\u001a\u00020\u001aH\u0016J\b\u0010,\u001a\u00020\u001aH\u0016J\u0010\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u0014H\u0016J\u0012\u0010/\u001a\u00020\u001a2\b\u00100\u001a\u0004\u0018\u000101H\u0016J0\u0010/\u001a\u00020\u001a2\b\u00102\u001a\u0004\u0018\u0001032\u0014\u00104\u001a\u0010\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u000203\u0018\u0001052\u0006\u00106\u001a\u00020\u000fH\u0016J\u0012\u00107\u001a\u00020\u001a2\b\u00108\u001a\u0004\u0018\u000109H\u0016J\u0010\u0010:\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\u000fH\u0016J\b\u0010<\u001a\u00020\u001aH\u0016J\u0010\u0010=\u001a\u00020\u001a2\u0006\u0010>\u001a\u00020\u0017H\u0016J\u0012\u0010?\u001a\u00020\u001a2\b\u0010@\u001a\u0004\u0018\u00010AH\u0016J\u0018\u0010B\u001a\u00020\u001a2\u0006\u0010C\u001a\u00020\u00172\u0006\u0010D\u001a\u00020\u0017H\u0016J\b\u0010E\u001a\u00020\u001aH\u0016J\b\u0010F\u001a\u00020\u001aH\u0016R\u0012\u0010\u000b\u001a\u00020\t8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00118\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/talpa/tplayer_core/tplayer/AndroidMediaPlayer;", "Lcom/talpa/tplayer_core/tplayer/AbstractPlayer;", "Landroid/media/MediaPlayer$OnErrorListener;", "Landroid/media/MediaPlayer$OnCompletionListener;", "Landroid/media/MediaPlayer$OnInfoListener;", "Landroid/media/MediaPlayer$OnBufferingUpdateListener;", "Landroid/media/MediaPlayer$OnPreparedListener;", "Landroid/media/MediaPlayer$OnVideoSizeChangedListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mAppContext", "mBufferedPercent", "", "mIsPreparing", "", "mMediaPlayer", "Landroid/media/MediaPlayer;", "getBufferedPercentage", "getCurrentPosition", "", "getDuration", "getSpeed", "", "getTcpSpeed", "initPlayer", "", "isPlaying", "isVideo", "onBufferingUpdate", "mp", "percent", "onCompletion", "onError", "what", "extra", "onInfo", "onPrepared", "onVideoSizeChanged", "width", "height", "pause", "prepareAsync", "release", "reset", "seekTo", "time", "setDataSource", "fd", "Landroid/content/res/AssetFileDescriptor;", "path", "", "headers", "", "isCache", "setDisplay", "holder", "Landroid/view/SurfaceHolder;", "setLooping", "isLooping", "setOptions", "setSpeed", "speed", "setSurface", "surface", "Landroid/view/Surface;", "setVolume", "v1", "v2", "start", "stop", "com.talpa.tplayer_core"})
public class AndroidMediaPlayer
extends AbstractPlayer
implements MediaPlayer.OnErrorListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener {
    @JvmField
    @Nullable
    protected MediaPlayer mMediaPlayer;
    private int mBufferedPercent;
    @JvmField
    @NotNull
    protected Context mAppContext;
    private boolean mIsPreparing;

    public AndroidMediaPlayer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.mAppContext = context2;
    }

    @Override
    public void initPlayer() {
        block6: {
            this.mMediaPlayer = new MediaPlayer();
            this.setOptions();
            MediaPlayer mediaPlayer = this.mMediaPlayer;
            if (mediaPlayer != null) {
                mediaPlayer.setAudioStreamType(3);
            }
            MediaPlayer mediaPlayer2 = this.mMediaPlayer;
            if (mediaPlayer2 != null) {
                mediaPlayer2.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            }
            MediaPlayer mediaPlayer3 = this.mMediaPlayer;
            if (mediaPlayer3 != null) {
                mediaPlayer3.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            }
            MediaPlayer mediaPlayer4 = this.mMediaPlayer;
            if (mediaPlayer4 != null) {
                mediaPlayer4.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            }
            MediaPlayer mediaPlayer5 = this.mMediaPlayer;
            if (mediaPlayer5 != null) {
                mediaPlayer5.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            }
            MediaPlayer mediaPlayer6 = this.mMediaPlayer;
            if (mediaPlayer6 != null) {
                mediaPlayer6.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            }
            MediaPlayer mediaPlayer7 = this.mMediaPlayer;
            if (mediaPlayer7 == null) break block6;
            mediaPlayer7.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
        }
    }

    @Override
    public void setDataSource(@Nullable String path, @Nullable Map<String, String> headers, boolean isCache) {
        block4: {
            CharSequence charSequence = path;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
                if (playerEventListener != null) {
                    playerEventListener.onError(1, "Invalid video link");
                }
                return;
            }
            try {
                Uri uri = Uri.parse((String)path);
                MediaPlayer mediaPlayer = this.mMediaPlayer;
                if (mediaPlayer == null) break block4;
                mediaPlayer.setDataSource(this.mAppContext, uri, headers);
            }
            catch (Exception e) {
                AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
                if (playerEventListener == null) break block4;
                playerEventListener.onError(2, e.getMessage());
            }
        }
    }

    @Override
    public void setDataSource(@Nullable AssetFileDescriptor fd) {
        block2: {
            try {
                MediaPlayer mediaPlayer = this.mMediaPlayer;
                if (mediaPlayer == null) break block2;
                AssetFileDescriptor assetFileDescriptor = fd;
                AssetFileDescriptor assetFileDescriptor2 = fd;
                AssetFileDescriptor assetFileDescriptor3 = fd;
                mediaPlayer.setDataSource(assetFileDescriptor != null ? assetFileDescriptor.getFileDescriptor() : null, ExtensionKt.toDefaultValue$default(assetFileDescriptor2 != null ? Long.valueOf(assetFileDescriptor2.getStartOffset()) : null, 0L, 1, null), ExtensionKt.toDefaultValue$default(assetFileDescriptor3 != null ? Long.valueOf(assetFileDescriptor3.getLength()) : null, 0L, 1, null));
            }
            catch (Exception e) {
                AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
                if (playerEventListener == null) break block2;
                playerEventListener.onError(3, e.getMessage());
            }
        }
    }

    @Override
    public void start() {
        block2: {
            try {
                MediaPlayer mediaPlayer = this.mMediaPlayer;
                if (mediaPlayer == null) break block2;
                mediaPlayer.start();
            }
            catch (IllegalStateException e) {
                AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
                if (playerEventListener == null) break block2;
                playerEventListener.onError(3, e.getMessage());
            }
        }
    }

    @Override
    public void pause() {
        block2: {
            try {
                MediaPlayer mediaPlayer = this.mMediaPlayer;
                if (mediaPlayer == null) break block2;
                mediaPlayer.pause();
            }
            catch (IllegalStateException e) {
                AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
                if (playerEventListener == null) break block2;
                playerEventListener.onError(3, e.getMessage());
            }
        }
    }

    @Override
    public void stop() {
        block2: {
            try {
                MediaPlayer mediaPlayer = this.mMediaPlayer;
                if (mediaPlayer == null) break block2;
                mediaPlayer.stop();
            }
            catch (IllegalStateException e) {
                AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
                if (playerEventListener == null) break block2;
                playerEventListener.onError(3, e.getMessage());
            }
        }
    }

    @Override
    public void prepareAsync() {
        block2: {
            try {
                this.mIsPreparing = true;
                MediaPlayer mediaPlayer = this.mMediaPlayer;
                if (mediaPlayer == null) break block2;
                mediaPlayer.prepareAsync();
            }
            catch (IllegalStateException e) {
                AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
                if (playerEventListener == null) break block2;
                playerEventListener.onError(3, e.getMessage());
            }
        }
    }

    @Override
    public void reset() {
        block3: {
            this.stop();
            MediaPlayer mediaPlayer = this.mMediaPlayer;
            if (mediaPlayer != null) {
                mediaPlayer.reset();
            }
            MediaPlayer mediaPlayer2 = this.mMediaPlayer;
            if (mediaPlayer2 != null) {
                mediaPlayer2.setSurface(null);
            }
            MediaPlayer mediaPlayer3 = this.mMediaPlayer;
            if (mediaPlayer3 != null) {
                mediaPlayer3.setDisplay(null);
            }
            MediaPlayer mediaPlayer4 = this.mMediaPlayer;
            if (mediaPlayer4 == null) break block3;
            mediaPlayer4.setVolume(1.0f, 1.0f);
        }
    }

    @Override
    public boolean isPlaying() {
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        return ExtensionKt.toDefaultValue$default(mediaPlayer != null ? Boolean.valueOf(mediaPlayer.isPlaying()) : null, false, 1, null);
    }

    @Override
    public void seekTo(long time) {
        block3: {
            try {
                if (Build.VERSION.SDK_INT >= 26) {
                    MediaPlayer mediaPlayer = this.mMediaPlayer;
                    if (mediaPlayer == null) break block3;
                    mediaPlayer.seekTo(time, 3);
                    break block3;
                }
                MediaPlayer mediaPlayer = this.mMediaPlayer;
                if (mediaPlayer == null) break block3;
                mediaPlayer.seekTo((int)time);
            }
            catch (IllegalStateException e) {
                AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
                if (playerEventListener == null) break block3;
                playerEventListener.onError(3, e.getMessage());
            }
        }
    }

    @Override
    public void release() {
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer != null) {
            mediaPlayer.setOnErrorListener(null);
        }
        MediaPlayer mediaPlayer2 = this.mMediaPlayer;
        if (mediaPlayer2 != null) {
            mediaPlayer2.setOnCompletionListener(null);
        }
        MediaPlayer mediaPlayer3 = this.mMediaPlayer;
        if (mediaPlayer3 != null) {
            mediaPlayer3.setOnInfoListener(null);
        }
        MediaPlayer mediaPlayer4 = this.mMediaPlayer;
        if (mediaPlayer4 != null) {
            mediaPlayer4.setOnBufferingUpdateListener(null);
        }
        MediaPlayer mediaPlayer5 = this.mMediaPlayer;
        if (mediaPlayer5 != null) {
            mediaPlayer5.setOnPreparedListener(null);
        }
        MediaPlayer mediaPlayer6 = this.mMediaPlayer;
        if (mediaPlayer6 != null) {
            mediaPlayer6.setOnVideoSizeChangedListener(null);
        }
        this.stop();
        MediaPlayer mediaPlayer7 = this.mMediaPlayer;
        this.mMediaPlayer = null;
        new Thread(mediaPlayer7){
            final /* synthetic */ MediaPlayer $mediaPlayer;
            {
                this.$mediaPlayer = $mediaPlayer;
            }

            public void run() {
                try {
                    MediaPlayer mediaPlayer = this.$mediaPlayer;
                    if (mediaPlayer != null) {
                        mediaPlayer.release();
                    }
                }
                catch (Exception e) {
                    L.i("AndroidMediaPlayer release " + e);
                }
            }
        }.start();
    }

    @Override
    public long getCurrentPosition() {
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        return ExtensionKt.toDefaultValue$default(mediaPlayer != null ? Integer.valueOf(mediaPlayer.getCurrentPosition()) : null, 0, 1, null);
    }

    @Override
    public long getDuration() {
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        return ExtensionKt.toDefaultValue$default(mediaPlayer != null ? Integer.valueOf(mediaPlayer.getDuration()) : null, 0, 1, null);
    }

    @Override
    public int getBufferedPercentage() {
        return this.mBufferedPercent;
    }

    @Override
    public void setSurface(@Nullable Surface surface) {
        block2: {
            try {
                MediaPlayer mediaPlayer = this.mMediaPlayer;
                if (mediaPlayer == null) break block2;
                mediaPlayer.setSurface(surface);
            }
            catch (Exception e) {
                AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
                if (playerEventListener == null) break block2;
                playerEventListener.onError(3, e.getMessage());
            }
        }
    }

    @Override
    public void setDisplay(@Nullable SurfaceHolder holder) {
        block2: {
            try {
                MediaPlayer mediaPlayer = this.mMediaPlayer;
                if (mediaPlayer == null) break block2;
                mediaPlayer.setDisplay(holder);
            }
            catch (Exception e) {
                AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
                if (playerEventListener == null) break block2;
                playerEventListener.onError(3, e.getMessage());
            }
        }
    }

    @Override
    public void setVolume(float v1, float v2) {
        block0: {
            MediaPlayer mediaPlayer = this.mMediaPlayer;
            if (mediaPlayer == null) break block0;
            mediaPlayer.setVolume(v1, v2);
        }
    }

    @Override
    public void setLooping(boolean isLooping) {
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer != null) {
            mediaPlayer.setLooping(isLooping);
        }
    }

    @Override
    public void setOptions() {
    }

    @Override
    public void setSpeed(float speed) {
        block5: {
            if (Build.VERSION.SDK_INT >= 23) {
                try {
                    MediaPlayer mediaPlayer = this.mMediaPlayer;
                    if (mediaPlayer != null && (mediaPlayer = mediaPlayer.getPlaybackParams()) != null && (mediaPlayer = mediaPlayer.setSpeed(speed)) != null) {
                        MediaPlayer it = mediaPlayer;
                        boolean bl = false;
                        MediaPlayer mediaPlayer2 = this.mMediaPlayer;
                        if (mediaPlayer2 != null) {
                            mediaPlayer2.setPlaybackParams((PlaybackParams)it);
                        }
                    }
                }
                catch (Exception e) {
                    AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
                    if (playerEventListener == null) break block5;
                    playerEventListener.onError(3, e.getMessage());
                }
            }
        }
    }

    @Override
    public float getSpeed() {
        float f;
        if (Build.VERSION.SDK_INT >= 23) {
            float f2;
            try {
                MediaPlayer mediaPlayer = this.mMediaPlayer;
                float speed = ExtensionKt.toDefaultValue$default(mediaPlayer != null && (mediaPlayer = mediaPlayer.getPlaybackParams()) != null ? Float.valueOf(mediaPlayer.getSpeed()) : null, 0.0f, 1, null);
                if (speed == 0.0f) {
                    speed = 1.0f;
                }
            }
            catch (Exception e) {
                f2 = 1.0f;
            }
            f = f2;
        } else {
            f = 1.0f;
        }
        return f;
    }

    @Override
    public long getTcpSpeed() {
        return 0L;
    }

    public boolean onError(@NotNull MediaPlayer mp, int what, int extra) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
            AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
            if (playerEventListener == null) break block0;
            playerEventListener.onError(3, "AndroidMediaPlayer Exception what = " + what + ", extra = " + extra);
        }
        return true;
    }

    public void onCompletion(@NotNull MediaPlayer mp) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
            AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
            if (playerEventListener == null) break block0;
            playerEventListener.onCompletion();
        }
    }

    public boolean onInfo(@NotNull MediaPlayer mp, int what, int extra) {
        block2: {
            block1: {
                Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
                if (what != 3) break block1;
                if (!this.mIsPreparing) break block2;
                AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
                if (playerEventListener != null) {
                    playerEventListener.onInfo(what, extra);
                }
                this.mIsPreparing = false;
                break block2;
            }
            AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
            if (playerEventListener == null) break block2;
            playerEventListener.onInfo(what, extra);
        }
        return true;
    }

    public void onBufferingUpdate(@NotNull MediaPlayer mp, int percent) {
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        this.mBufferedPercent = percent;
    }

    public void onPrepared(@NotNull MediaPlayer mp) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
            AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
            if (playerEventListener != null) {
                playerEventListener.onPrepared();
            }
            this.start();
            if (this.isVideo()) break block2;
            AbstractPlayer.PlayerEventListener playerEventListener2 = this.mPlayerEventListener;
            if (playerEventListener2 != null) {
                playerEventListener2.onInfo(3, 0);
            }
        }
    }

    private final boolean isVideo() {
        try {
            MediaPlayer.TrackInfo[] trackInfoArray = this.mMediaPlayer;
            if (this.mMediaPlayer != null && (trackInfoArray = trackInfoArray.getTrackInfo()) != null) {
                MediaPlayer.TrackInfo[] it = trackInfoArray;
                boolean bl = false;
                for (MediaPlayer.TrackInfo info : it) {
                    if (info.getTrackType() != 1) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public void onVideoSizeChanged(@NotNull MediaPlayer mp, int width, int height) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
            int videoWidth = mp.getVideoWidth();
            int videoHeight = mp.getVideoHeight();
            if (videoWidth == 0 || videoHeight == 0) break block1;
            AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
            if (playerEventListener != null) {
                playerEventListener.onVideoSizeChanged(videoWidth, videoHeight);
            }
        }
    }
}

