/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.tplayer_core.controller;

import android.app.Activity;
import android.content.Context;
import android.media.AudioManager;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import com.talpa.tplayer_core.bridge.ControlWrapper;
import com.talpa.tplayer_core.controller.BaseVideoController;
import com.talpa.tplayer_core.controller.inter.IControlComponent;
import com.talpa.tplayer_core.controller.inter.IGestureComponent;
import com.talpa.tplayer_core.util.ExtensionKt;
import com.talpa.tplayer_core.util.PlayerUtils;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0015\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B%\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\u0011H\u0002J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$H\u0016J(\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u000fH\u0016J\u0010\u0010,\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0016J(\u0010-\u001a\u00020\u00112\u0006\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020$2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u000fH\u0016J\u0010\u00100\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u00101\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u00102\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u00103\u001a\u00020\u00112\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020$H\u0016J\u0010\u00107\u001a\u00020\u00112\u0006\u00106\u001a\u00020$H\u0016J\u000e\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020\u0011J\u000e\u0010:\u001a\u00020 2\u0006\u0010;\u001a\u00020\u0011J\u000e\u0010<\u001a\u00020 2\u0006\u0010=\u001a\u00020\u0011J\u000e\u0010>\u001a\u00020 2\u0006\u0010?\u001a\u00020\u0011J\u0010\u0010@\u001a\u00020 2\u0006\u0010A\u001a\u00020\nH\u0016J\u0010\u0010B\u001a\u00020 2\u0006\u0010C\u001a\u00020\nH\u0016J\u0010\u0010D\u001a\u00020 2\u0006\u0010E\u001a\u00020\u000fH\u0004J\u0010\u0010F\u001a\u00020 2\u0006\u0010G\u001a\u00020\u000fH\u0004J\u0010\u0010H\u001a\u00020 2\u0006\u0010E\u001a\u00020\u000fH\u0004J\b\u0010I\u001a\u00020 H\u0002R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/talpa/tplayer_core/controller/GestureVideoController;", "Lcom/talpa/tplayer_core/controller/BaseVideoController;", "Landroid/view/GestureDetector$OnGestureListener;", "Landroid/view/GestureDetector$OnDoubleTapListener;", "Landroid/view/View$OnTouchListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mAudioManager", "Landroid/media/AudioManager;", "mBrightness", "", "mCanChangePosition", "", "mCanSlide", "mChangeBrightness", "mChangePosition", "mChangeVolume", "mCurPlayState", "mEnableInNormal", "mFirstTouch", "mGestureDetector", "Landroid/view/GestureDetector;", "mIsDoubleTapTogglePlayEnabled", "mIsGestureEnabled", "mSeekPosition", "mStreamVolume", "initView", "", "isInPlaybackState", "onDoubleTap", "e", "Landroid/view/MotionEvent;", "onDoubleTapEvent", "onDown", "onFling", "e1", "e2", "velocityX", "velocityY", "onLongPress", "onScroll", "distanceX", "distanceY", "onShowPress", "onSingleTapConfirmed", "onSingleTapUp", "onTouch", "v", "Landroid/view/View;", "event", "onTouchEvent", "setCanChangePosition", "canChangePosition", "setDoubleTapTogglePlayEnabled", "enabled", "setEnableInNormal", "enableInNormal", "setGestureEnabled", "gestureEnabled", "setPlayState", "playState", "setPlayerState", "playerState", "slideToChangeBrightness", "deltaY", "slideToChangePosition", "deltaX", "slideToChangeVolume", "stopSlide", "com.talpa.tplayer_core"})
public abstract class GestureVideoController
extends BaseVideoController
implements GestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener,
View.OnTouchListener {
    @Nullable
    private GestureDetector mGestureDetector;
    @Nullable
    private AudioManager mAudioManager;
    private boolean mIsGestureEnabled;
    private int mStreamVolume;
    private float mBrightness;
    private int mSeekPosition;
    private boolean mFirstTouch;
    private boolean mChangePosition;
    private boolean mChangeBrightness;
    private boolean mChangeVolume;
    private boolean mCanChangePosition;
    private boolean mEnableInNormal;
    private boolean mCanSlide;
    private int mCurPlayState;
    private boolean mIsDoubleTapTogglePlayEnabled;

    @JvmOverloads
    public GestureVideoController(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.mIsGestureEnabled = true;
        this.mSeekPosition = -1;
        this.mCanChangePosition = true;
        this.mIsDoubleTapTogglePlayEnabled = true;
    }

    public /* synthetic */ GestureVideoController(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Override
    protected void initView() {
        super.initView();
        this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)this);
        this.setOnTouchListener(this);
    }

    public final void setCanChangePosition(boolean canChangePosition) {
        this.mCanChangePosition = canChangePosition;
    }

    public final void setEnableInNormal(boolean enableInNormal) {
        this.mEnableInNormal = enableInNormal;
    }

    public final void setGestureEnabled(boolean gestureEnabled) {
        this.mIsGestureEnabled = gestureEnabled;
    }

    public final void setDoubleTapTogglePlayEnabled(boolean enabled) {
        this.mIsDoubleTapTogglePlayEnabled = enabled;
    }

    @Override
    public void setPlayerState(int playerState) {
        super.setPlayerState(playerState);
        switch (playerState) {
            case 10: {
                this.mCanSlide = this.mEnableInNormal;
                break;
            }
            case 11: {
                this.mCanSlide = true;
            }
        }
    }

    @Override
    public void setPlayState(int playState) {
        super.setPlayState(playState);
        this.mCurPlayState = playState;
    }

    private final boolean isInPlaybackState() {
        return this.mControlWrapper != null && this.mCurPlayState != -1 && this.mCurPlayState != 0 && this.mCurPlayState != 1 && this.mCurPlayState != 2 && this.mCurPlayState != 8 && this.mCurPlayState != 5;
    }

    public boolean onTouch(@NotNull View v, @NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GestureDetector gestureDetector = this.mGestureDetector;
        return ExtensionKt.toDefaultValue$default(gestureDetector != null ? Boolean.valueOf(gestureDetector.onTouchEvent(event)) : null, false, 1, null);
    }

    public boolean onDown(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.isInPlaybackState() || !this.mIsGestureEnabled || PlayerUtils.isEdge(this.getContext(), e)) {
            return true;
        }
        AudioManager audioManager = this.mAudioManager;
        this.mStreamVolume = ExtensionKt.toDefaultValue$default(audioManager != null ? Integer.valueOf(audioManager.getStreamVolume(3)) : null, 0, 1, null);
        Activity activity = PlayerUtils.scanForActivity(this.getContext());
        Activity activity2 = activity;
        this.mBrightness = ExtensionKt.toDefaultValue$default(activity2 != null && (activity2 = activity2.getWindow()) != null && (activity2 = activity2.getAttributes()) != null ? Float.valueOf(activity2.screenBrightness) : null, 0.0f, 1, null);
        this.mFirstTouch = true;
        this.mChangePosition = false;
        this.mChangeBrightness = false;
        this.mChangeVolume = false;
        return true;
    }

    public boolean onSingleTapConfirmed(@NotNull MotionEvent e) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!this.isInPlaybackState()) break block1;
            ControlWrapper controlWrapper = this.mControlWrapper;
            if (controlWrapper != null) {
                controlWrapper.toggleShowState();
            }
        }
        return true;
    }

    public boolean onDoubleTap(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.mIsDoubleTapTogglePlayEnabled && !this.isLocked() && this.isInPlaybackState()) {
            this.togglePlay();
        }
        return true;
    }

    public boolean onScroll(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float distanceX, float distanceY) {
        Intrinsics.checkNotNullParameter((Object)e1, (String)"e1");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
        if (!this.isInPlaybackState() || !this.mIsGestureEnabled || !this.mCanSlide || this.isLocked() || PlayerUtils.isEdge(this.getContext(), e1)) {
            return true;
        }
        float deltaX = e1.getX() - e2.getX();
        float deltaY = e1.getY() - e2.getY();
        if (this.mFirstTouch) {
            boolean bl = this.mChangePosition = Math.abs(distanceX) >= Math.abs(distanceY);
            if (!this.mChangePosition) {
                int halfScreen = PlayerUtils.getScreenWidth(this.getContext(), true) / 2;
                if (e2.getX() > (float)halfScreen) {
                    this.mChangeVolume = true;
                } else {
                    this.mChangeBrightness = true;
                }
            }
            if (this.mChangePosition) {
                this.mChangePosition = this.mCanChangePosition;
            }
            if (this.mChangePosition || this.mChangeBrightness || this.mChangeVolume) {
                Iterator iterator = ((Map)this.mControlComponents).entrySet().iterator();
                while (iterator.hasNext()) {
                    IControlComponent component = (IControlComponent)iterator.next().getKey();
                    if (!(component instanceof IGestureComponent)) continue;
                    ((IGestureComponent)component).onStartSlide();
                }
            }
            this.mFirstTouch = false;
        }
        if (this.mChangePosition) {
            this.slideToChangePosition(deltaX);
        } else if (this.mChangeBrightness) {
            this.slideToChangeBrightness(deltaY);
        } else if (this.mChangeVolume) {
            this.slideToChangeVolume(deltaY);
        }
        return true;
    }

    protected final void slideToChangePosition(float deltaX) {
        float deltaX2 = deltaX;
        deltaX2 = -deltaX2;
        int width = this.getMeasuredWidth();
        ControlWrapper controlWrapper = this.mControlWrapper;
        long duration = ExtensionKt.toDefaultValue$default(controlWrapper != null ? Long.valueOf(controlWrapper.getDuration()) : null, 0L, 1, null);
        ControlWrapper controlWrapper2 = this.mControlWrapper;
        long currentPosition = ExtensionKt.toDefaultValue$default(controlWrapper2 != null ? Long.valueOf(controlWrapper2.getCurrentPosition()) : null, 0L, 1, null);
        int position = (int)(deltaX2 / (float)width * (float)120000 + (float)currentPosition);
        if ((long)position > duration) {
            position = (int)duration;
        }
        if (position < 0) {
            position = 0;
        }
        Iterator iterator = ((Map)this.mControlComponents).entrySet().iterator();
        while (iterator.hasNext()) {
            IControlComponent component = (IControlComponent)iterator.next().getKey();
            if (!(component instanceof IGestureComponent)) continue;
            ((IGestureComponent)component).onPositionChange(position, (int)currentPosition, (int)duration);
        }
        this.mSeekPosition = position;
    }

    protected final void slideToChangeBrightness(float deltaY) {
        float brightness;
        Activity activity = PlayerUtils.scanForActivity(this.getContext());
        if (activity == null) {
            return;
        }
        Activity activity2 = activity;
        Window window = activity2.getWindow();
        WindowManager.LayoutParams attributes = window.getAttributes();
        int height = this.getMeasuredHeight();
        if (this.mBrightness == -1.0f) {
            this.mBrightness = 0.5f;
        }
        if ((brightness = deltaY * (float)2 / (float)height + this.mBrightness) < 0.0f) {
            brightness = 0.0f;
        }
        if (brightness > 1.0f) {
            brightness = 1.0f;
        }
        int percent = (int)(brightness * (float)100);
        attributes.screenBrightness = brightness;
        window.setAttributes(attributes);
        Iterator iterator = ((Map)this.mControlComponents).entrySet().iterator();
        while (iterator.hasNext()) {
            IControlComponent component = (IControlComponent)iterator.next().getKey();
            if (!(component instanceof IGestureComponent)) continue;
            ((IGestureComponent)component).onBrightnessChange(percent);
        }
    }

    protected final void slideToChangeVolume(float deltaY) {
        AudioManager audioManager = this.mAudioManager;
        int streamMaxVolume = ExtensionKt.toDefaultValue$default(audioManager != null ? Integer.valueOf(audioManager.getStreamMaxVolume(3)) : null, 0, 1, null);
        int height = this.getMeasuredHeight();
        float deltaV = deltaY * (float)2 / (float)height * (float)streamMaxVolume;
        float index = (float)this.mStreamVolume + deltaV;
        if (index > (float)streamMaxVolume) {
            index = streamMaxVolume;
        }
        if (index < 0.0f) {
            index = 0.0f;
        }
        int percent = (int)(index / (float)streamMaxVolume * (float)100);
        AudioManager audioManager2 = this.mAudioManager;
        if (audioManager2 != null) {
            audioManager2.setStreamVolume(3, (int)index, 0);
        }
        Iterator iterator = ((Map)this.mControlComponents).entrySet().iterator();
        while (iterator.hasNext()) {
            IControlComponent component = (IControlComponent)iterator.next().getKey();
            if (!(component instanceof IGestureComponent)) continue;
            ((IGestureComponent)component).onVolumeChange(percent);
        }
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GestureDetector gestureDetector = this.mGestureDetector;
        if (!ExtensionKt.toDefaultValue$default(gestureDetector != null ? Boolean.valueOf(gestureDetector.onTouchEvent(event)) : null, false, 1, null)) {
            int action = event.getAction();
            switch (action) {
                case 1: {
                    this.stopSlide();
                    if (this.mSeekPosition < 0) break;
                    ControlWrapper controlWrapper = this.mControlWrapper;
                    if (controlWrapper != null) {
                        controlWrapper.seekTo(this.mSeekPosition);
                    }
                    this.mSeekPosition = -1;
                    break;
                }
                case 3: {
                    this.stopSlide();
                    this.mSeekPosition = -1;
                }
            }
        }
        return super.onTouchEvent(event);
    }

    private final void stopSlide() {
        Iterator iterator = ((Map)this.mControlComponents).entrySet().iterator();
        while (iterator.hasNext()) {
            IControlComponent component = (IControlComponent)iterator.next().getKey();
            if (!(component instanceof IGestureComponent)) continue;
            ((IGestureComponent)component).onStopSlide();
        }
    }

    public boolean onFling(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float velocityX, float velocityY) {
        Intrinsics.checkNotNullParameter((Object)e1, (String)"e1");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
        return false;
    }

    public void onLongPress(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    public void onShowPress(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    public boolean onDoubleTapEvent(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return false;
    }

    public boolean onSingleTapUp(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return false;
    }

    @JvmOverloads
    public GestureVideoController(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public GestureVideoController(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

