/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.tplayer_core.tplayer;

import android.app.Application;
import com.talpa.tplayer_core.config.VideoViewConfig;
import com.talpa.tplayer_core.ui.VideoView;
import com.talpa.tplayer_core.util.ExtensionKt;
import com.talpa.tplayer_core.util.L;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0007J\u0013\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0007H\u0086\u0002J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010\u000f\u001a\u00020\u0004J\u001a\u0010\u0010\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\u0011\u001a\u00020\u0004H\u0007J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010\u0013\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/talpa/tplayer_core/tplayer/VideoViewManager;", "", "()V", "mPlayOnMobileNetwork", "", "mVideoViews", "Ljava/util/LinkedHashMap;", "", "Lcom/talpa/tplayer_core/ui/VideoView;", "add", "", "videoView", "tag", "get", "onBackPress", "playOnMobileNetwork", "releaseByTag", "isRemove", "remove", "removeAll", "setPlayOnMobileNetwork", "Companion", "com.talpa.tplayer_core"})
public final class VideoViewManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinkedHashMap<String, VideoView> mVideoViews = new LinkedHashMap();
    private boolean mPlayOnMobileNetwork;
    @Nullable
    private static VideoViewManager sInstance;
    @Nullable
    private static VideoViewConfig sConfig;

    private VideoViewManager() {
        VideoViewConfig videoViewConfig = Companion.getConfig();
        this.mPlayOnMobileNetwork = ExtensionKt.toDefaultValue$default(videoViewConfig != null ? Boolean.valueOf(videoViewConfig.mPlayOnMobileNetwork) : null, false, 1, null);
    }

    public final boolean playOnMobileNetwork() {
        return this.mPlayOnMobileNetwork;
    }

    public final void setPlayOnMobileNetwork(boolean playOnMobileNetwork) {
        this.mPlayOnMobileNetwork = playOnMobileNetwork;
    }

    public final void add(@Nullable VideoView videoView, @NotNull String tag) {
        VideoView old;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (videoView == null) {
            return;
        }
        if (!(videoView.getContext() instanceof Application)) {
            L.w("The Context of this VideoView is not an Application Context,you must remove it after release,or it will lead to memory leek.");
        }
        if ((old = this.get(tag)) != null) {
            old.release();
            this.remove(tag);
        }
        ((Map)this.mVideoViews).put(tag, videoView);
    }

    @Nullable
    public final VideoView get(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return this.mVideoViews.get(tag);
    }

    public final void remove(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.mVideoViews.remove(tag);
    }

    public final void removeAll() {
        this.mVideoViews.clear();
    }

    @JvmOverloads
    public final void releaseByTag(@NotNull String tag, boolean isRemove) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        VideoView videoView = this.get(tag);
        if (videoView != null) {
            videoView.release();
            if (isRemove) {
                this.remove(tag);
            }
        }
    }

    public static /* synthetic */ void releaseByTag$default(VideoViewManager videoViewManager, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        videoViewManager.releaseByTag(string, bl);
    }

    public final boolean onBackPress(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        VideoView videoView = this.get(tag);
        if (videoView == null) {
            return false;
        }
        VideoView videoView2 = videoView;
        return videoView2.onBackPressed();
    }

    @JvmOverloads
    public final void releaseByTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        VideoViewManager.releaseByTag$default(this, tag, false, 2, null);
    }

    public /* synthetic */ VideoViewManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u0004\u0018\u00010\u000bR(\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/talpa/tplayer_core/tplayer/VideoViewManager$Companion;", "", "()V", "config", "Lcom/talpa/tplayer_core/config/VideoViewConfig;", "getConfig", "()Lcom/talpa/tplayer_core/config/VideoViewConfig;", "setConfig", "(Lcom/talpa/tplayer_core/config/VideoViewConfig;)V", "sConfig", "sInstance", "Lcom/talpa/tplayer_core/tplayer/VideoViewManager;", "instance", "com.talpa.tplayer_core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final VideoViewConfig getConfig() {
            this.setConfig(null);
            return sConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setConfig(@Nullable VideoViewConfig config) {
            if (sConfig == null) {
                Class<VideoViewConfig> clazz = VideoViewConfig.class;
                synchronized (clazz) {
                    boolean bl = false;
                    if (sConfig == null) {
                        VideoViewConfig videoViewConfig = config;
                        if (videoViewConfig == null) {
                            videoViewConfig = VideoViewConfig.Companion.newBuilder().build();
                        }
                        sConfig = videoViewConfig;
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final VideoViewManager instance() {
            if (sInstance == null) {
                Class<VideoViewManager> clazz = VideoViewManager.class;
                synchronized (clazz) {
                    boolean bl = false;
                    if (sInstance == null) {
                        sInstance = new VideoViewManager(null);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            return sInstance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

