/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.tplayer_core.controller;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import androidx.annotation.CallSuper;
import com.talpa.tplayer_core.bridge.ControlWrapper;
import com.talpa.tplayer_core.config.VideoViewConfig;
import com.talpa.tplayer_core.controller.OrientationHelper;
import com.talpa.tplayer_core.controller.inter.IControlComponent;
import com.talpa.tplayer_core.controller.inter.IVideoController;
import com.talpa.tplayer_core.controller.inter.MediaPlayerControl;
import com.talpa.tplayer_core.tplayer.VideoViewManager;
import com.talpa.tplayer_core.util.CutoutUtil;
import com.talpa.tplayer_core.util.ExtensionKt;
import com.talpa.tplayer_core.util.L;
import com.talpa.tplayer_core.util.PlayerUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b/\n\u0002\u0018\u0002\n\u0002\b\u000f\b&\u0018\u0000 m2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001mB%\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u00112\u0006\u0010.\u001a\u00020\u000eH\u0016J%\u0010+\u001a\u00020,2\u0016\u0010-\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110/\"\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u00100J\b\u00101\u001a\u00020,H\u0002J\b\u00102\u001a\u00020\tH\u0016J\b\u00103\u001a\u00020\tH$J\u0010\u00104\u001a\u00020,2\u0006\u00105\u001a\u00020\u000eH\u0002J\u0012\u00106\u001a\u00020,2\b\b\u0001\u00107\u001a\u00020\tH\u0002J\u0012\u00108\u001a\u00020,2\b\b\u0001\u00109\u001a\u00020\tH\u0002J\u0018\u0010:\u001a\u00020,2\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020\tH\u0002J\u001a\u0010=\u001a\u00020,2\u0006\u0010>\u001a\u00020\u000e2\b\u0010?\u001a\u0004\u0018\u00010\u001fH\u0002J\b\u0010@\u001a\u00020\u000eH\u0016J\b\u0010A\u001a\u00020,H\u0016J\b\u0010B\u001a\u00020,H\u0014J\b\u00105\u001a\u00020\u000eH\u0016J\b\u0010C\u001a\u00020\u000eH\u0016J\b\u0010D\u001a\u00020,H\u0014J\b\u0010E\u001a\u00020\u000eH\u0016J\u0010\u0010F\u001a\u00020,2\u0006\u00105\u001a\u00020\u000eH\u0014J\u0010\u0010G\u001a\u00020,2\u0006\u0010H\u001a\u00020\tH\u0017J\u0012\u0010I\u001a\u00020,2\b\u0010J\u001a\u0004\u0018\u00010\fH\u0014J\u0012\u0010K\u001a\u00020,2\b\u0010J\u001a\u0004\u0018\u00010\fH\u0014J\u0012\u0010L\u001a\u00020,2\b\u0010J\u001a\u0004\u0018\u00010\fH\u0014J\u0012\u0010M\u001a\u00020,2\b\b\u0001\u00107\u001a\u00020\tH\u0015J\u0012\u0010N\u001a\u00020,2\b\b\u0001\u00109\u001a\u00020\tH\u0015J\u001a\u0010O\u001a\u00020,2\u0006\u0010>\u001a\u00020\u000e2\b\u0010?\u001a\u0004\u0018\u00010\u001fH\u0014J\u0010\u0010P\u001a\u00020,2\u0006\u0010Q\u001a\u00020\u000eH\u0016J\b\u0010R\u001a\u00020,H\u0016J\b\u0010S\u001a\u00020,H\u0016J\u0012\u0010T\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010U\u001a\u00020,2\u0006\u0010V\u001a\u00020\u000eH\u0016J\u0010\u0010W\u001a\u00020,2\u0006\u0010X\u001a\u00020\tH\u0016J\u0010\u0010Y\u001a\u00020,2\u0006\u0010Z\u001a\u00020\u000eH\u0016J\u0010\u0010[\u001a\u00020,2\u0006\u0010\\\u001a\u00020\u000eH\u0016J\u0012\u0010]\u001a\u00020,2\b\u0010^\u001a\u0004\u0018\u00010_H\u0017J\u0012\u0010`\u001a\u00020,2\b\b\u0001\u00107\u001a\u00020\tH\u0017J\u0012\u0010a\u001a\u00020,2\b\b\u0001\u00109\u001a\u00020\tH\u0017J\b\u0010b\u001a\u00020\tH\u0002J\u0018\u0010b\u001a\u00020,2\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020\tH\u0014J\b\u0010c\u001a\u00020,H\u0016J\b\u0010d\u001a\u00020\u000eH\u0016J\b\u0010e\u001a\u00020,H\u0016J\b\u0010f\u001a\u00020\u000eH\u0014J\b\u0010g\u001a\u00020,H\u0016J\b\u0010h\u001a\u00020,H\u0016J\b\u0010i\u001a\u00020\u000eH\u0014J\b\u0010j\u001a\u00020,H\u0016J\b\u0010k\u001a\u00020,H\u0014J\b\u0010l\u001a\u00020,H\u0014R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e0\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e`\u00128\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00148\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\t8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u00020\u000e8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u0004\u0018\u00010$8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u00020\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001b\"\u0004\b(\u0010)R\u0012\u0010*\u001a\u00020\u000e8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006n"}, d2={"Lcom/talpa/tplayer_core/controller/BaseVideoController;", "Landroid/widget/FrameLayout;", "Lcom/talpa/tplayer_core/controller/inter/IVideoController;", "Lcom/talpa/tplayer_core/controller/OrientationHelper$OnOrientationChangeListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mActivity", "Landroid/app/Activity;", "mAdaptCutout", "", "mControlComponents", "Ljava/util/LinkedHashMap;", "Lcom/talpa/tplayer_core/controller/inter/IControlComponent;", "Lkotlin/collections/LinkedHashMap;", "mControlWrapper", "Lcom/talpa/tplayer_core/bridge/ControlWrapper;", "mCutoutHeight", "mDefaultTimeout", "mEnableOrientation", "mFadeOut", "Ljava/lang/Runnable;", "getMFadeOut", "()Ljava/lang/Runnable;", "mHasCutout", "Ljava/lang/Boolean;", "mHideAnim", "Landroid/view/animation/Animation;", "mIsLocked", "mIsStartProgress", "mOrientation", "mOrientationHelper", "Lcom/talpa/tplayer_core/controller/OrientationHelper;", "mShowAnim", "mShowProgress", "getMShowProgress", "setMShowProgress", "(Ljava/lang/Runnable;)V", "mShowing", "addControlComponent", "", "component", "isDissociate", "", "([Lcom/talpa/tplayer_core/controller/inter/IControlComponent;)V", "checkCutout", "getCutoutHeight", "getLayoutId", "handleLockStateChanged", "isLocked", "handlePlayStateChanged", "playState", "handlePlayerStateChanged", "playerState", "handleSetProgress", "duration", "position", "handleVisibilityChanged", "isVisible", "anim", "hasCutout", "hide", "initView", "isShowing", "onAttachedToWindow", "onBackPressed", "onLockStateChanged", "onOrientationChanged", "orientation", "onOrientationLandscape", "activity", "onOrientationPortrait", "onOrientationReverseLandscape", "onPlayStateChanged", "onPlayerStateChanged", "onVisibilityChanged", "onWindowFocusChanged", "hasWindowFocus", "removeAllControlComponent", "removeAllDissociateComponents", "removeControlComponent", "setAdaptCutout", "adaptCutout", "setDismissTimeout", "timeout", "setEnableOrientation", "enableOrientation", "setLocked", "locked", "setMediaPlayer", "mediaPlayer", "Lcom/talpa/tplayer_core/controller/inter/MediaPlayerControl;", "setPlayState", "setPlayerState", "setProgress", "show", "showNetWarning", "startFadeOut", "startFullScreen", "startProgress", "stopFadeOut", "stopFullScreen", "stopProgress", "toggleFullScreen", "togglePlay", "Companion", "com.talpa.tplayer_core"})
public abstract class BaseVideoController
extends FrameLayout
implements IVideoController,
OrientationHelper.OnOrientationChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @Nullable
    protected ControlWrapper mControlWrapper;
    @JvmField
    @Nullable
    protected Activity mActivity;
    @JvmField
    protected boolean mShowing;
    @JvmField
    protected boolean mIsLocked;
    @JvmField
    protected int mDefaultTimeout;
    private boolean mEnableOrientation;
    @JvmField
    @Nullable
    protected OrientationHelper mOrientationHelper;
    private boolean mAdaptCutout;
    @Nullable
    private Boolean mHasCutout;
    private int mCutoutHeight;
    private boolean mIsStartProgress;
    @JvmField
    @NotNull
    protected LinkedHashMap<IControlComponent, Boolean> mControlComponents;
    @Nullable
    private Animation mShowAnim;
    @Nullable
    private Animation mHideAnim;
    @NotNull
    private final Runnable mFadeOut;
    @NotNull
    private Runnable mShowProgress;
    private int mOrientation;
    public static final long DEFAULT_DURATION = 300L;
    public static final int DEFAULT_TIMEOUT = 4000;
    public static final long DEFAULT_DELAY = 800L;

    @JvmOverloads
    public BaseVideoController(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.mDefaultTimeout = 4000;
        this.mControlComponents = new LinkedHashMap();
        this.initView();
        this.mFadeOut = () -> BaseVideoController.mFadeOut$lambda-4(this);
        this.mShowProgress = new Runnable(this){
            final /* synthetic */ BaseVideoController this$0;
            {
                this.this$0 = $receiver;
            }

            public void run() {
                int pos = BaseVideoController.access$setProgress(this.this$0);
                ControlWrapper controlWrapper = this.this$0.mControlWrapper;
                if (ExtensionKt.toDefaultValue$default(controlWrapper != null ? Boolean.valueOf(controlWrapper.isPlaying()) : null, false, 1, null)) {
                    ControlWrapper controlWrapper2 = this.this$0.mControlWrapper;
                    this.this$0.postDelayed(this, (long)((float)(1000 - pos % 1000) / ExtensionKt.toDefaultValue$default(controlWrapper2 != null ? Float.valueOf(controlWrapper2.getSpeed()) : null, 0.0f, 1, null)));
                } else {
                    BaseVideoController.access$setMIsStartProgress$p(this.this$0, false);
                }
            }
        };
    }

    public /* synthetic */ BaseVideoController(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    protected void initView() {
        if (this.getLayoutId() != 0) {
            LayoutInflater.from((Context)this.getContext()).inflate(this.getLayoutId(), (ViewGroup)this, true);
        }
        this.mOrientationHelper = new OrientationHelper(this.getContext().getApplicationContext());
        VideoViewConfig videoViewConfig = VideoViewManager.Companion.getConfig();
        this.mEnableOrientation = ExtensionKt.toDefaultValue$default(videoViewConfig != null ? Boolean.valueOf(videoViewConfig.mEnableOrientation) : null, false, 1, null);
        VideoViewConfig videoViewConfig2 = VideoViewManager.Companion.getConfig();
        this.mAdaptCutout = ExtensionKt.toDefaultValue$default(videoViewConfig2 != null ? Boolean.valueOf(videoViewConfig2.mAdaptCutout) : null, false, 1, null);
        Animation animation = this.mShowAnim = (Animation)new AlphaAnimation(0.0f, 1.0f);
        if (animation != null) {
            animation.setDuration(300L);
        }
        Animation animation2 = this.mHideAnim = (Animation)new AlphaAnimation(1.0f, 0.0f);
        if (animation2 != null) {
            animation2.setDuration(300L);
        }
        this.mActivity = PlayerUtils.scanForActivity(this.getContext());
    }

    protected abstract int getLayoutId();

    @CallSuper
    public void setMediaPlayer(@Nullable MediaPlayerControl mediaPlayer) {
        block1: {
            this.mControlWrapper = new ControlWrapper(mediaPlayer, this);
            Set<Map.Entry<IControlComponent, Boolean>> set = this.mControlComponents.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"mControlComponents.entries");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                ((IControlComponent)it.getKey()).attach(this.mControlWrapper);
            }
            OrientationHelper orientationHelper = this.mOrientationHelper;
            if (orientationHelper == null) break block1;
            orientationHelper.setOnOrientationChangeListener(this);
        }
    }

    public void addControlComponent(IControlComponent ... component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        for (IControlComponent item : component) {
            this.addControlComponent(item, false);
        }
    }

    public void addControlComponent(@Nullable IControlComponent component, boolean isDissociate) {
        block1: {
            IControlComponent iControlComponent = component;
            if (iControlComponent == null) break block1;
            IControlComponent it = iControlComponent;
            boolean bl = false;
            Boolean bl2 = isDissociate;
            ((Map)this.mControlComponents).put(it, bl2);
            it.attach(this.mControlWrapper);
            View view = it.getView();
            if (view != null && !isDissociate) {
                this.addView(view, 0);
            }
        }
    }

    public void removeControlComponent(@Nullable IControlComponent component) {
        block0: {
            IControlComponent iControlComponent = component;
            if (iControlComponent == null) break block0;
            IControlComponent it = iControlComponent;
            boolean bl = false;
            this.removeView(it.getView());
            Boolean cfr_ignored_0 = (Boolean)this.mControlComponents.remove(it);
        }
    }

    public void removeAllControlComponent() {
        Set<Map.Entry<IControlComponent, Boolean>> set = this.mControlComponents.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"mControlComponents.entries");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            this.removeView(((IControlComponent)it.getKey()).getView());
        }
        this.mControlComponents.clear();
    }

    public void removeAllDissociateComponents() {
        Iterator<Map.Entry<IControlComponent, Boolean>> it = this.mControlComponents.entrySet().iterator();
        while (it.hasNext()) {
            boolean value = it.next().getValue();
            if (!value) continue;
            it.remove();
        }
    }

    @CallSuper
    public void setPlayState(int playState) {
        this.handlePlayStateChanged(playState);
    }

    @CallSuper
    public void setPlayerState(int playerState) {
        this.handlePlayerStateChanged(playerState);
    }

    public void setDismissTimeout(int timeout) {
        if (timeout > 0) {
            this.mDefaultTimeout = timeout;
        }
    }

    @Override
    public void hide() {
        if (this.mShowing) {
            this.stopFadeOut();
            this.handleVisibilityChanged(false, this.mHideAnim);
            this.mShowing = false;
        }
    }

    @Override
    public void show() {
        if (!this.mShowing) {
            this.handleVisibilityChanged(true, this.mShowAnim);
            this.startFadeOut();
            this.mShowing = true;
        }
    }

    @Override
    public boolean isShowing() {
        return this.mShowing;
    }

    @Override
    public void startFadeOut() {
        this.stopFadeOut();
        this.postDelayed(this.mFadeOut, this.mDefaultTimeout);
    }

    @Override
    public void stopFadeOut() {
        this.removeCallbacks(this.mFadeOut);
    }

    @NotNull
    protected final Runnable getMFadeOut() {
        return this.mFadeOut;
    }

    @Override
    public void setLocked(boolean locked) {
        this.mIsLocked = locked;
        this.handleLockStateChanged(locked);
    }

    @Override
    public boolean isLocked() {
        return this.mIsLocked;
    }

    @Override
    public void startProgress() {
        if (this.mIsStartProgress) {
            return;
        }
        this.post(this.mShowProgress);
        this.mIsStartProgress = true;
    }

    @Override
    public void stopProgress() {
        if (!this.mIsStartProgress) {
            return;
        }
        this.removeCallbacks(this.mShowProgress);
        this.mIsStartProgress = false;
    }

    @NotNull
    protected final Runnable getMShowProgress() {
        return this.mShowProgress;
    }

    protected final void setMShowProgress(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"<set-?>");
        this.mShowProgress = runnable;
    }

    private final int setProgress() {
        ControlWrapper controlWrapper = this.mControlWrapper;
        int position = (int)ExtensionKt.toDefaultValue$default(controlWrapper != null ? Long.valueOf(controlWrapper.getCurrentPosition()) : null, 0L, 1, null);
        ControlWrapper controlWrapper2 = this.mControlWrapper;
        int duration = (int)ExtensionKt.toDefaultValue$default(controlWrapper2 != null ? Long.valueOf(controlWrapper2.getDuration()) : null, 0L, 1, null);
        this.handleSetProgress(duration, position);
        return position;
    }

    public void setAdaptCutout(boolean adaptCutout) {
        this.mAdaptCutout = adaptCutout;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.checkCutout();
    }

    private final void checkCutout() {
        if (!this.mAdaptCutout) {
            return;
        }
        if (this.mActivity != null && this.mHasCutout == null) {
            this.mHasCutout = CutoutUtil.INSTANCE.allowDisplayToCutout(this.mActivity);
            if (ExtensionKt.toDefaultValue$default(this.mHasCutout, false, 1, null)) {
                this.mCutoutHeight = (int)PlayerUtils.getStatusBarHeightPortrait((Context)this.mActivity);
            }
        }
        L.d("hasCutout: " + this.mHasCutout + " cutout height: " + this.mCutoutHeight);
    }

    @Override
    public boolean hasCutout() {
        return ExtensionKt.toDefaultValue$default(this.mHasCutout, false, 1, null);
    }

    @Override
    public int getCutoutHeight() {
        return this.mCutoutHeight;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean showNetWarning() {
        if (PlayerUtils.getNetworkType(this.getContext()) != 4) return false;
        VideoViewManager videoViewManager = VideoViewManager.Companion.instance();
        if (ExtensionKt.toDefaultValue$default(videoViewManager != null ? Boolean.valueOf(videoViewManager.playOnMobileNetwork()) : null, false, 1, null)) return false;
        return true;
    }

    protected void togglePlay() {
        block0: {
            ControlWrapper controlWrapper = this.mControlWrapper;
            if (controlWrapper == null) break block0;
            controlWrapper.togglePlay();
        }
    }

    protected void toggleFullScreen() {
        block0: {
            ControlWrapper controlWrapper = this.mControlWrapper;
            if (controlWrapper == null) break block0;
            controlWrapper.toggleFullScreen(this.mActivity);
        }
    }

    protected boolean startFullScreen() {
        block6: {
            block5: {
                block4: {
                    if (this.mActivity == null) break block4;
                    Activity activity = this.mActivity;
                    if (!ExtensionKt.toDefaultValue$default(activity != null ? Boolean.valueOf(activity.isFinishing()) : null, false, 1, null)) break block5;
                }
                return false;
            }
            Activity activity = this.mActivity;
            if (activity != null) {
                activity.setRequestedOrientation(0);
            }
            ControlWrapper controlWrapper = this.mControlWrapper;
            if (controlWrapper == null) break block6;
            controlWrapper.startFullScreen();
        }
        return true;
    }

    protected boolean stopFullScreen() {
        block6: {
            block5: {
                block4: {
                    if (this.mActivity == null) break block4;
                    Activity activity = this.mActivity;
                    if (!ExtensionKt.toDefaultValue$default(activity != null ? Boolean.valueOf(activity.isFinishing()) : null, false, 1, null)) break block5;
                }
                return false;
            }
            Activity activity = this.mActivity;
            if (activity != null) {
                activity.setRequestedOrientation(1);
            }
            ControlWrapper controlWrapper = this.mControlWrapper;
            if (controlWrapper == null) break block6;
            controlWrapper.stopFullScreen();
        }
        return true;
    }

    public boolean onBackPressed() {
        return false;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        block0: {
            block2: {
                block1: {
                    super.onWindowFocusChanged(hasWindowFocus);
                    ControlWrapper controlWrapper = this.mControlWrapper;
                    if (!ExtensionKt.toDefaultValue$default(controlWrapper != null ? Boolean.valueOf(controlWrapper.isPlaying()) : null, false, 1, null)) break block0;
                    if (this.mEnableOrientation) break block1;
                    ControlWrapper controlWrapper2 = this.mControlWrapper;
                    if (!ExtensionKt.toDefaultValue$default(controlWrapper2 != null ? Boolean.valueOf(controlWrapper2.isFullScreen()) : null, false, 1, null)) break block0;
                }
                if (!hasWindowFocus) break block2;
                this.postDelayed(() -> BaseVideoController.onWindowFocusChanged$lambda-5(this), 800L);
                break block0;
            }
            OrientationHelper orientationHelper = this.mOrientationHelper;
            if (orientationHelper == null) break block0;
            orientationHelper.disable();
        }
    }

    public void setEnableOrientation(boolean enableOrientation) {
        this.mEnableOrientation = enableOrientation;
    }

    @Override
    @CallSuper
    public void onOrientationChanged(int orientation) {
        block16: {
            block15: {
                if (this.mActivity == null) break block15;
                Activity activity = this.mActivity;
                if (!ExtensionKt.toDefaultValue$default(activity != null ? Boolean.valueOf(activity.isFinishing()) : null, false, 1, null)) break block16;
            }
            return;
        }
        int lastOrientation = this.mOrientation;
        if (orientation == -1) {
            this.mOrientation = -1;
            return;
        }
        if (orientation > 350 || orientation < 10) {
            Integer o;
            Activity activity = this.mActivity;
            Integer n = o = activity != null ? Integer.valueOf(activity.getRequestedOrientation()) : null;
            if (n != null && n == 0 && lastOrientation == 0) {
                return;
            }
            if (this.mOrientation == 0) {
                return;
            }
            this.mOrientation = 0;
            this.onOrientationPortrait(this.mActivity);
        } else {
            boolean bl = 81 <= orientation ? orientation < 100 : false;
            if (bl) {
                Integer o;
                Activity activity = this.mActivity;
                Integer n = o = activity != null ? Integer.valueOf(activity.getRequestedOrientation()) : null;
                int n2 = 1;
                if (n != null && n == n2 && lastOrientation == 90) {
                    return;
                }
                if (this.mOrientation == 90) {
                    return;
                }
                this.mOrientation = 90;
                this.onOrientationReverseLandscape(this.mActivity);
            } else {
                boolean bl2 = 261 <= orientation ? orientation < 280 : false;
                if (bl2) {
                    Integer o;
                    Activity activity = this.mActivity;
                    Integer n = o = activity != null ? Integer.valueOf(activity.getRequestedOrientation()) : null;
                    int n3 = 1;
                    if (n != null && n == n3 && lastOrientation == 270) {
                        return;
                    }
                    if (this.mOrientation == 270) {
                        return;
                    }
                    this.mOrientation = 270;
                    this.onOrientationLandscape(this.mActivity);
                }
            }
        }
    }

    protected void onOrientationPortrait(@Nullable Activity activity) {
        block3: {
            if (this.mIsLocked) {
                return;
            }
            if (!this.mEnableOrientation) {
                return;
            }
            Activity activity2 = activity;
            if (activity2 != null) {
                activity2.setRequestedOrientation(1);
            }
            ControlWrapper controlWrapper = this.mControlWrapper;
            if (controlWrapper == null) break block3;
            controlWrapper.stopFullScreen();
        }
    }

    protected void onOrientationLandscape(@Nullable Activity activity) {
        block2: {
            block1: {
                Activity activity2 = activity;
                if (activity2 != null) {
                    activity2.setRequestedOrientation(0);
                }
                ControlWrapper controlWrapper = this.mControlWrapper;
                if (!ExtensionKt.toDefaultValue$default(controlWrapper != null ? Boolean.valueOf(controlWrapper.isFullScreen()) : null, false, 1, null)) break block1;
                this.handlePlayerStateChanged(11);
                break block2;
            }
            ControlWrapper controlWrapper = this.mControlWrapper;
            if (controlWrapper == null) break block2;
            controlWrapper.startFullScreen();
        }
    }

    protected void onOrientationReverseLandscape(@Nullable Activity activity) {
        block2: {
            block1: {
                Activity activity2 = activity;
                if (activity2 != null) {
                    activity2.setRequestedOrientation(8);
                }
                ControlWrapper controlWrapper = this.mControlWrapper;
                if (!ExtensionKt.toDefaultValue$default(controlWrapper != null ? Boolean.valueOf(controlWrapper.isFullScreen()) : null, false, 1, null)) break block1;
                this.handlePlayerStateChanged(11);
                break block2;
            }
            ControlWrapper controlWrapper = this.mControlWrapper;
            if (controlWrapper == null) break block2;
            controlWrapper.startFullScreen();
        }
    }

    private final void handleVisibilityChanged(boolean isVisible, Animation anim) {
        if (!this.mIsLocked) {
            Set<Map.Entry<IControlComponent, Boolean>> set = this.mControlComponents.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"mControlComponents.entries");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                ((IControlComponent)it.getKey()).onVisibilityChanged(isVisible, anim);
            }
        }
        this.onVisibilityChanged(isVisible, anim);
    }

    protected void onVisibilityChanged(boolean isVisible, @Nullable Animation anim) {
    }

    private final void handlePlayStateChanged(int playState) {
        Set<Map.Entry<IControlComponent, Boolean>> set = this.mControlComponents.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"mControlComponents.entries");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            ((IControlComponent)it.getKey()).onPlayStateChanged(playState);
        }
        this.onPlayStateChanged(playState);
    }

    @CallSuper
    protected void onPlayStateChanged(int playState) {
        switch (playState) {
            case 0: {
                OrientationHelper orientationHelper = this.mOrientationHelper;
                if (orientationHelper != null) {
                    orientationHelper.disable();
                }
                this.mOrientation = 0;
                this.mIsLocked = false;
                this.mShowing = false;
                this.removeAllDissociateComponents();
                break;
            }
            case 5: {
                this.mIsLocked = false;
                this.mShowing = false;
                break;
            }
            case -1: {
                this.mShowing = false;
            }
        }
    }

    private final void handlePlayerStateChanged(int playerState) {
        Set<Map.Entry<IControlComponent, Boolean>> set = this.mControlComponents.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"mControlComponents.entries");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            ((IControlComponent)it.getKey()).onPlayerStateChanged(playerState);
        }
        this.onPlayerStateChanged(playerState);
    }

    @CallSuper
    protected void onPlayerStateChanged(int playerState) {
        switch (playerState) {
            case 10: {
                if (this.mEnableOrientation) {
                    OrientationHelper orientationHelper = this.mOrientationHelper;
                    if (orientationHelper != null) {
                        orientationHelper.enable();
                    }
                } else {
                    OrientationHelper orientationHelper = this.mOrientationHelper;
                    if (orientationHelper != null) {
                        orientationHelper.disable();
                    }
                }
                if (!this.hasCutout()) break;
                CutoutUtil.INSTANCE.adaptCutoutAboveAndroidP(this.getContext(), false);
                break;
            }
            case 11: {
                OrientationHelper orientationHelper = this.mOrientationHelper;
                if (orientationHelper != null) {
                    orientationHelper.enable();
                }
                if (!this.hasCutout()) break;
                CutoutUtil.INSTANCE.adaptCutoutAboveAndroidP(this.getContext(), true);
                break;
            }
            case 12: {
                OrientationHelper orientationHelper = this.mOrientationHelper;
                if (orientationHelper == null) break;
                orientationHelper.disable();
                break;
            }
        }
    }

    private final void handleSetProgress(int duration, int position) {
        Set<Map.Entry<IControlComponent, Boolean>> set = this.mControlComponents.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"mControlComponents.entries");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            ((IControlComponent)it.getKey()).setProgress(duration, position);
        }
        this.setProgress(duration, position);
    }

    protected void setProgress(int duration, int position) {
    }

    private final void handleLockStateChanged(boolean isLocked) {
        Set<Map.Entry<IControlComponent, Boolean>> set = this.mControlComponents.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"mControlComponents.entries");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            ((IControlComponent)it.getKey()).onLockStateChanged(isLocked);
        }
        this.onLockStateChanged(isLocked);
    }

    protected void onLockStateChanged(boolean isLocked) {
    }

    @JvmOverloads
    public BaseVideoController(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public BaseVideoController(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void mFadeOut$lambda-4(BaseVideoController this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.hide();
    }

    private static final void onWindowFocusChanged$lambda-5(BaseVideoController this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            OrientationHelper orientationHelper = this$0.mOrientationHelper;
            if (orientationHelper == null) break block0;
            orientationHelper.enable();
        }
    }

    public static final /* synthetic */ int access$setProgress(BaseVideoController $this) {
        return $this.setProgress();
    }

    public static final /* synthetic */ void access$setMIsStartProgress$p(BaseVideoController $this, boolean bl) {
        $this.mIsStartProgress = bl;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/talpa/tplayer_core/controller/BaseVideoController$Companion;", "", "()V", "DEFAULT_DELAY", "", "DEFAULT_DURATION", "DEFAULT_TIMEOUT", "", "com.talpa.tplayer_core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

