/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.tplayer_core.ui;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.talpa.tplayer_core.R;
import com.talpa.tplayer_core.config.VideoViewConfig;
import com.talpa.tplayer_core.controller.BaseVideoController;
import com.talpa.tplayer_core.controller.inter.MediaPlayerControl;
import com.talpa.tplayer_core.render.IRenderView;
import com.talpa.tplayer_core.render.RenderViewFactory;
import com.talpa.tplayer_core.tplayer.AbstractPlayer;
import com.talpa.tplayer_core.tplayer.AudioFocusHelper;
import com.talpa.tplayer_core.tplayer.PlayerFactory;
import com.talpa.tplayer_core.tplayer.ProgressManager;
import com.talpa.tplayer_core.tplayer.VideoViewManager;
import com.talpa.tplayer_core.util.ExtensionKt;
import com.talpa.tplayer_core.util.L;
import com.talpa.tplayer_core.util.PlayerUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\bJ\b\u0016\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0004\u00a6\u0001\u00a7\u0001B%\b\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u00105\u001a\u000206H\u0014J\u0010\u00107\u001a\u0002062\b\u00108\u001a\u0004\u0018\u00010$J\u0006\u00109\u001a\u000206J\n\u0010:\u001a\u0004\u0018\u00010;H\u0016J\n\u0010<\u001a\u0004\u0018\u00010=H\u0004J\b\u0010>\u001a\u00020\u000bH\u0016J\n\u0010?\u001a\u0004\u0018\u00010@H\u0004J\b\u0010A\u001a\u00020\u0014H\u0016J\n\u0010B\u001a\u0004\u0018\u00010@H\u0004J\b\u0010C\u001a\u00020\u0014H\u0016J\b\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020\u0014H\u0016J\b\u0010G\u001a\u000200H\u0016J\u0012\u0010H\u001a\u0002062\b\u0010I\u001a\u0004\u0018\u00010@H\u0002J\b\u0010J\u001a\u000206H\u0014J\b\u0010K\u001a\u000206H\u0014J\b\u0010L\u001a\u00020\u0017H\u0016J\b\u0010M\u001a\u00020\u0017H\u0014J\b\u0010N\u001a\u00020\u0017H\u0014J\b\u0010O\u001a\u00020\u0017H\u0002J\b\u0010P\u001a\u00020\u0017H\u0014J\b\u0010Q\u001a\u00020\u0017H\u0016J\b\u0010R\u001a\u00020\u0017H\u0016J\b\u0010S\u001a\u00020\u0017H\u0016J\u0006\u0010T\u001a\u00020\u0017J\b\u0010U\u001a\u000206H\u0016J\u001c\u0010V\u001a\u0002062\b\b\u0001\u0010W\u001a\u00020\u000b2\b\u0010X\u001a\u0004\u0018\u00010\u001aH\u0016J\u0018\u0010Y\u001a\u0002062\u0006\u0010Z\u001a\u00020\u000b2\u0006\u0010[\u001a\u00020\u000bH\u0016J\b\u0010\\\u001a\u000206H\u0016J\n\u0010]\u001a\u0004\u0018\u00010^H\u0014J\u0018\u0010_\u001a\u0002062\u0006\u0010`\u001a\u00020\u000b2\u0006\u0010a\u001a\u00020\u000bH\u0016J\u0010\u0010b\u001a\u0002062\u0006\u0010c\u001a\u00020\u0017H\u0016J\b\u0010d\u001a\u000206H\u0016J\b\u0010e\u001a\u00020\u0017H\u0014J\b\u0010f\u001a\u000206H\u0016J\u0010\u0010g\u001a\u0002062\b\u00108\u001a\u0004\u0018\u00010$J\u0010\u0010h\u001a\u0002062\u0006\u0010i\u001a\u00020\u0017H\u0016J\b\u0010j\u001a\u000206H\u0016J\b\u0010k\u001a\u000206H\u0014J\u0010\u0010l\u001a\u0002062\u0006\u0010m\u001a\u00020\u0014H\u0016J\u0012\u0010n\u001a\u0002062\b\u0010o\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010p\u001a\u0002062\u0006\u0010q\u001a\u00020\u0017H\u0016J\u000e\u0010r\u001a\u0002062\u0006\u0010s\u001a\u00020\u0017J\b\u0010t\u001a\u000206H\u0014J\u000e\u0010u\u001a\u0002062\u0006\u0010v\u001a\u00020\u0017J\u0010\u0010w\u001a\u0002062\u0006\u0010x\u001a\u00020\u0017H\u0016J\u0010\u0010y\u001a\u0002062\u0006\u0010Q\u001a\u00020\u0017H\u0016J\u0010\u0010z\u001a\u0002062\b\u00108\u001a\u0004\u0018\u00010$J\b\u0010{\u001a\u000206H\u0014J\u0012\u0010|\u001a\u0002062\b\b\u0001\u0010}\u001a\u00020\u000bH\u0014J\u000e\u0010~\u001a\u0002062\u0006\u0010\u007f\u001a\u00020\u000bJ\u001a\u0010\u0080\u0001\u001a\u0002062\u0011\u0010\u0081\u0001\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010(J\u0014\u0010\u0082\u0001\u001a\u0002062\t\b\u0001\u0010\u0083\u0001\u001a\u00020\u000bH\u0014J\u0012\u0010\u0084\u0001\u001a\u0002062\t\u0010\u0085\u0001\u001a\u0004\u0018\u00010*J\u0012\u0010\u0086\u0001\u001a\u0002062\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010.J\u0012\u0010\u0088\u0001\u001a\u0002062\u0007\u0010\u0089\u0001\u001a\u00020EH\u0016J\u0012\u0010\u008a\u0001\u001a\u0002062\u0007\u0010\u008b\u0001\u001a\u00020\u000bH\u0016J\u0012\u0010\u008c\u0001\u001a\u0002062\u0007\u0010\u008d\u0001\u001a\u00020EH\u0016J\u0010\u0010\u008e\u0001\u001a\u0002062\u0007\u0010\u008f\u0001\u001a\u000200J\u0014\u0010\u0090\u0001\u001a\u0002062\t\u0010\u0091\u0001\u001a\u0004\u0018\u00010\u001aH\u0016J+\u0010\u0090\u0001\u001a\u0002062\t\u0010\u0091\u0001\u001a\u0004\u0018\u00010\u001a2\u0015\u0010\u0092\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019H\u0016J\u0012\u0010\u0093\u0001\u001a\u0002062\t\u0010\u0094\u0001\u001a\u0004\u0018\u000103J\u0019\u0010\u0095\u0001\u001a\u0002062\u0007\u0010\u0096\u0001\u001a\u00020E2\u0007\u0010\u0097\u0001\u001a\u00020EJ\t\u0010\u0098\u0001\u001a\u00020\u0017H\u0014J\u0013\u0010\u0099\u0001\u001a\u0002062\b\u0010I\u001a\u0004\u0018\u00010@H\u0002J\u0010\u0010\u009a\u0001\u001a\u0002062\u0007\u0010\u009b\u0001\u001a\u00020\u000bJ\t\u0010\u009c\u0001\u001a\u000206H\u0016J\t\u0010\u009d\u0001\u001a\u000206H\u0016J\t\u0010\u009e\u0001\u001a\u000206H\u0014J\t\u0010\u009f\u0001\u001a\u00020\u0017H\u0014J\u0012\u0010\u00a0\u0001\u001a\u0002062\u0007\u0010\u00a1\u0001\u001a\u00020\u0017H\u0014J\t\u0010\u00a2\u0001\u001a\u000206H\u0016J\t\u0010\u00a3\u0001\u001a\u000206H\u0016J\t\u0010\u00a4\u0001\u001a\u000206H\u0016J\t\u0010\u00a5\u0001\u001a\u000206H\u0016R\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00108\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u000b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u000b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00020\u00148\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\u000b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\u00178\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00198\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00020\u00178\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00020\u00178\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u00020\u00178\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001f\u001a\u00020\u00178\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\u0004\u0018\u00018\u00008\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0004\n\u0002\u0010!R\u001a\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u0004\u0018\u00010\u00038\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010'\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010(8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u0004\u0018\u00010*8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u0004\u0018\u00010,8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u0004\u0018\u00010.8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010/\u001a\u0002008\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\u0004\u0018\u00010\u001a8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\u0004\u0018\u0001038\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00104\u001a\u0002008\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a8\u0001"}, d2={"Lcom/talpa/tplayer_core/ui/BaseVideoView;", "P", "Lcom/talpa/tplayer_core/tplayer/AbstractPlayer;", "Landroid/widget/FrameLayout;", "Lcom/talpa/tplayer_core/controller/inter/MediaPlayerControl;", "Lcom/talpa/tplayer_core/tplayer/AbstractPlayer$PlayerEventListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mAssetFileDescriptor", "Landroid/content/res/AssetFileDescriptor;", "mAudioFocusHelper", "Lcom/talpa/tplayer_core/tplayer/AudioFocusHelper;", "mCurrentPlayState", "mCurrentPlayerState", "mCurrentPosition", "", "mCurrentScreenScaleType", "mEnableAudioFocus", "", "mHeaders", "", "", "mIsCacheEnabled", "mIsFullScreen", "mIsLooping", "mIsMute", "mIsTinyScreen", "mMediaPlayer", "Lcom/talpa/tplayer_core/tplayer/AbstractPlayer;", "mOnStateChangeListeners", "", "Lcom/talpa/tplayer_core/ui/BaseVideoView$OnStateChangeListener;", "mPlayerBackgroundColor", "mPlayerContainer", "mPlayerFactory", "Lcom/talpa/tplayer_core/tplayer/PlayerFactory;", "mProgressManager", "Lcom/talpa/tplayer_core/tplayer/ProgressManager;", "mRenderView", "Lcom/talpa/tplayer_core/render/IRenderView;", "mRenderViewFactory", "Lcom/talpa/tplayer_core/render/RenderViewFactory;", "mTinyScreenSize", "", "mUrl", "mVideoController", "Lcom/talpa/tplayer_core/controller/BaseVideoController;", "mVideoSize", "addDisplay", "", "addOnStateChangeListener", "listener", "clearOnStateChangeListeners", "doScreenShot", "Landroid/graphics/Bitmap;", "getActivity", "Landroid/app/Activity;", "getBufferedPercentage", "getContentView", "Landroid/view/ViewGroup;", "getCurrentPosition", "getDecorView", "getDuration", "getSpeed", "", "getTcpSpeed", "getVideoSize", "hideSysBar", "decorView", "initPlayer", "initView", "isFullScreen", "isInIdleState", "isInPlaybackState", "isInStartAbortState", "isLocalDataSource", "isMute", "isPlaying", "isTinyScreen", "onBackPressed", "onCompletion", "onError", "type", "error", "onInfo", "what", "extra", "onPrepared", "onSaveInstanceState", "Landroid/os/Parcelable;", "onVideoSizeChanged", "videoWidth", "videoHeight", "onWindowFocusChanged", "hasWindowFocus", "pause", "prepareDataSource", "release", "removeOnStateChangeListener", "replay", "resetPosition", "resume", "saveProgress", "seekTo", "pos", "setAssetFileDescriptor", "fd", "setCacheEnabled", "isEnabled", "setEnableAudioFocus", "enableAudioFocus", "setInitOptions", "setLooping", "looping", "setMirrorRotation", "enable", "setMute", "setOnStateChangeListener", "setOptions", "setPlayState", "playState", "setPlayerBackgroundColor", "color", "setPlayerFactory", "playerFactory", "setPlayerState", "playerState", "setProgressManager", "progressManager", "setRenderViewFactory", "renderViewFactory", "setRotation", "rotation", "setScreenScaleType", "screenScaleType", "setSpeed", "speed", "setTinyScreenSize", "tinyScreenSize", "setUrl", "url", "headers", "setVideoController", "mediaController", "setVolume", "v1", "v2", "showNetWarning", "showSysBar", "skipPositionWhenPlay", "position", "start", "startFullScreen", "startInPlaybackState", "startPlay", "startPrepare", "reset", "startTinyScreen", "stop", "stopFullScreen", "stopTinyScreen", "OnStateChangeListener", "SimpleOnStateChangeListener", "com.talpa.tplayer_core"})
public class BaseVideoView<P extends AbstractPlayer>
extends FrameLayout
implements MediaPlayerControl,
AbstractPlayer.PlayerEventListener {
    @JvmField
    @Nullable
    protected P mMediaPlayer;
    @JvmField
    @Nullable
    protected PlayerFactory<P> mPlayerFactory;
    @JvmField
    @Nullable
    protected BaseVideoController mVideoController;
    @JvmField
    @Nullable
    protected FrameLayout mPlayerContainer;
    @JvmField
    @Nullable
    protected IRenderView mRenderView;
    @JvmField
    @Nullable
    protected RenderViewFactory mRenderViewFactory;
    @JvmField
    protected int mCurrentScreenScaleType;
    @JvmField
    @NotNull
    protected int[] mVideoSize;
    @JvmField
    protected boolean mIsMute;
    @JvmField
    @Nullable
    protected String mUrl;
    @JvmField
    @Nullable
    protected Map<String, String> mHeaders;
    @JvmField
    @Nullable
    protected AssetFileDescriptor mAssetFileDescriptor;
    @JvmField
    protected long mCurrentPosition;
    @JvmField
    protected int mCurrentPlayState;
    @JvmField
    protected int mCurrentPlayerState;
    @JvmField
    protected boolean mIsFullScreen;
    @JvmField
    protected boolean mIsTinyScreen;
    @JvmField
    @NotNull
    protected int[] mTinyScreenSize;
    @JvmField
    protected boolean mEnableAudioFocus;
    @JvmField
    @Nullable
    protected AudioFocusHelper mAudioFocusHelper;
    @JvmField
    @Nullable
    protected List<OnStateChangeListener> mOnStateChangeListeners;
    @JvmField
    @Nullable
    protected ProgressManager mProgressManager;
    @JvmField
    protected boolean mIsLooping;
    private int mPlayerBackgroundColor;
    private boolean mIsCacheEnabled;

    @JvmOverloads
    public BaseVideoView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        VideoViewConfig config;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        int[] nArray = new int[]{0, 0};
        this.mVideoSize = nArray;
        this.mCurrentPlayerState = 10;
        nArray = new int[]{0, 0};
        this.mTinyScreenSize = nArray;
        VideoViewConfig videoViewConfig = config = VideoViewManager.Companion.getConfig();
        if (videoViewConfig != null) {
            VideoViewConfig it = videoViewConfig;
            boolean bl = false;
            this.mEnableAudioFocus = it.mEnableAudioFocus;
            this.mProgressManager = it.mProgressManager;
            this.mPlayerFactory = it.mPlayerFactory;
            this.mCurrentScreenScaleType = it.mScreenScaleType;
            this.mRenderViewFactory = it.mRenderViewFactory;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BaseVideoView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026.styleable.BaseVideoView)");
        TypedArray a = typedArray;
        this.mEnableAudioFocus = a.getBoolean(R.styleable.BaseVideoView_enableAudioFocus, this.mEnableAudioFocus);
        this.mIsLooping = a.getBoolean(R.styleable.BaseVideoView_looping, false);
        this.mCurrentScreenScaleType = a.getInt(R.styleable.BaseVideoView_screenScaleType, this.mCurrentScreenScaleType);
        this.mPlayerBackgroundColor = a.getColor(R.styleable.BaseVideoView_playerBackgroundColor, -16777216);
        a.recycle();
        this.initView();
    }

    public /* synthetic */ BaseVideoView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    protected void initView() {
        FrameLayout frameLayout = this.mPlayerContainer = new FrameLayout(this.getContext());
        if (frameLayout != null) {
            frameLayout.setBackgroundColor(this.mPlayerBackgroundColor);
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.addView((View)this.mPlayerContainer, (ViewGroup.LayoutParams)params);
    }

    public final void setPlayerBackgroundColor(int color) {
        block0: {
            this.mPlayerBackgroundColor = color;
            FrameLayout frameLayout = this.mPlayerContainer;
            if (frameLayout == null) break block0;
            frameLayout.setBackgroundColor(color);
        }
    }

    @Override
    public void start() {
        if (this.isInIdleState() || this.isInStartAbortState()) {
            this.startPlay();
        } else if (this.isInPlaybackState()) {
            this.startInPlaybackState();
        }
    }

    protected boolean startPlay() {
        if (this.showNetWarning()) {
            this.setPlayState(8);
            return false;
        }
        if (this.mEnableAudioFocus) {
            this.mAudioFocusHelper = new AudioFocusHelper(this);
        }
        ProgressManager progressManager = this.mProgressManager;
        if (progressManager != null) {
            ProgressManager it = progressManager;
            boolean bl = false;
            this.mCurrentPosition = it.getSavedProgress(this.mUrl);
        }
        this.initPlayer();
        this.addDisplay();
        this.startPrepare(false);
        return true;
    }

    protected boolean showNetWarning() {
        boolean bl;
        if (this.isLocalDataSource()) {
            bl = false;
        } else {
            BaseVideoController baseVideoController = this.mVideoController;
            bl = ExtensionKt.toDefaultValue$default(baseVideoController != null ? Boolean.valueOf(baseVideoController.showNetWarning()) : null, false, 1, null);
        }
        return bl;
    }

    protected boolean isLocalDataSource() {
        if (this.mAssetFileDescriptor != null) {
            return true;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mUrl)) {
            Uri uri = Uri.parse((String)this.mUrl);
            return Intrinsics.areEqual((Object)"android.resource", (Object)uri.getScheme()) || Intrinsics.areEqual((Object)"file", (Object)uri.getScheme()) || Intrinsics.areEqual((Object)"rawresource", (Object)uri.getScheme());
        }
        return false;
    }

    protected void initPlayer() {
        Object v2;
        if (this.getContext() != null) {
            PlayerFactory<P> playerFactory = this.mPlayerFactory;
            if (playerFactory != null) {
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                v2 = playerFactory.createPlayer(context);
            } else {
                v2 = null;
            }
        } else {
            v2 = null;
        }
        P p = this.mMediaPlayer = v2;
        if (p != null) {
            ((AbstractPlayer)p).setPlayerEventListener(this);
        }
        this.setInitOptions();
        P p2 = this.mMediaPlayer;
        if (p2 != null) {
            ((AbstractPlayer)p2).initPlayer();
        }
        this.setOptions();
    }

    protected void setInitOptions() {
    }

    protected void setOptions() {
        block1: {
            P p = this.mMediaPlayer;
            if (p != null) {
                ((AbstractPlayer)p).setLooping(this.mIsLooping);
            }
            float volume = this.mIsMute ? 0.0f : 1.0f;
            P p2 = this.mMediaPlayer;
            if (p2 == null) break block1;
            ((AbstractPlayer)p2).setVolume(volume, volume);
        }
    }

    protected void addDisplay() {
        block4: {
            if (this.mRenderView != null) {
                FrameLayout frameLayout = this.mPlayerContainer;
                if (frameLayout != null) {
                    IRenderView iRenderView = this.mRenderView;
                    frameLayout.removeView((View)(iRenderView != null ? iRenderView.getView() : null));
                }
                IRenderView iRenderView = this.mRenderView;
                if (iRenderView != null) {
                    iRenderView.release();
                }
            }
            RenderViewFactory renderViewFactory = this.mRenderViewFactory;
            IRenderView iRenderView = this.mRenderView = renderViewFactory != null ? renderViewFactory.createRenderView(this.getContext()) : null;
            if (iRenderView != null) {
                iRenderView.attachToPlayer((AbstractPlayer)this.mMediaPlayer);
            }
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1, 17);
            FrameLayout frameLayout = this.mPlayerContainer;
            if (frameLayout == null) break block4;
            IRenderView iRenderView2 = this.mRenderView;
            frameLayout.addView((View)(iRenderView2 != null ? iRenderView2.getView() : null), 0, (ViewGroup.LayoutParams)params);
        }
    }

    protected void startPrepare(boolean reset) {
        if (reset) {
            P p = this.mMediaPlayer;
            if (p != null) {
                ((AbstractPlayer)p).reset();
            }
            this.setOptions();
        }
        if (this.prepareDataSource()) {
            P p = this.mMediaPlayer;
            if (p != null) {
                ((AbstractPlayer)p).prepareAsync();
            }
            this.setPlayState(1);
            this.setPlayerState(this.isFullScreen() ? 11 : (this.isTinyScreen() ? 12 : 10));
        }
    }

    protected boolean prepareDataSource() {
        if (this.mAssetFileDescriptor != null) {
            P p = this.mMediaPlayer;
            if (p != null) {
                ((AbstractPlayer)p).setDataSource(this.mAssetFileDescriptor);
            }
            return true;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mUrl)) {
            P p = this.mMediaPlayer;
            if (p != null) {
                ((AbstractPlayer)p).setDataSource(this.mUrl, this.mHeaders, this.mIsCacheEnabled);
            }
            return true;
        }
        return false;
    }

    protected void startInPlaybackState() {
        P p = this.mMediaPlayer;
        if (p != null) {
            ((AbstractPlayer)p).start();
        }
        this.setPlayState(3);
        if (this.mAudioFocusHelper != null && !this.isMute()) {
            AudioFocusHelper audioFocusHelper = this.mAudioFocusHelper;
            if (audioFocusHelper != null) {
                audioFocusHelper.requestFocus();
            }
        }
        FrameLayout frameLayout = this.mPlayerContainer;
        if (frameLayout != null) {
            frameLayout.setKeepScreenOn(true);
        }
    }

    @Override
    public void pause() {
        if (this.isInPlaybackState()) {
            P p = this.mMediaPlayer;
            if (ExtensionKt.toDefaultValue$default(p != null ? Boolean.valueOf(((AbstractPlayer)p).isPlaying()) : null, false, 1, null)) {
                P p2 = this.mMediaPlayer;
                if (p2 != null) {
                    ((AbstractPlayer)p2).pause();
                }
                this.setPlayState(4);
                if (this.mAudioFocusHelper != null && !this.isMute()) {
                    AudioFocusHelper audioFocusHelper = this.mAudioFocusHelper;
                    if (audioFocusHelper != null) {
                        audioFocusHelper.abandonFocus();
                    }
                }
                FrameLayout frameLayout = this.mPlayerContainer;
                if (frameLayout != null) {
                    frameLayout.setKeepScreenOn(false);
                }
            }
        }
    }

    @Override
    public void stop() {
        if (this.isInPlaybackState()) {
            P p = this.mMediaPlayer;
            if (p != null) {
                ((AbstractPlayer)p).stop();
            }
            this.setPlayState(0);
            if (this.mAudioFocusHelper != null && !this.isMute()) {
                AudioFocusHelper audioFocusHelper = this.mAudioFocusHelper;
                if (audioFocusHelper != null) {
                    audioFocusHelper.abandonFocus();
                }
            }
            FrameLayout frameLayout = this.mPlayerContainer;
            if (frameLayout != null) {
                frameLayout.setKeepScreenOn(false);
            }
        }
    }

    public void resume() {
        if (this.isInPlaybackState()) {
            P p = this.mMediaPlayer;
            if (!ExtensionKt.toDefaultValue$default(p != null ? Boolean.valueOf(((AbstractPlayer)p).isPlaying()) : null, false, 1, null)) {
                P p2 = this.mMediaPlayer;
                if (p2 != null) {
                    ((AbstractPlayer)p2).start();
                }
                this.setPlayState(3);
                if (this.mAudioFocusHelper != null && !this.isMute()) {
                    AudioFocusHelper audioFocusHelper = this.mAudioFocusHelper;
                    if (audioFocusHelper != null) {
                        audioFocusHelper.requestFocus();
                    }
                }
                FrameLayout frameLayout = this.mPlayerContainer;
                if (frameLayout != null) {
                    frameLayout.setKeepScreenOn(true);
                }
            }
        }
    }

    public void release() {
        if (this.mMediaPlayer != null) {
            P p = this.mMediaPlayer;
            if (p != null) {
                ((AbstractPlayer)p).release();
            }
            this.mMediaPlayer = null;
        }
        if (this.mRenderView != null) {
            FrameLayout frameLayout = this.mPlayerContainer;
            if (frameLayout != null) {
                IRenderView iRenderView = this.mRenderView;
                frameLayout.removeView((View)(iRenderView != null ? iRenderView.getView() : null));
            }
            IRenderView iRenderView = this.mRenderView;
            if (iRenderView != null) {
                iRenderView.release();
            }
            this.mRenderView = null;
        }
        if (this.mAssetFileDescriptor != null) {
            try {
                AssetFileDescriptor assetFileDescriptor = this.mAssetFileDescriptor;
                if (assetFileDescriptor != null) {
                    assetFileDescriptor.close();
                }
            }
            catch (IOException e) {
                L.i("BaseVideoView e = " + e);
            }
        }
        if (this.mAudioFocusHelper != null) {
            AudioFocusHelper audioFocusHelper = this.mAudioFocusHelper;
            if (audioFocusHelper != null) {
                audioFocusHelper.abandonFocus();
            }
            this.mAudioFocusHelper = null;
        }
        FrameLayout frameLayout = this.mPlayerContainer;
        if (frameLayout != null) {
            frameLayout.setKeepScreenOn(false);
        }
        if (!this.isInIdleState()) {
            this.saveProgress();
            this.mCurrentPosition = 0L;
            this.setPlayState(0);
        }
    }

    protected void saveProgress() {
        block1: {
            if (this.mProgressManager == null || this.mCurrentPosition <= 0L) break block1;
            L.d("saveProgress: " + this.mCurrentPosition);
            ProgressManager progressManager = this.mProgressManager;
            if (progressManager != null) {
                progressManager.saveProgress(this.mUrl, this.mCurrentPosition);
            }
        }
    }

    protected boolean isInPlaybackState() {
        return this.mMediaPlayer != null && this.mCurrentPlayState != -1 && this.mCurrentPlayState != 0 && this.mCurrentPlayState != 1 && this.mCurrentPlayState != 8 && this.mCurrentPlayState != 5;
    }

    protected boolean isInIdleState() {
        return this.mCurrentPlayState == 0;
    }

    private final boolean isInStartAbortState() {
        return this.mCurrentPlayState == 8;
    }

    @Override
    public void replay(boolean resetPosition) {
        if (resetPosition) {
            this.mCurrentPosition = 0L;
        }
        this.addDisplay();
        this.startPrepare(true);
    }

    @Override
    public long getDuration() {
        long l;
        if (this.isInPlaybackState()) {
            P p = this.mMediaPlayer;
            l = ExtensionKt.toDefaultValue$default(p != null ? Long.valueOf(((AbstractPlayer)p).getDuration()) : null, 0L, 1, null);
        } else {
            l = 0L;
        }
        return l;
    }

    @Override
    public long getCurrentPosition() {
        if (this.isInPlaybackState()) {
            P p = this.mMediaPlayer;
            this.mCurrentPosition = ExtensionKt.toDefaultValue$default(p != null ? Long.valueOf(((AbstractPlayer)p).getCurrentPosition()) : null, 0L, 1, null);
            return this.mCurrentPosition;
        }
        return 0L;
    }

    @Override
    public void seekTo(long pos) {
        block1: {
            if (!this.isInPlaybackState()) break block1;
            P p = this.mMediaPlayer;
            if (p != null) {
                ((AbstractPlayer)p).seekTo(pos);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isPlaying() {
        if (!this.isInPlaybackState()) return false;
        P p = this.mMediaPlayer;
        if (!ExtensionKt.toDefaultValue$default(p != null ? Boolean.valueOf(((AbstractPlayer)p).isPlaying()) : null, false, 1, null)) return false;
        return true;
    }

    @Override
    public int getBufferedPercentage() {
        P p = this.mMediaPlayer;
        return ExtensionKt.toDefaultValue$default(p != null ? Integer.valueOf(((AbstractPlayer)p).getBufferedPercentage()) : null, 0, 1, null);
    }

    @Override
    public void setMute(boolean isMute) {
        block1: {
            this.mIsMute = isMute;
            if (this.mMediaPlayer == null) break block1;
            float volume = isMute ? 0.0f : 1.0f;
            P p = this.mMediaPlayer;
            if (p != null) {
                ((AbstractPlayer)p).setVolume(volume, volume);
            }
        }
    }

    @Override
    public boolean isMute() {
        return this.mIsMute;
    }

    @Override
    public void onPrepared() {
        this.setPlayState(2);
        if (!this.isMute() && this.mAudioFocusHelper != null) {
            AudioFocusHelper audioFocusHelper = this.mAudioFocusHelper;
            if (audioFocusHelper != null) {
                audioFocusHelper.requestFocus();
            }
        }
        if (this.mCurrentPosition > 0L) {
            this.seekTo(this.mCurrentPosition);
        }
    }

    @Override
    public void onInfo(int what, int extra) {
        switch (what) {
            case 701: {
                this.setPlayState(6);
                break;
            }
            case 702: {
                this.setPlayState(7);
                break;
            }
            case 703: {
                this.setPlayState(9);
                break;
            }
            case 3: {
                this.setPlayState(3);
                FrameLayout frameLayout = this.mPlayerContainer;
                if (frameLayout == null) break;
                frameLayout.setKeepScreenOn(true);
                break;
            }
            case 10001: {
                IRenderView iRenderView = this.mRenderView;
                if (iRenderView == null) break;
                iRenderView.setVideoRotation(extra);
                break;
            }
        }
    }

    @Override
    public void onError(int type, @Nullable String error) {
        FrameLayout frameLayout = this.mPlayerContainer;
        if (frameLayout != null) {
            frameLayout.setKeepScreenOn(false);
        }
        if (PlayerUtils.isConnected(this.getContext())) {
            switch (type) {
                case 3: {
                    this.setPlayState(-1);
                    break;
                }
                case 2: {
                    this.setPlayState(-3);
                    break;
                }
                case 1: {
                    this.setPlayState(-1);
                    break;
                }
                default: {
                    this.setPlayState(-1);
                    break;
                }
            }
        } else {
            this.setPlayState(-2);
        }
    }

    @Override
    public void onCompletion() {
        FrameLayout frameLayout = this.mPlayerContainer;
        if (frameLayout != null) {
            frameLayout.setKeepScreenOn(false);
        }
        this.mCurrentPosition = 0L;
        ProgressManager progressManager = this.mProgressManager;
        if (progressManager != null) {
            progressManager.saveProgress(this.mUrl, 0L);
        }
        this.setPlayState(5);
    }

    @Override
    public long getTcpSpeed() {
        P p = this.mMediaPlayer;
        return ExtensionKt.toDefaultValue$default(p != null ? Long.valueOf(((AbstractPlayer)p).getTcpSpeed()) : null, 0L, 1, null);
    }

    @Override
    public void setSpeed(float speed) {
        block1: {
            if (!this.isInPlaybackState()) break block1;
            P p = this.mMediaPlayer;
            if (p != null) {
                ((AbstractPlayer)p).setSpeed(speed);
            }
        }
    }

    @Override
    public float getSpeed() {
        float f;
        if (this.isInPlaybackState()) {
            P p = this.mMediaPlayer;
            f = ExtensionKt.toDefaultValue$default(p != null ? Float.valueOf(((AbstractPlayer)p).getSpeed()) : null, 0.0f, 1, null);
        } else {
            f = 1.0f;
        }
        return f;
    }

    public void setUrl(@Nullable String url) {
        this.setUrl(url, null);
    }

    public void setUrl(@Nullable String url, @Nullable Map<String, String> headers) {
        this.mAssetFileDescriptor = null;
        this.mUrl = url;
        this.mHeaders = headers;
    }

    public void setAssetFileDescriptor(@Nullable AssetFileDescriptor fd) {
        this.mUrl = null;
        this.mAssetFileDescriptor = fd;
    }

    public final void skipPositionWhenPlay(int position) {
        this.mCurrentPosition = position;
    }

    public final void setVolume(float v1, float v2) {
        block0: {
            P p = this.mMediaPlayer;
            if (p == null) break block0;
            ((AbstractPlayer)p).setVolume(v1, v2);
        }
    }

    public final void setProgressManager(@Nullable ProgressManager progressManager) {
        this.mProgressManager = progressManager;
    }

    public final void setLooping(boolean looping) {
        block0: {
            this.mIsLooping = looping;
            P p = this.mMediaPlayer;
            if (p == null) break block0;
            ((AbstractPlayer)p).setLooping(looping);
        }
    }

    public final void setEnableAudioFocus(boolean enableAudioFocus) {
        this.mEnableAudioFocus = enableAudioFocus;
    }

    public final void setPlayerFactory(@Nullable PlayerFactory<P> playerFactory) {
        if (playerFactory == null) {
            boolean bl = false;
            String string = "PlayerFactory can not be null!";
            throw new IllegalArgumentException(string.toString());
        }
        this.mPlayerFactory = playerFactory;
    }

    public final void setRenderViewFactory(@Nullable RenderViewFactory renderViewFactory) {
        if (renderViewFactory == null) {
            boolean bl = false;
            String string = "RenderViewFactory can not be null!";
            throw new IllegalArgumentException(string.toString());
        }
        this.mRenderViewFactory = renderViewFactory;
    }

    @Override
    public void startFullScreen() {
        if (this.mIsFullScreen) {
            return;
        }
        ViewGroup viewGroup = this.getDecorView();
        if (viewGroup == null) {
            return;
        }
        ViewGroup decorView = viewGroup;
        this.mIsFullScreen = true;
        this.hideSysBar(decorView);
        FrameLayout frameLayout = this.mPlayerContainer;
        if (frameLayout != null) {
            frameLayout.setBackgroundColor(-16777216);
        }
        this.removeView((View)this.mPlayerContainer);
        decorView.addView((View)this.mPlayerContainer);
        this.setPlayerState(11);
    }

    private final void hideSysBar(ViewGroup decorView) {
        block2: {
            ViewGroup viewGroup = decorView;
            if (viewGroup == null) break block2;
            ViewGroup it = viewGroup;
            boolean bl = false;
            int uiOptions = it.getSystemUiVisibility();
            uiOptions |= 2;
            if (Build.VERSION.SDK_INT >= 19) {
                uiOptions |= 0x1000;
            }
            it.setSystemUiVisibility(uiOptions);
            Activity activity = this.getActivity();
            if (activity != null && (activity = activity.getWindow()) != null) {
                activity.setFlags(1024, 1024);
            }
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus && this.mIsFullScreen) {
            this.hideSysBar(this.getDecorView());
        }
    }

    @Override
    public void stopFullScreen() {
        if (!this.mIsFullScreen) {
            return;
        }
        ViewGroup viewGroup = this.getDecorView();
        if (viewGroup == null) {
            return;
        }
        ViewGroup decorView = viewGroup;
        this.mIsFullScreen = false;
        this.showSysBar(decorView);
        FrameLayout frameLayout = this.mPlayerContainer;
        if (frameLayout != null) {
            frameLayout.setBackgroundColor(this.mPlayerBackgroundColor);
        }
        decorView.removeView((View)this.mPlayerContainer);
        this.addView((View)this.mPlayerContainer);
        this.setPlayerState(10);
    }

    private final void showSysBar(ViewGroup decorView) {
        block2: {
            ViewGroup viewGroup = decorView;
            if (viewGroup == null) break block2;
            ViewGroup it = viewGroup;
            boolean bl = false;
            int uiOptions = it.getSystemUiVisibility();
            uiOptions &= 0xFFFFFFFD;
            if (Build.VERSION.SDK_INT >= 19) {
                uiOptions &= 0xFFFFEFFF;
            }
            it.setSystemUiVisibility(uiOptions);
            Activity activity = this.getActivity();
            if (activity != null && (activity = activity.getWindow()) != null) {
                activity.clearFlags(1024);
            }
        }
    }

    @Nullable
    protected final ViewGroup getDecorView() {
        Activity activity = this.getActivity();
        return (ViewGroup)(activity != null && (activity = activity.getWindow()) != null ? activity.getDecorView() : null);
    }

    @Nullable
    protected final ViewGroup getContentView() {
        Activity activity = this.getActivity();
        return activity != null ? (ViewGroup)activity.findViewById(0x1020002) : null;
    }

    @Nullable
    protected final Activity getActivity() {
        Activity activity = null;
        if (this.mVideoController != null) {
            BaseVideoController baseVideoController = this.mVideoController;
            activity = PlayerUtils.scanForActivity((Context)(baseVideoController != null ? baseVideoController.getContext() : null));
            if (activity == null) {
                activity = PlayerUtils.scanForActivity(this.getContext());
            }
        } else {
            activity = PlayerUtils.scanForActivity(this.getContext());
        }
        return activity;
    }

    @Override
    public boolean isFullScreen() {
        return this.mIsFullScreen;
    }

    @Override
    public void startTinyScreen() {
        int height;
        if (this.mIsTinyScreen) {
            return;
        }
        ViewGroup viewGroup = this.getContentView();
        if (viewGroup == null) {
            return;
        }
        ViewGroup contentView = viewGroup;
        this.removeView((View)this.mPlayerContainer);
        int width = this.mTinyScreenSize[0];
        if (width <= 0) {
            width = PlayerUtils.getScreenWidth(this.getContext(), false) / 2;
        }
        if ((height = this.mTinyScreenSize[1]) <= 0) {
            height = width * 9 / 16;
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(width, height);
        params.gravity = 0x800055;
        contentView.addView((View)this.mPlayerContainer, (ViewGroup.LayoutParams)params);
        this.mIsTinyScreen = true;
        this.setPlayerState(12);
    }

    @Override
    public void stopTinyScreen() {
        if (!this.mIsTinyScreen) {
            return;
        }
        ViewGroup viewGroup = this.getContentView();
        if (viewGroup == null) {
            return;
        }
        ViewGroup contentView = viewGroup;
        contentView.removeView((View)this.mPlayerContainer);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.addView((View)this.mPlayerContainer, (ViewGroup.LayoutParams)params);
        this.mIsTinyScreen = false;
        this.setPlayerState(10);
    }

    @Override
    public boolean isTinyScreen() {
        return this.mIsTinyScreen;
    }

    @Override
    public void onVideoSizeChanged(int videoWidth, int videoHeight) {
        block1: {
            this.mVideoSize[0] = videoWidth;
            this.mVideoSize[1] = videoHeight;
            IRenderView iRenderView = this.mRenderView;
            if (iRenderView != null) {
                iRenderView.setScaleType(this.mCurrentScreenScaleType);
            }
            IRenderView iRenderView2 = this.mRenderView;
            if (iRenderView2 == null) break block1;
            iRenderView2.setVideoSize(videoWidth, videoHeight);
        }
    }

    public final void setVideoController(@Nullable BaseVideoController mediaController) {
        block3: {
            BaseVideoController baseVideoController = this.mVideoController;
            ViewGroup viewGroup = (ViewGroup)(baseVideoController != null ? baseVideoController.getParent() : null);
            if (viewGroup != null) {
                viewGroup.removeAllViews();
            }
            FrameLayout frameLayout = this.mPlayerContainer;
            if (frameLayout != null) {
                frameLayout.removeView((View)this.mVideoController);
            }
            this.mVideoController = mediaController;
            if (mediaController == null) break block3;
            mediaController.setMediaPlayer(this);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            FrameLayout frameLayout2 = this.mPlayerContainer;
            if (frameLayout2 != null) {
                frameLayout2.addView((View)this.mVideoController, (ViewGroup.LayoutParams)params);
            }
        }
    }

    @Override
    public void setScreenScaleType(int screenScaleType) {
        block0: {
            this.mCurrentScreenScaleType = screenScaleType;
            IRenderView iRenderView = this.mRenderView;
            if (iRenderView == null) break block0;
            iRenderView.setScaleType(screenScaleType);
        }
    }

    @Override
    public void setMirrorRotation(boolean enable) {
        IRenderView iRenderView = this.mRenderView;
        Object object = iRenderView != null ? iRenderView.getView() : null;
        if (object != null) {
            object.setScaleX(enable ? -1.0f : 1.0f);
        }
    }

    @Override
    @Nullable
    public Bitmap doScreenShot() {
        IRenderView iRenderView = this.mRenderView;
        return iRenderView != null ? iRenderView.doScreenShot() : null;
    }

    @Override
    @NotNull
    public int[] getVideoSize() {
        return this.mVideoSize;
    }

    @Override
    public void setRotation(float rotation) {
        block0: {
            IRenderView iRenderView = this.mRenderView;
            if (iRenderView == null) break block0;
            iRenderView.setVideoRotation((int)rotation);
        }
    }

    public final void setTinyScreenSize(@NotNull int[] tinyScreenSize) {
        Intrinsics.checkNotNullParameter((Object)tinyScreenSize, (String)"tinyScreenSize");
        this.mTinyScreenSize = tinyScreenSize;
    }

    protected void setPlayState(int playState) {
        block2: {
            this.mCurrentPlayState = playState;
            BaseVideoController baseVideoController = this.mVideoController;
            if (baseVideoController != null) {
                baseVideoController.setPlayState(playState);
            }
            List<OnStateChangeListener> list = this.mOnStateChangeListeners;
            if (list == null) break block2;
            List<OnStateChangeListener> it = list;
            boolean bl = false;
            Iterable $this$forEach$iv = PlayerUtils.getSnapshot((Collection)it);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OnStateChangeListener oscl = (OnStateChangeListener)element$iv;
                boolean bl2 = false;
                oscl.onPlayStateChanged(playState);
            }
        }
    }

    protected void setPlayerState(int playerState) {
        block2: {
            this.mCurrentPlayerState = playerState;
            BaseVideoController baseVideoController = this.mVideoController;
            if (baseVideoController != null) {
                baseVideoController.setPlayerState(playerState);
            }
            List<OnStateChangeListener> list = this.mOnStateChangeListeners;
            if (list == null) break block2;
            List<OnStateChangeListener> it = list;
            boolean bl = false;
            Iterable $this$forEach$iv = PlayerUtils.getSnapshot((Collection)it);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OnStateChangeListener oscl = (OnStateChangeListener)element$iv;
                boolean bl2 = false;
                oscl.onPlayerStateChanged(playerState);
            }
        }
    }

    public final void addOnStateChangeListener(@Nullable OnStateChangeListener listener) {
        block2: {
            if (this.mOnStateChangeListeners == null) {
                this.mOnStateChangeListeners = new ArrayList();
            }
            OnStateChangeListener onStateChangeListener = listener;
            if (onStateChangeListener == null) break block2;
            OnStateChangeListener it = onStateChangeListener;
            boolean bl = false;
            List<OnStateChangeListener> list = this.mOnStateChangeListeners;
            if (list != null) {
                list.add(it);
            }
        }
    }

    public final void removeOnStateChangeListener(@Nullable OnStateChangeListener listener) {
        block0: {
            List<OnStateChangeListener> list = this.mOnStateChangeListeners;
            if (list == null) break block0;
            TypeIntrinsics.asMutableCollection((Object)list).remove(listener);
        }
    }

    public final void setOnStateChangeListener(@Nullable OnStateChangeListener listener) {
        block4: {
            if (this.mOnStateChangeListeners == null) {
                this.mOnStateChangeListeners = new ArrayList();
            } else {
                List<OnStateChangeListener> list = this.mOnStateChangeListeners;
                if (list != null) {
                    list.clear();
                }
            }
            OnStateChangeListener onStateChangeListener = listener;
            if (onStateChangeListener == null) break block4;
            OnStateChangeListener it = onStateChangeListener;
            boolean bl = false;
            List<OnStateChangeListener> list = this.mOnStateChangeListeners;
            if (list != null) {
                list.add(it);
            }
        }
    }

    public final void clearOnStateChangeListeners() {
        block0: {
            List<OnStateChangeListener> list = this.mOnStateChangeListeners;
            if (list == null) break block0;
            list.clear();
        }
    }

    public final boolean onBackPressed() {
        BaseVideoController baseVideoController = this.mVideoController;
        return ExtensionKt.toDefaultValue$default(baseVideoController != null ? Boolean.valueOf(baseVideoController.onBackPressed()) : null, false, 1, null);
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        L.d("onSaveInstanceState: " + this.mCurrentPosition);
        this.saveProgress();
        return super.onSaveInstanceState();
    }

    public void setCacheEnabled(boolean isEnabled) {
        this.mIsCacheEnabled = isEnabled;
    }

    @JvmOverloads
    public BaseVideoView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public BaseVideoView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005H&J\u0012\u0010\u0006\u001a\u00020\u00032\b\b\u0001\u0010\u0007\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Lcom/talpa/tplayer_core/ui/BaseVideoView$OnStateChangeListener;", "", "onPlayStateChanged", "", "playState", "", "onPlayerStateChanged", "playerState", "com.talpa.tplayer_core"})
    public static interface OnStateChangeListener {
        public void onPlayerStateChanged(int var1);

        public void onPlayStateChanged(int var1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\u00042\b\b\u0001\u0010\b\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/talpa/tplayer_core/ui/BaseVideoView$SimpleOnStateChangeListener;", "Lcom/talpa/tplayer_core/ui/BaseVideoView$OnStateChangeListener;", "()V", "onPlayStateChanged", "", "playState", "", "onPlayerStateChanged", "playerState", "com.talpa.tplayer_core"})
    public static class SimpleOnStateChangeListener
    implements OnStateChangeListener {
        @Override
        public void onPlayerStateChanged(int playerState) {
        }

        @Override
        public void onPlayStateChanged(int playState) {
        }
    }
}

