/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.exo;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.ProgressiveMediaSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultDataSource;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSource;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.util.Util;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000eJ(\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\nJ\u001e\u0010\u001e\u001a\u00020\u001c2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0017H\u0002R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/talpa/exo/ExoMediaSourceHelper;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mAppContext", "getMAppContext", "()Landroid/content/Context;", "setMAppContext", "mCache", "Lcom/google/android/exoplayer2/upstream/cache/Cache;", "mHttpDataSourceFactory", "Lcom/google/android/exoplayer2/upstream/HttpDataSource$Factory;", "mUserAgent", "", "getDataSourceFactory", "Lcom/google/android/exoplayer2/upstream/DefaultDataSource$Factory;", "getHttpDataSourceFactory", "Lcom/google/android/exoplayer2/upstream/DataSource$Factory;", "getMediaSource", "Lcom/google/android/exoplayer2/source/MediaSource;", "uri", "headers", "", "inferContentType", "", "fileName", "setCache", "", "cache", "setHeaders", "Companion", "exo_release"})
public final class ExoMediaSourceHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Context mAppContext;
    @Nullable
    private final String mUserAgent;
    @Nullable
    private HttpDataSource.Factory mHttpDataSourceFactory;
    @Nullable
    private Cache mCache;
    @Nullable
    private static volatile ExoMediaSourceHelper sInstance;

    private ExoMediaSourceHelper(Context context) {
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.mAppContext = context2;
        this.mUserAgent = Util.getUserAgent((Context)this.mAppContext, (String)this.mAppContext.getApplicationInfo().name);
    }

    @NotNull
    public final Context getMAppContext() {
        return this.mAppContext;
    }

    public final void setMAppContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.mAppContext = context;
    }

    @Nullable
    public final MediaSource getMediaSource(@Nullable String uri) {
        return this.getMediaSource(uri, null);
    }

    @Nullable
    public final MediaSource getMediaSource(@Nullable String uri, @Nullable Map<String, String> headers) {
        MediaSource mediaSource;
        CharSequence charSequence = uri;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        Uri contentUri = Uri.parse((String)uri);
        int contentType = this.inferContentType(uri);
        DataSource.Factory factory = (DataSource.Factory)this.getDataSourceFactory();
        if (this.mHttpDataSourceFactory != null) {
            this.setHeaders(headers);
        }
        switch (contentType) {
            case 2: {
                mediaSource = (MediaSource)new HlsMediaSource.Factory(factory).createMediaSource(MediaItem.fromUri((Uri)contentUri));
                break;
            }
            case 4: {
                mediaSource = (MediaSource)new ProgressiveMediaSource.Factory(factory).createMediaSource(MediaItem.fromUri((Uri)contentUri));
                break;
            }
            default: {
                mediaSource = (MediaSource)new ProgressiveMediaSource.Factory(factory).createMediaSource(MediaItem.fromUri((Uri)contentUri));
            }
        }
        return mediaSource;
    }

    private final int inferContentType(String fileName) {
        String fileName2;
        String string = fileName2 = fileName;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        fileName2 = string2;
        return StringsKt.contains$default((CharSequence)fileName2, (CharSequence)".m3u8", (boolean)false, (int)2, null) ? 2 : 4;
    }

    private final DefaultDataSource.Factory getDataSourceFactory() {
        return new DefaultDataSource.Factory(this.mAppContext, this.getHttpDataSourceFactory());
    }

    private final DataSource.Factory getHttpDataSourceFactory() {
        if (this.mHttpDataSourceFactory == null) {
            this.mHttpDataSourceFactory = (HttpDataSource.Factory)new DefaultHttpDataSource.Factory().setUserAgent(this.mUserAgent).setAllowCrossProtocolRedirects(true);
        }
        HttpDataSource.Factory factory = this.mHttpDataSourceFactory;
        Intrinsics.checkNotNull((Object)factory);
        return (DataSource.Factory)factory;
    }

    private final void setHeaders(Map<String, String> headers) {
        block5: {
            String value;
            Map<String, String> map = headers;
            if (map == null || map.isEmpty()) break block5;
            if (headers.containsKey("User-Agent") && !TextUtils.isEmpty((CharSequence)(value = headers.remove("User-Agent")))) {
                try {
                    Field userAgentField;
                    Object object = this.mHttpDataSourceFactory;
                    Field field = userAgentField = object != null && (object = object.getClass()) != null ? ((Class)object).getDeclaredField("userAgent") : null;
                    if (field != null) {
                        Field it = field;
                        boolean bl = false;
                        it.setAccessible(true);
                        it.set(this.mHttpDataSourceFactory, value);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            HttpDataSource.Factory factory = this.mHttpDataSourceFactory;
            if (factory != null) {
                factory.setDefaultRequestProperties(headers);
            }
        }
    }

    public final void setCache(@Nullable Cache cache) {
        this.mCache = cache;
    }

    public /* synthetic */ ExoMediaSourceHelper(Context context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/talpa/exo/ExoMediaSourceHelper$Companion;", "", "()V", "sInstance", "Lcom/talpa/exo/ExoMediaSourceHelper;", "getInstance", "context", "Landroid/content/Context;", "exo_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final ExoMediaSourceHelper getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (sInstance == null) {
                Class<ExoMediaSourceHelper> clazz = ExoMediaSourceHelper.class;
                synchronized (clazz) {
                    boolean bl = false;
                    if (sInstance == null) {
                        sInstance = new ExoMediaSourceHelper(context, null);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            return sInstance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

