/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.exo;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.DefaultRenderersFactory;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.PlaybackException;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.analytics.AnalyticsCollector;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.source.DefaultMediaSourceFactory;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceFactory;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.EventLogger;
import com.google.android.exoplayer2.video.VideoSize;
import com.talpa.exo.ExoMediaSourceHelper;
import com.talpa.tplayer_core.config.VideoViewConfig;
import com.talpa.tplayer_core.tplayer.AbstractPlayer;
import com.talpa.tplayer_core.tplayer.VideoViewManager;
import com.talpa.tplayer_core.util.ExtensionKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u000bH\u0016J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\u0019H\u0016J\u0010\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020!H\u0016J\b\u0010,\u001a\u00020!H\u0016J\b\u0010-\u001a\u00020!H\u0016J\b\u0010.\u001a\u00020!H\u0016J\u0010\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020\u001bH\u0016J\u0012\u00101\u001a\u00020!2\b\u00102\u001a\u0004\u0018\u000103H\u0016J(\u00101\u001a\u00020!2\b\u00104\u001a\u0004\u0018\u0001052\u0014\u00106\u001a\u0010\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u000205\u0018\u000107H\u0016J\u0012\u00108\u001a\u00020!2\b\u00109\u001a\u0004\u0018\u00010:H\u0016J\u0010\u0010;\u001a\u00020!2\b\u0010<\u001a\u0004\u0018\u00010\rJ\u0010\u0010=\u001a\u00020!2\u0006\u0010>\u001a\u00020\u000bH\u0016J\b\u0010?\u001a\u00020!H\u0016J\u0010\u0010@\u001a\u00020!2\b\u0010A\u001a\u0004\u0018\u00010\u0013J\u0010\u0010B\u001a\u00020!2\u0006\u0010C\u001a\u00020\u001eH\u0016J\u0012\u0010D\u001a\u00020!2\b\u0010E\u001a\u0004\u0018\u00010FH\u0016J\u0010\u0010G\u001a\u00020!2\b\u0010H\u001a\u0004\u0018\u00010\u0017J\u0018\u0010I\u001a\u00020!2\u0006\u0010J\u001a\u00020\u001e2\u0006\u0010K\u001a\u00020\u001eH\u0016J\b\u0010L\u001a\u00020!H\u0016J\b\u0010M\u001a\u00020!H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u0004\u0018\u00010\t8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00118\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/talpa/exo/ExoMediaPlayer;", "Lcom/talpa/tplayer_core/tplayer/AbstractPlayer;", "Lcom/google/android/exoplayer2/Player$Listener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "mInternalPlayer", "Lcom/google/android/exoplayer2/ExoPlayer;", "mIsPreparing", "", "mLoadControl", "Lcom/google/android/exoplayer2/LoadControl;", "mMediaSource", "Lcom/google/android/exoplayer2/source/MediaSource;", "mMediaSourceHelper", "Lcom/talpa/exo/ExoMediaSourceHelper;", "mRenderersFactory", "Lcom/google/android/exoplayer2/RenderersFactory;", "mSpeedPlaybackParameters", "Lcom/google/android/exoplayer2/PlaybackParameters;", "mTrackSelector", "Lcom/google/android/exoplayer2/trackselection/TrackSelector;", "getBufferedPercentage", "", "getCurrentPosition", "", "getDuration", "getSpeed", "", "getTcpSpeed", "initPlayer", "", "isPlaying", "onPlaybackStateChanged", "playbackState", "onPlayerError", "error", "Lcom/google/android/exoplayer2/PlaybackException;", "onVideoSizeChanged", "videoSize", "Lcom/google/android/exoplayer2/video/VideoSize;", "pause", "prepareAsync", "release", "reset", "seekTo", "time", "setDataSource", "fd", "Landroid/content/res/AssetFileDescriptor;", "path", "", "headers", "", "setDisplay", "holder", "Landroid/view/SurfaceHolder;", "setLoadControl", "loadControl", "setLooping", "isLooping", "setOptions", "setRenderersFactory", "renderersFactory", "setSpeed", "speed", "setSurface", "surface", "Landroid/view/Surface;", "setTrackSelector", "trackSelector", "setVolume", "leftVolume", "rightVolume", "start", "stop", "exo_release"})
public class ExoMediaPlayer
extends AbstractPlayer
implements Player.Listener {
    @NotNull
    private final Context context;
    @JvmField
    @Nullable
    protected ExoPlayer mInternalPlayer;
    @JvmField
    @Nullable
    protected MediaSource mMediaSource;
    @JvmField
    @Nullable
    protected ExoMediaSourceHelper mMediaSourceHelper;
    @Nullable
    private PlaybackParameters mSpeedPlaybackParameters;
    private boolean mIsPreparing;
    @Nullable
    private LoadControl mLoadControl;
    @Nullable
    private RenderersFactory mRenderersFactory;
    @Nullable
    private TrackSelector mTrackSelector;

    public ExoMediaPlayer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.mMediaSourceHelper = ExoMediaSourceHelper.Companion.getInstance(this.context);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public void initPlayer() {
        block8: {
            LoadControl loadControl;
            TrackSelector trackSelector;
            RenderersFactory renderersFactory;
            Context context = this.context.getApplicationContext();
            if (this.mRenderersFactory == null) {
                renderersFactory = (RenderersFactory)new DefaultRenderersFactory(this.context.getApplicationContext());
            } else {
                RenderersFactory renderersFactory2 = this.mRenderersFactory;
                renderersFactory = renderersFactory2;
                Intrinsics.checkNotNull((Object)renderersFactory2);
            }
            MediaSourceFactory mediaSourceFactory = (MediaSourceFactory)new DefaultMediaSourceFactory(this.context.getApplicationContext());
            if (this.mTrackSelector == null) {
                trackSelector = (TrackSelector)new DefaultTrackSelector(this.context.getApplicationContext());
            } else {
                TrackSelector trackSelector2 = this.mTrackSelector;
                trackSelector = trackSelector2;
                Intrinsics.checkNotNull((Object)trackSelector2);
            }
            if (this.mLoadControl == null) {
                loadControl = (LoadControl)new DefaultLoadControl();
            } else {
                LoadControl loadControl2 = this.mLoadControl;
                loadControl = loadControl2;
                Intrinsics.checkNotNull((Object)loadControl2);
            }
            this.mInternalPlayer = new ExoPlayer.Builder(context, renderersFactory, mediaSourceFactory, trackSelector, loadControl, (BandwidthMeter)DefaultBandwidthMeter.getSingletonInstance((Context)this.context.getApplicationContext()), new AnalyticsCollector(Clock.DEFAULT)).build();
            this.setOptions();
            VideoViewConfig videoViewConfig = VideoViewManager.Companion.getConfig();
            if (ExtensionKt.toDefaultValue$default((Boolean)(videoViewConfig != null ? Boolean.valueOf(videoViewConfig.mIsEnableLog) : null), (boolean)false, (int)1, null) && this.mTrackSelector instanceof MappingTrackSelector) {
                ExoPlayer exoPlayer = this.mInternalPlayer;
                if (exoPlayer != null) {
                    exoPlayer.addAnalyticsListener((AnalyticsListener)new EventLogger((MappingTrackSelector)this.mTrackSelector, "ExoPlayer"));
                }
            }
            ExoPlayer exoPlayer = this.mInternalPlayer;
            if (exoPlayer == null) break block8;
            exoPlayer.addListener((Player.Listener)this);
        }
    }

    public final void setTrackSelector(@Nullable TrackSelector trackSelector) {
        this.mTrackSelector = trackSelector;
    }

    public final void setRenderersFactory(@Nullable RenderersFactory renderersFactory) {
        this.mRenderersFactory = renderersFactory;
    }

    public final void setLoadControl(@Nullable LoadControl loadControl) {
        this.mLoadControl = loadControl;
    }

    public void setDataSource(@Nullable String path, @Nullable Map<String, String> headers) {
        CharSequence charSequence = path;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
            if (playerEventListener != null) {
                playerEventListener.onError(1, "Invalid video link");
            }
            return;
        }
        ExoMediaSourceHelper exoMediaSourceHelper = this.mMediaSourceHelper;
        this.mMediaSource = exoMediaSourceHelper != null ? exoMediaSourceHelper.getMediaSource(path, headers) : null;
    }

    public void setDataSource(@Nullable AssetFileDescriptor fd) {
    }

    public void start() {
        ExoPlayer exoPlayer = this.mInternalPlayer;
        if (exoPlayer != null) {
            exoPlayer.setPlayWhenReady(true);
        }
    }

    public void pause() {
        ExoPlayer exoPlayer = this.mInternalPlayer;
        if (exoPlayer != null) {
            exoPlayer.setPlayWhenReady(false);
        }
    }

    public void stop() {
        block0: {
            ExoPlayer exoPlayer = this.mInternalPlayer;
            if (exoPlayer == null) break block0;
            exoPlayer.stop();
        }
    }

    public void prepareAsync() {
        block6: {
            PlaybackParameters it;
            if (this.mInternalPlayer == null) {
                return;
            }
            if (this.mMediaSource == null) {
                return;
            }
            PlaybackParameters playbackParameters = this.mSpeedPlaybackParameters;
            if (playbackParameters != null) {
                it = playbackParameters;
                boolean bl = false;
                ExoPlayer exoPlayer = this.mInternalPlayer;
                if (exoPlayer != null) {
                    exoPlayer.setPlaybackParameters(it);
                }
            }
            this.mIsPreparing = true;
            MediaSource mediaSource = this.mMediaSource;
            if (mediaSource != null) {
                it = mediaSource;
                boolean bl = false;
                ExoPlayer exoPlayer = this.mInternalPlayer;
                if (exoPlayer != null) {
                    exoPlayer.setMediaSource((MediaSource)it);
                }
            }
            ExoPlayer exoPlayer = this.mInternalPlayer;
            if (exoPlayer == null) break block6;
            exoPlayer.prepare();
        }
    }

    public void reset() {
        if (this.mInternalPlayer != null) {
            ExoPlayer exoPlayer = this.mInternalPlayer;
            if (exoPlayer != null) {
                exoPlayer.stop();
            }
            ExoPlayer exoPlayer2 = this.mInternalPlayer;
            if (exoPlayer2 != null) {
                exoPlayer2.clearMediaItems();
            }
            ExoPlayer exoPlayer3 = this.mInternalPlayer;
            if (exoPlayer3 != null) {
                exoPlayer3.setVideoSurface(null);
            }
            this.mIsPreparing = false;
        }
    }

    public boolean isPlaying() {
        boolean bl;
        if (this.mInternalPlayer == null) {
            return false;
        }
        ExoPlayer exoPlayer = this.mInternalPlayer;
        int state = ExtensionKt.toDefaultValue$default((Integer)(exoPlayer != null ? Integer.valueOf(exoPlayer.getPlaybackState()) : null), (int)0, (int)1, null);
        switch (state) {
            case 2: 
            case 3: {
                ExoPlayer exoPlayer2 = this.mInternalPlayer;
                bl = ExtensionKt.toDefaultValue$default((Boolean)(exoPlayer2 != null ? Boolean.valueOf(exoPlayer2.getPlayWhenReady()) : null), (boolean)false, (int)1, null);
                break;
            }
            case 1: 
            case 4: {
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public void seekTo(long time) {
        block0: {
            ExoPlayer exoPlayer = this.mInternalPlayer;
            if (exoPlayer == null) break block0;
            exoPlayer.seekTo(time);
        }
    }

    public void release() {
        if (this.mInternalPlayer != null) {
            ExoPlayer exoPlayer = this.mInternalPlayer;
            if (exoPlayer != null) {
                exoPlayer.removeListener((Player.Listener)this);
            }
            ExoPlayer exoPlayer2 = this.mInternalPlayer;
            if (exoPlayer2 != null) {
                exoPlayer2.release();
            }
            this.mInternalPlayer = null;
        }
        this.mIsPreparing = false;
        this.mSpeedPlaybackParameters = null;
    }

    public long getCurrentPosition() {
        ExoPlayer exoPlayer = this.mInternalPlayer;
        return ExtensionKt.toDefaultValue$default((Long)(exoPlayer != null ? Long.valueOf(exoPlayer.getCurrentPosition()) : null), (long)0L, (int)1, null);
    }

    public long getDuration() {
        ExoPlayer exoPlayer = this.mInternalPlayer;
        return ExtensionKt.toDefaultValue$default((Long)(exoPlayer != null ? Long.valueOf(exoPlayer.getDuration()) : null), (long)0L, (int)1, null);
    }

    public int getBufferedPercentage() {
        ExoPlayer exoPlayer = this.mInternalPlayer;
        return ExtensionKt.toDefaultValue$default((Integer)(exoPlayer != null ? Integer.valueOf(exoPlayer.getBufferedPercentage()) : null), (int)0, (int)1, null);
    }

    public void setSurface(@Nullable Surface surface) {
        block0: {
            ExoPlayer exoPlayer = this.mInternalPlayer;
            if (exoPlayer == null) break block0;
            exoPlayer.setVideoSurface(surface);
        }
    }

    public void setDisplay(@Nullable SurfaceHolder holder) {
        SurfaceHolder surfaceHolder = holder;
        if (surfaceHolder == null) {
            this.setSurface(null);
        } else {
            this.setSurface(surfaceHolder.getSurface());
        }
    }

    public void setVolume(float leftVolume, float rightVolume) {
        ExoPlayer exoPlayer = this.mInternalPlayer;
        if (exoPlayer != null) {
            exoPlayer.setVolume((leftVolume + rightVolume) / (float)2);
        }
    }

    public void setLooping(boolean isLooping) {
        ExoPlayer exoPlayer = this.mInternalPlayer;
        if (exoPlayer != null) {
            exoPlayer.setRepeatMode(isLooping ? 2 : 0);
        }
    }

    public void setOptions() {
        ExoPlayer exoPlayer = this.mInternalPlayer;
        if (exoPlayer != null) {
            exoPlayer.setPlayWhenReady(true);
        }
    }

    public void setSpeed(float speed) {
        PlaybackParameters playbackParameters;
        this.mSpeedPlaybackParameters = playbackParameters = new PlaybackParameters(speed);
        ExoPlayer exoPlayer = this.mInternalPlayer;
        if (exoPlayer != null) {
            exoPlayer.setPlaybackParameters(playbackParameters);
        }
    }

    public float getSpeed() {
        PlaybackParameters playbackParameters = this.mSpeedPlaybackParameters;
        return ExtensionKt.toDefaultValue((Float)(playbackParameters != null ? Float.valueOf(playbackParameters.speed) : null), (float)1.0f);
    }

    public long getTcpSpeed() {
        return 0L;
    }

    public void onPlaybackStateChanged(int playbackState) {
        if (this.mPlayerEventListener == null) {
            return;
        }
        if (this.mIsPreparing) {
            if (playbackState == 3) {
                AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
                if (playerEventListener != null) {
                    playerEventListener.onPrepared();
                }
                AbstractPlayer.PlayerEventListener playerEventListener2 = this.mPlayerEventListener;
                if (playerEventListener2 != null) {
                    playerEventListener2.onInfo(3, 0);
                }
                this.mIsPreparing = false;
            }
            return;
        }
        switch (playbackState) {
            case 2: {
                AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
                if (playerEventListener != null) {
                    playerEventListener.onInfo(701, this.getBufferedPercentage());
                }
                break;
            }
            case 3: {
                AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
                if (playerEventListener != null) {
                    playerEventListener.onInfo(702, this.getBufferedPercentage());
                }
                break;
            }
            case 4: {
                AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
                if (playerEventListener == null) break;
                playerEventListener.onCompletion();
                break;
            }
        }
    }

    public void onPlayerError(@NotNull PlaybackException error) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
            if (playerEventListener == null) break block6;
            AbstractPlayer.PlayerEventListener it = playerEventListener;
            boolean bl = false;
            if (error instanceof ExoPlaybackException) {
                switch (((ExoPlaybackException)error).type) {
                    case 0: {
                        it.onError(1, error.getMessage());
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        it.onError(3, error.getMessage());
                        break;
                    }
                    default: {
                        it.onError(3, error.getMessage());
                        break;
                    }
                }
            } else {
                it.onError(3, error.getMessage());
            }
        }
    }

    public void onVideoSizeChanged(@NotNull VideoSize videoSize) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)videoSize, (String)"videoSize");
            AbstractPlayer.PlayerEventListener playerEventListener = this.mPlayerEventListener;
            if (playerEventListener == null) break block1;
            AbstractPlayer.PlayerEventListener it = playerEventListener;
            boolean bl = false;
            it.onVideoSizeChanged(videoSize.width, videoSize.height);
            if (videoSize.unappliedRotationDegrees > 0) {
                it.onInfo(10001, videoSize.unappliedRotationDegrees);
            }
        }
    }
}

