/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.exo;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.Util;
import androidx.media3.database.DatabaseProvider;
import androidx.media3.database.StandaloneDatabaseProvider;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.DefaultDataSource;
import androidx.media3.datasource.DefaultHttpDataSource;
import androidx.media3.datasource.HttpDataSource;
import androidx.media3.datasource.cache.Cache;
import androidx.media3.datasource.cache.CacheDataSource;
import androidx.media3.datasource.cache.CacheEvictor;
import androidx.media3.datasource.cache.CacheWriter;
import androidx.media3.datasource.cache.LeastRecentlyUsedCacheEvictor;
import androidx.media3.datasource.cache.SimpleCache;
import androidx.media3.exoplayer.hls.HlsMediaSource;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.ProgressiveMediaSource;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\fH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ2\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u001c2\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\b\u0010 \u001a\u00020\nH\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&J\u0010\u0010'\u001a\u00020\"2\b\u0010(\u001a\u0004\u0018\u00010\nJ\u001e\u0010)\u001a\u00020\"2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u001cH\u0002R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/talpa/exo/ExoMediaSourceHelper;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mAppContext", "getMAppContext", "()Landroid/content/Context;", "setMAppContext", "mCache", "Landroidx/media3/datasource/cache/Cache;", "mCacheDataSourceFactory", "Landroidx/media3/datasource/cache/CacheDataSource$Factory;", "mHttpDataSourceFactory", "Landroidx/media3/datasource/HttpDataSource$Factory;", "mUserAgent", "", "getCacheDataSourceFactory", "getDataSourceFactory", "Landroidx/media3/datasource/DefaultDataSource$Factory;", "getHttpDataSourceFactory", "Landroidx/media3/datasource/DataSource$Factory;", "getMediaSource", "Landroidx/media3/exoplayer/source/MediaSource;", "uri", "isCache", "", "headers", "", "inferContentType", "", "fileName", "newCache", "preLoad", "", "dataSpec", "Landroidx/media3/datasource/DataSpec;", "progressListener", "Landroidx/media3/datasource/cache/CacheWriter$ProgressListener;", "setCache", "cache", "setHeaders", "Companion", "exo_release"})
public final class ExoMediaSourceHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Context mAppContext;
    @Nullable
    private final String mUserAgent;
    @Nullable
    private CacheDataSource.Factory mCacheDataSourceFactory;
    @Nullable
    private HttpDataSource.Factory mHttpDataSourceFactory;
    @Nullable
    private Cache mCache;
    @Nullable
    private static volatile ExoMediaSourceHelper sInstance;

    private ExoMediaSourceHelper(Context context) {
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.mAppContext = context2;
        this.mUserAgent = Util.getUserAgent((Context)this.mAppContext, (String)this.mAppContext.getApplicationInfo().name);
    }

    @NotNull
    public final Context getMAppContext() {
        return this.mAppContext;
    }

    public final void setMAppContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.mAppContext = context;
    }

    @Nullable
    public final MediaSource getMediaSource(@Nullable String uri, boolean isCache) {
        return this.getMediaSource(uri, null, isCache);
    }

    public static /* synthetic */ MediaSource getMediaSource$default(ExoMediaSourceHelper exoMediaSourceHelper, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return exoMediaSourceHelper.getMediaSource(string, bl);
    }

    @Nullable
    public final MediaSource getMediaSource(@Nullable String uri, @Nullable Map<String, String> headers, boolean isCache) {
        MediaSource mediaSource;
        DataSource.Factory factory;
        CharSequence charSequence = uri;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        Uri contentUri = Uri.parse((String)uri);
        int contentType = this.inferContentType(uri);
        DataSource.Factory factory2 = factory = isCache ? (DataSource.Factory)this.getCacheDataSourceFactory() : (DataSource.Factory)this.getDataSourceFactory();
        if (this.mHttpDataSourceFactory != null) {
            this.setHeaders(headers);
        }
        switch (contentType) {
            case 2: {
                mediaSource = (MediaSource)new HlsMediaSource.Factory(factory).createMediaSource(MediaItem.fromUri((Uri)contentUri));
                break;
            }
            case 4: {
                mediaSource = (MediaSource)new ProgressiveMediaSource.Factory(factory).createMediaSource(MediaItem.fromUri((Uri)contentUri));
                break;
            }
            default: {
                mediaSource = (MediaSource)new ProgressiveMediaSource.Factory(factory).createMediaSource(MediaItem.fromUri((Uri)contentUri));
            }
        }
        return mediaSource;
    }

    public static /* synthetic */ MediaSource getMediaSource$default(ExoMediaSourceHelper exoMediaSourceHelper, String string, Map map, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return exoMediaSourceHelper.getMediaSource(string, map, bl);
    }

    private final int inferContentType(String fileName) {
        String fileName2;
        String string = fileName2 = fileName;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        fileName2 = string2;
        return StringsKt.contains$default((CharSequence)fileName2, (CharSequence)".m3u8", (boolean)false, (int)2, null) ? 2 : 4;
    }

    private final CacheDataSource.Factory getCacheDataSourceFactory() {
        CacheDataSource.Factory factory = this.mCacheDataSourceFactory;
        if (factory != null) {
            CacheDataSource.Factory it = factory;
            boolean bl = false;
            return it;
        }
        if (this.mCache == null) {
            this.mCache = this.newCache();
        }
        CacheDataSource.Factory factory2 = new CacheDataSource.Factory();
        Cache cache = this.mCache;
        Intrinsics.checkNotNull((Object)cache);
        CacheDataSource.Factory factory3 = this.mCacheDataSourceFactory = factory2.setCache(cache).setUpstreamDataSourceFactory((DataSource.Factory)this.getDataSourceFactory()).setFlags(2);
        Intrinsics.checkNotNull((Object)factory3);
        return factory3;
    }

    public final void preLoad(@NotNull DataSpec dataSpec, @Nullable CacheWriter.ProgressListener progressListener) {
        Intrinsics.checkNotNullParameter((Object)dataSpec, (String)"dataSpec");
        try {
            new CacheWriter(this.getCacheDataSourceFactory().createDataSource(), dataSpec, null, progressListener).cache();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final Cache newCache() {
        return (Cache)new SimpleCache(new File(this.mAppContext.getExternalCacheDir(), "exo-video-cache"), (CacheEvictor)new LeastRecentlyUsedCacheEvictor(0x10000000L), (DatabaseProvider)new StandaloneDatabaseProvider(this.mAppContext));
    }

    private final DefaultDataSource.Factory getDataSourceFactory() {
        return new DefaultDataSource.Factory(this.mAppContext, this.getHttpDataSourceFactory());
    }

    private final DataSource.Factory getHttpDataSourceFactory() {
        if (this.mHttpDataSourceFactory == null) {
            this.mHttpDataSourceFactory = (HttpDataSource.Factory)new DefaultHttpDataSource.Factory().setUserAgent(this.mUserAgent).setAllowCrossProtocolRedirects(true);
        }
        HttpDataSource.Factory factory = this.mHttpDataSourceFactory;
        Intrinsics.checkNotNull((Object)factory);
        return (DataSource.Factory)factory;
    }

    private final void setHeaders(Map<String, String> headers) {
        block5: {
            String value;
            Map<String, String> map = headers;
            if (map == null || map.isEmpty()) break block5;
            if (headers.containsKey("User-Agent") && !TextUtils.isEmpty((CharSequence)(value = headers.remove("User-Agent")))) {
                try {
                    Field userAgentField;
                    Object object = this.mHttpDataSourceFactory;
                    Field field = userAgentField = object != null && (object = object.getClass()) != null ? ((Class)object).getDeclaredField("userAgent") : null;
                    if (field != null) {
                        Field it = field;
                        boolean bl = false;
                        it.setAccessible(true);
                        it.set(this.mHttpDataSourceFactory, value);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            HttpDataSource.Factory factory = this.mHttpDataSourceFactory;
            if (factory != null) {
                factory.setDefaultRequestProperties(headers);
            }
        }
    }

    public final void setCache(@Nullable Cache cache) {
        this.mCache = cache;
    }

    public /* synthetic */ ExoMediaSourceHelper(Context context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/talpa/exo/ExoMediaSourceHelper$Companion;", "", "()V", "sInstance", "Lcom/talpa/exo/ExoMediaSourceHelper;", "getInstance", "context", "Landroid/content/Context;", "exo_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final ExoMediaSourceHelper getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (sInstance == null) {
                Class<ExoMediaSourceHelper> clazz = ExoMediaSourceHelper.class;
                synchronized (clazz) {
                    boolean bl = false;
                    if (sInstance == null) {
                        sInstance = new ExoMediaSourceHelper(context, null);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            return sInstance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

