/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.ijk;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import com.talpa.tplayer_core.util.ExtensionKt;
import com.talpa.tplayer_core.util.L;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.danmaku.ijk.media.player.misc.IMediaDataSource;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0012\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/talpa/ijk/RawDataSourceProvider;", "Ltv/danmaku/ijk/media/player/misc/IMediaDataSource;", "mDescriptor", "Landroid/content/res/AssetFileDescriptor;", "(Landroid/content/res/AssetFileDescriptor;)V", "mMediaBytes", "", "close", "", "getSize", "", "readAt", "", "position", "buffer", "offset", "size", "readBytes", "inputStream", "Ljava/io/InputStream;", "Companion", "ijk_release"})
public final class RawDataSourceProvider
implements IMediaDataSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private AssetFileDescriptor mDescriptor;
    @Nullable
    private byte[] mMediaBytes;

    public RawDataSourceProvider(@Nullable AssetFileDescriptor mDescriptor) {
        this.mDescriptor = mDescriptor;
    }

    @Override
    public int readAt(long position, @NotNull byte[] buffer, int offset, int size) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (position + 1L >= (long)ExtensionKt.toDefaultValue$default((Integer)(this.mMediaBytes != null ? Integer.valueOf(this.mMediaBytes.length) : null), (int)0, (int)1, null)) {
            return -1;
        }
        int length = 0;
        if (position + (long)size < (long)ExtensionKt.toDefaultValue$default((Integer)(this.mMediaBytes != null ? Integer.valueOf(this.mMediaBytes.length) : null), (int)0, (int)1, null)) {
            length = size;
        } else {
            length = (int)((long)ExtensionKt.toDefaultValue$default((Integer)(this.mMediaBytes != null ? Integer.valueOf(this.mMediaBytes.length) : null), (int)0, (int)1, null) - position);
            if (length > buffer.length) {
                length = buffer.length;
            }
            --length;
        }
        System.arraycopy(this.mMediaBytes, (int)position, buffer, offset, length);
        return length;
    }

    @Override
    public long getSize() throws IOException {
        AssetFileDescriptor assetFileDescriptor = this.mDescriptor;
        long length = ExtensionKt.toDefaultValue$default((Long)(assetFileDescriptor != null ? Long.valueOf(assetFileDescriptor.getLength()) : null), (long)0L, (int)1, null);
        if (this.mMediaBytes == null) {
            AssetFileDescriptor assetFileDescriptor2 = this.mDescriptor;
            InputStream inputStream = assetFileDescriptor2 != null ? assetFileDescriptor2.createInputStream() : null;
            this.mMediaBytes = this.readBytes(inputStream);
        }
        return length;
    }

    @Override
    public void close() throws IOException {
        AssetFileDescriptor assetFileDescriptor = this.mDescriptor;
        if (assetFileDescriptor != null) {
            assetFileDescriptor.close();
        }
        this.mDescriptor = null;
        this.mMediaBytes = null;
    }

    private final byte[] readBytes(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        int len = 0;
        while (true) {
            int n;
            int it = n = inputStream.read(buffer);
            boolean bl = false;
            len = it;
            if (n == -1) break;
            byteBuffer.write(buffer, 0, len);
        }
        byte[] byArray = byteBuffer.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteBuffer.toByteArray()");
        return byArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\t"}, d2={"Lcom/talpa/ijk/RawDataSourceProvider$Companion;", "", "()V", "create", "Lcom/talpa/ijk/RawDataSourceProvider;", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "ijk_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final RawDataSourceProvider create(@NotNull Context context, @Nullable Uri uri) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (uri == null) {
                return null;
            }
            try {
                AssetFileDescriptor fileDescriptor = context.getContentResolver().openAssetFileDescriptor(uri, "r");
                return new RawDataSourceProvider(fileDescriptor);
            }
            catch (FileNotFoundException e) {
                L.i((String)("RawDataSourceProvider e = " + e));
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

