/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.view.accessibility.AccessibilityNodeProviderCompat;
import android.support.v4.view.accessibility.AccessibilityRecordCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import java.util.LinkedList;
import java.util.List;

public abstract class TouchExplorationHelper<T>
extends AccessibilityNodeProviderCompat {
    public static final int INVALID_ID = Integer.MIN_VALUE;
    private final Rect mTempScreenRect = new Rect();
    private final Rect mTempParentRect = new Rect();
    private final Rect mTempVisibleRect = new Rect();
    private final int[] mTempGlobalRect = new int[2];
    private final AccessibilityManager mManager;
    private View mParentView;
    private int mFocusedItemId = Integer.MIN_VALUE;
    private T mCurrentItem = null;
    private final AccessibilityDelegateCompat mDelegate = new AccessibilityDelegateCompat(){

        public void onInitializeAccessibilityEvent(View view, AccessibilityEvent event) {
            super.onInitializeAccessibilityEvent(view, event);
            event.setClassName((CharSequence)view.getClass().getName());
        }

        public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat info) {
            super.onInitializeAccessibilityNodeInfo(view, info);
            info.setClassName((CharSequence)view.getClass().getName());
        }

        public AccessibilityNodeProviderCompat getAccessibilityNodeProvider(View host) {
            return TouchExplorationHelper.this;
        }
    };

    public TouchExplorationHelper(Context context, View parentView) {
        this.mManager = (AccessibilityManager)context.getSystemService("accessibility");
        this.mParentView = parentView;
    }

    public T getFocusedItem() {
        return this.getItemForId(this.mFocusedItemId);
    }

    public void clearFocusedItem() {
        int itemId = this.mFocusedItemId;
        if (itemId == Integer.MIN_VALUE) {
            return;
        }
        this.performAction(itemId, 128, null);
    }

    public void setFocusedItem(T item) {
        int itemId = this.getIdForItem(item);
        if (itemId == Integer.MIN_VALUE) {
            return;
        }
        this.performAction(itemId, 64, null);
    }

    public void invalidateParent() {
        this.mParentView.sendAccessibilityEvent(2048);
    }

    public void invalidateItem(T item) {
        this.sendEventForItem(item, 2048);
    }

    public boolean sendEventForItem(T item, int eventType) {
        if (!this.mManager.isEnabled()) {
            return false;
        }
        AccessibilityEvent event = this.getEventForItem(item, eventType);
        ViewGroup group = (ViewGroup)this.mParentView.getParent();
        return group.requestSendAccessibilityEvent(this.mParentView, event);
    }

    public AccessibilityNodeInfoCompat createAccessibilityNodeInfo(int virtualViewId) {
        if (virtualViewId == -1) {
            return this.getNodeForParent();
        }
        T item = this.getItemForId(virtualViewId);
        if (item == null) {
            return null;
        }
        AccessibilityNodeInfoCompat node = AccessibilityNodeInfoCompat.obtain();
        this.populateNodeForItemInternal(item, node);
        return node;
    }

    public boolean performAction(int virtualViewId, int action, Bundle arguments) {
        if (virtualViewId == -1) {
            return ViewCompat.performAccessibilityAction((View)this.mParentView, (int)action, (Bundle)arguments);
        }
        T item = this.getItemForId(virtualViewId);
        if (item == null) {
            return false;
        }
        boolean handled = false;
        switch (action) {
            case 64: {
                if (this.mFocusedItemId == virtualViewId) break;
                this.mFocusedItemId = virtualViewId;
                this.sendEventForItem(item, 32768);
                handled = true;
                break;
            }
            case 128: {
                if (this.mFocusedItemId != virtualViewId) break;
                this.mFocusedItemId = Integer.MIN_VALUE;
                this.sendEventForItem(item, 65536);
                handled = true;
            }
        }
        return handled |= this.performActionForItem(item, action, arguments);
    }

    private void setCurrentItem(T item) {
        if (this.mCurrentItem == item) {
            return;
        }
        if (this.mCurrentItem != null) {
            this.sendEventForItem(this.mCurrentItem, 256);
        }
        this.mCurrentItem = item;
        if (this.mCurrentItem != null) {
            this.sendEventForItem(this.mCurrentItem, 128);
        }
    }

    private AccessibilityEvent getEventForItem(T item, int eventType) {
        AccessibilityEvent event = AccessibilityEvent.obtain((int)eventType);
        AccessibilityRecordCompat record = new AccessibilityRecordCompat((Object)event);
        int virtualDescendantId = this.getIdForItem(item);
        event.setEnabled(true);
        this.populateEventForItem(item, event);
        if (event.getText().isEmpty() && TextUtils.isEmpty((CharSequence)event.getContentDescription())) {
            throw new RuntimeException("You must add text or a content description in populateEventForItem()");
        }
        event.setClassName((CharSequence)item.getClass().getName());
        event.setPackageName((CharSequence)this.mParentView.getContext().getPackageName());
        record.setSource(this.mParentView, virtualDescendantId);
        return event;
    }

    private AccessibilityNodeInfoCompat getNodeForParent() {
        AccessibilityNodeInfoCompat info = AccessibilityNodeInfoCompat.obtain((View)this.mParentView);
        ViewCompat.onInitializeAccessibilityNodeInfo((View)this.mParentView, (AccessibilityNodeInfoCompat)info);
        LinkedList items = new LinkedList();
        this.getVisibleItems(items);
        for (Object item : items) {
            int virtualDescendantId = this.getIdForItem(item);
            info.addChild(this.mParentView, virtualDescendantId);
        }
        return info;
    }

    private AccessibilityNodeInfoCompat populateNodeForItemInternal(T item, AccessibilityNodeInfoCompat node) {
        int virtualDescendantId = this.getIdForItem(item);
        node.setEnabled(true);
        this.populateNodeForItem(item, node);
        if (TextUtils.isEmpty((CharSequence)node.getText()) && TextUtils.isEmpty((CharSequence)node.getContentDescription())) {
            throw new RuntimeException("You must add text or a content description in populateNodeForItem()");
        }
        node.setPackageName((CharSequence)this.mParentView.getContext().getPackageName());
        node.setClassName((CharSequence)item.getClass().getName());
        node.setParent(this.mParentView);
        node.setSource(this.mParentView, virtualDescendantId);
        if (this.mFocusedItemId == virtualDescendantId) {
            node.addAction(128);
        } else {
            node.addAction(64);
        }
        node.getBoundsInParent(this.mTempParentRect);
        if (this.mTempParentRect.isEmpty()) {
            throw new RuntimeException("You must set parent bounds in populateNodeForItem()");
        }
        if (this.intersectVisibleToUser(this.mTempParentRect)) {
            node.setVisibleToUser(true);
            node.setBoundsInParent(this.mTempParentRect);
        }
        this.mParentView.getLocationOnScreen(this.mTempGlobalRect);
        int offsetX = this.mTempGlobalRect[0];
        int offsetY = this.mTempGlobalRect[1];
        this.mTempScreenRect.set(this.mTempParentRect);
        this.mTempScreenRect.offset(offsetX, offsetY);
        node.setBoundsInScreen(this.mTempScreenRect);
        return node;
    }

    private boolean intersectVisibleToUser(Rect localRect) {
        if (localRect == null || localRect.isEmpty()) {
            return false;
        }
        if (this.mParentView.getWindowVisibility() != 0) {
            return false;
        }
        TouchExplorationHelper current = this;
        while (current instanceof View) {
            View view = (View)current;
            if (view.getAlpha() <= 0.0f || view.getVisibility() != 0) {
                return false;
            }
            current = view.getParent();
        }
        if (!this.mParentView.getLocalVisibleRect(this.mTempVisibleRect)) {
            return false;
        }
        return localRect.intersect(this.mTempVisibleRect);
    }

    public AccessibilityDelegateCompat getAccessibilityDelegate() {
        return this.mDelegate;
    }

    protected abstract boolean performActionForItem(T var1, int var2, Bundle var3);

    protected abstract void populateEventForItem(T var1, AccessibilityEvent var2);

    protected abstract void populateNodeForItem(T var1, AccessibilityNodeInfoCompat var2);

    protected abstract void getVisibleItems(List<T> var1);

    protected abstract T getItemAt(float var1, float var2);

    protected abstract int getIdForItem(T var1);

    protected abstract T getItemForId(int var1);
}

