/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.calendardatepicker;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.text.format.Time;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import com.codetroopers.betterpickers.Utils;
import com.codetroopers.betterpickers.calendardatepicker.CalendarDatePickerController;
import com.codetroopers.betterpickers.calendardatepicker.MonthView;
import java.util.Calendar;
import java.util.HashMap;

public abstract class MonthAdapter
extends BaseAdapter
implements MonthView.OnDayClickListener {
    private static final String TAG = "SimpleMonthAdapter";
    private final Context mContext;
    private final CalendarDatePickerController mController;
    private CalendarDay mSelectedDay;
    private TypedArray mThemeColors;
    protected static int WEEK_7_OVERHANG_HEIGHT = 7;
    protected static final int MONTHS_IN_YEAR = 12;

    public void setTheme(TypedArray mThemeColors) {
        this.mThemeColors = mThemeColors;
    }

    public MonthAdapter(Context context, CalendarDatePickerController controller) {
        this.mContext = context;
        this.mController = controller;
        this.init();
        this.setSelectedDay(this.mController.getSelectedDay());
    }

    public void setSelectedDay(CalendarDay day) {
        this.mSelectedDay = day;
        this.notifyDataSetChanged();
    }

    public CalendarDay getSelectedDay() {
        return this.mSelectedDay;
    }

    protected void init() {
        this.mSelectedDay = new CalendarDay(System.currentTimeMillis());
        if (this.mSelectedDay.compareTo(this.mController.getMaxDate()) > 0) {
            this.mSelectedDay = this.mController.getMaxDate();
        }
        if (this.mSelectedDay.compareTo(this.mController.getMinDate()) < 0) {
            this.mSelectedDay = this.mController.getMinDate();
        }
    }

    public int getCount() {
        return (this.mController.getMaxDate().year - this.mController.getMinDate().year + 1) * 12 - (11 - this.mController.getMaxDate().month) - this.mController.getMinDate().month;
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    public boolean hasStableIds() {
        return true;
    }

    @SuppressLint(value={"NewApi"})
    public View getView(int position, View convertView, ViewGroup parent) {
        MonthView monthView;
        HashMap<String, Integer> drawingParams = null;
        if (convertView != null) {
            monthView = (MonthView)convertView;
            drawingParams = (HashMap<String, Integer>)monthView.getTag();
        } else {
            monthView = this.createMonthView(this.mContext);
            monthView.setTheme(this.mThemeColors);
            AbsListView.LayoutParams params = new AbsListView.LayoutParams(-1, -1);
            monthView.setLayoutParams((ViewGroup.LayoutParams)params);
            monthView.setClickable(true);
            monthView.setOnDayClickListener(this);
        }
        if (drawingParams == null) {
            drawingParams = new HashMap<String, Integer>();
        }
        drawingParams.clear();
        int month = (position + this.mController.getMinDate().month) % 12;
        int year = (position + this.mController.getMinDate().month) / 12 + this.mController.getMinDate().year;
        int selectedDay = -1;
        if (this.isSelectedDayInMonth(year, month)) {
            selectedDay = this.mSelectedDay.day;
        }
        int rangeMin = -1;
        if (this.isRangeMinInMonth(year, month)) {
            rangeMin = this.mController.getMinDate().day;
        }
        int rangeMax = -1;
        if (this.isRangeMaxInMonth(year, month)) {
            rangeMax = this.mController.getMaxDate().day;
        }
        monthView.reuse();
        if (this.mController.getDisabledDays() != null) {
            monthView.setDisabledDays(this.mController.getDisabledDays());
        }
        drawingParams.put("selected_day", selectedDay);
        drawingParams.put("year", year);
        drawingParams.put("month", month);
        drawingParams.put("week_start", this.mController.getFirstDayOfWeek());
        drawingParams.put("range_min", rangeMin);
        drawingParams.put("range_max", rangeMax);
        monthView.setMonthParams(drawingParams);
        monthView.invalidate();
        return monthView;
    }

    public abstract MonthView createMonthView(Context var1);

    private boolean isSelectedDayInMonth(int year, int month) {
        return this.mSelectedDay.year == year && this.mSelectedDay.month == month;
    }

    private boolean isRangeMinInMonth(int year, int month) {
        return this.mController.getMinDate().year == year && this.mController.getMinDate().month == month;
    }

    private boolean isRangeMaxInMonth(int year, int month) {
        return this.mController.getMaxDate().year == year && this.mController.getMaxDate().month == month;
    }

    @Override
    public void onDayClick(MonthView view, CalendarDay day) {
        if (day != null && this.isDayInRange(day) && !this.isDayDisabled(day)) {
            this.onDayTapped(day);
        }
    }

    private boolean isDayInRange(CalendarDay day) {
        return day.compareTo(this.mController.getMinDate()) >= 0 && day.compareTo(this.mController.getMaxDate()) <= 0;
    }

    private boolean isDayDisabled(CalendarDay day) {
        if (this.mController.getDisabledDays() == null) {
            return false;
        }
        return this.mController.getDisabledDays().indexOfKey(Utils.formatDisabledDayForKey(day.year, day.month, day.day)) >= 0;
    }

    protected void onDayTapped(CalendarDay day) {
        this.mController.tryVibrate();
        this.mController.onDayOfMonthSelected(day.year, day.month, day.day);
        this.setSelectedDay(day);
    }

    public static class CalendarDay
    implements Comparable<CalendarDay>,
    Parcelable {
        private Calendar calendar;
        private long calendarTimeInMillis;
        private Time time;
        private long timeInMillis;
        int year;
        int month;
        int day;
        public static final Parcelable.Creator<CalendarDay> CREATOR = new Parcelable.Creator<CalendarDay>(){

            public CalendarDay createFromParcel(Parcel in) {
                return new CalendarDay(in);
            }

            public CalendarDay[] newArray(int size) {
                return new CalendarDay[size];
            }
        };

        public CalendarDay() {
            this.setTime(System.currentTimeMillis());
        }

        public CalendarDay(long timeInMillis) {
            this.setTime(timeInMillis);
        }

        public CalendarDay(Calendar calendar) {
            this.year = calendar.get(1);
            this.month = calendar.get(2);
            this.day = calendar.get(5);
        }

        public CalendarDay(int year, int month, int day) {
            this.setDay(year, month, day);
        }

        public CalendarDay(Parcel in) {
            this.calendarTimeInMillis = in.readLong();
            this.calendar = Calendar.getInstance();
            this.calendar.setTimeInMillis(this.calendarTimeInMillis);
            this.timeInMillis = in.readLong();
            this.time = new Time();
            this.time.set(this.timeInMillis);
            this.year = in.readInt();
            this.month = in.readInt();
            this.day = in.readInt();
        }

        public void set(CalendarDay date) {
            this.year = date.year;
            this.month = date.month;
            this.day = date.day;
        }

        public void setDay(int year, int month, int day) {
            this.calendar = Calendar.getInstance();
            this.calendar.set(year, month, day, 0, 0, 0);
            this.year = this.calendar.get(1);
            this.month = this.calendar.get(2);
            this.day = this.calendar.get(5);
        }

        public long getDateInMillis() {
            if (this.calendar == null) {
                this.calendar = Calendar.getInstance();
                this.calendar.set(this.year, this.month, this.day, 0, 0, 0);
            }
            return this.calendar.getTimeInMillis();
        }

        public synchronized void setJulianDay(int julianDay) {
            if (this.time == null) {
                this.time = new Time();
            }
            this.time.setJulianDay(julianDay);
            this.setTime(this.time.toMillis(false));
        }

        private void setTime(long timeInMillis) {
            if (this.calendar == null) {
                this.calendar = Calendar.getInstance();
            }
            this.calendar.setTimeInMillis(timeInMillis);
            this.month = this.calendar.get(2);
            this.year = this.calendar.get(1);
            this.day = this.calendar.get(5);
        }

        @Override
        public int compareTo(@NonNull CalendarDay another) {
            if (this.year < another.year || this.year == another.year && this.month < another.month || this.year == another.year && this.month == another.month && this.day < another.day) {
                return -1;
            }
            if (this.year == another.year && this.month == another.month && this.day == another.day) {
                return 0;
            }
            return 1;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            if (this.calendar != null) {
                this.calendarTimeInMillis = this.calendar.getTimeInMillis();
            }
            dest.writeLong(this.calendarTimeInMillis);
            if (this.time != null) {
                this.timeInMillis = this.time.toMillis(false);
            }
            dest.writeInt(this.year);
            dest.writeInt(this.month);
            dest.writeInt(this.day);
        }
    }
}

