/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.calendardatepicker;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.widget.TextView;
import com.codetroopers.betterpickers.R;

public class TextViewWithCircularIndicator
extends TextView {
    private static final int SELECTED_CIRCLE_ALPHA = 60;
    Paint mCirclePaint = new Paint();
    private final int mRadius;
    private int mCircleColor;
    private final String mItemIsSelectedText;
    private boolean mDrawCircle;

    public TextViewWithCircularIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        Resources res = context.getResources();
        this.mCircleColor = res.getColor(R.color.bpBlue);
        this.mRadius = res.getDimensionPixelOffset(R.dimen.month_select_circle_radius);
        this.mItemIsSelectedText = context.getResources().getString(R.string.item_is_selected);
        this.init();
    }

    private void init() {
        this.mCirclePaint.setFakeBoldText(true);
        this.mCirclePaint.setAntiAlias(true);
        this.mCirclePaint.setColor(this.mCircleColor);
        this.mCirclePaint.setTextAlign(Paint.Align.CENTER);
        this.mCirclePaint.setStyle(Paint.Style.FILL);
        this.mCirclePaint.setAlpha(60);
    }

    public void setCircleColor(int circleColor) {
        this.mCircleColor = circleColor;
        this.init();
    }

    public void drawIndicator(boolean drawCircle) {
        this.mDrawCircle = drawCircle;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDrawCircle) {
            int width = this.getWidth();
            int height = this.getHeight();
            int radius = Math.min(width, height) / 2;
            canvas.drawCircle((float)(width / 2), (float)(height / 2), (float)radius, this.mCirclePaint);
        }
    }

    public CharSequence getContentDescription() {
        CharSequence itemText = this.getText();
        if (this.mDrawCircle) {
            return String.format(this.mItemIsSelectedText, itemText);
        }
        return itemText;
    }
}

