/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.datepicker;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.util.Log;
import com.codetroopers.betterpickers.datepicker.DatePickerDialogFragment;
import java.util.Vector;

public class DatePickerBuilder {
    private FragmentManager manager;
    private Integer styleResId;
    private Fragment targetFragment;
    private Integer monthOfYear;
    private Integer dayOfMonth;
    private Integer year;
    private Boolean yearOptional = false;
    private int mReference = -1;
    private Vector<DatePickerDialogFragment.DatePickerDialogHandler> mDatePickerDialogHandlers = new Vector();

    public DatePickerBuilder setFragmentManager(FragmentManager manager) {
        this.manager = manager;
        return this;
    }

    public DatePickerBuilder setStyleResId(int styleResId) {
        this.styleResId = styleResId;
        return this;
    }

    public DatePickerBuilder setTargetFragment(Fragment targetFragment) {
        this.targetFragment = targetFragment;
        return this;
    }

    public DatePickerBuilder setReference(int reference) {
        this.mReference = reference;
        return this;
    }

    public DatePickerBuilder setMonthOfYear(int monthOfYear) {
        this.monthOfYear = monthOfYear;
        return this;
    }

    public DatePickerBuilder setDayOfMonth(int dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
        return this;
    }

    public DatePickerBuilder setYear(int year) {
        this.year = year;
        return this;
    }

    public DatePickerBuilder setYearOptional(boolean yearOptional) {
        this.yearOptional = yearOptional;
        return this;
    }

    public DatePickerBuilder addDatePickerDialogHandler(DatePickerDialogFragment.DatePickerDialogHandler handler) {
        this.mDatePickerDialogHandlers.add(handler);
        return this;
    }

    public DatePickerBuilder removeDatePickerDialogHandler(DatePickerDialogFragment.DatePickerDialogHandler handler) {
        this.mDatePickerDialogHandlers.remove(handler);
        return this;
    }

    public void show() {
        if (this.manager == null || this.styleResId == null) {
            Log.e((String)"DatePickerBuilder", (String)"setFragmentManager() and setStyleResId() must be called.");
            return;
        }
        FragmentTransaction ft = this.manager.beginTransaction();
        Fragment prev = this.manager.findFragmentByTag("date_dialog");
        if (prev != null) {
            ft.remove(prev).commit();
            ft = this.manager.beginTransaction();
        }
        ft.addToBackStack(null);
        DatePickerDialogFragment fragment = DatePickerDialogFragment.newInstance(this.mReference, this.styleResId, this.monthOfYear, this.dayOfMonth, this.year, this.yearOptional);
        if (this.targetFragment != null) {
            fragment.setTargetFragment(this.targetFragment, 0);
        }
        fragment.setDatePickerDialogHandlers(this.mDatePickerDialogHandlers);
        fragment.show(ft, "date_dialog");
    }
}

