/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.datepicker;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.datepicker.DatePicker;
import java.util.Vector;

public class DatePickerDialogFragment
extends DialogFragment {
    private static final String REFERENCE_KEY = "DatePickerDialogFragment_ReferenceKey";
    private static final String THEME_RES_ID_KEY = "DatePickerDialogFragment_ThemeResIdKey";
    private static final String MONTH_KEY = "DatePickerDialogFragment_MonthKey";
    private static final String DAY_KEY = "DatePickerDialogFragment_DayKey";
    private static final String YEAR_KEY = "DatePickerDialogFragment_YearKey";
    private static final String YEAR_OPTIONAL_KEY = "DatePickerDialogFragment_YearOptionalKey";
    private DatePicker mPicker;
    private int mMonthOfYear = -1;
    private int mDayOfMonth = 0;
    private int mYear = 0;
    private boolean mYearOptional = false;
    private int mReference = -1;
    private int mTheme = -1;
    private ColorStateList mTextColor;
    private int mDialogBackgroundResId;
    private Vector<DatePickerDialogHandler> mDatePickerDialogHandlers = new Vector();

    public static DatePickerDialogFragment newInstance(int reference, int themeResId, Integer monthOfYear, Integer dayOfMonth, Integer year, Boolean yearOptional) {
        DatePickerDialogFragment frag = new DatePickerDialogFragment();
        Bundle args = new Bundle();
        args.putInt(REFERENCE_KEY, reference);
        args.putInt(THEME_RES_ID_KEY, themeResId);
        if (monthOfYear != null) {
            args.putInt(MONTH_KEY, monthOfYear.intValue());
        }
        if (dayOfMonth != null) {
            args.putInt(DAY_KEY, dayOfMonth.intValue());
        }
        if (year != null) {
            args.putInt(YEAR_KEY, year.intValue());
        }
        args.putBoolean(YEAR_OPTIONAL_KEY, yearOptional.booleanValue());
        frag.setArguments(args);
        return frag;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null && args.containsKey(REFERENCE_KEY)) {
            this.mReference = args.getInt(REFERENCE_KEY);
        }
        if (args != null && args.containsKey(THEME_RES_ID_KEY)) {
            this.mTheme = args.getInt(THEME_RES_ID_KEY);
        }
        if (args != null && args.containsKey(MONTH_KEY)) {
            this.mMonthOfYear = args.getInt(MONTH_KEY);
        }
        if (args != null && args.containsKey(DAY_KEY)) {
            this.mDayOfMonth = args.getInt(DAY_KEY);
        }
        if (args != null && args.containsKey(YEAR_KEY)) {
            this.mYear = args.getInt(YEAR_KEY);
        }
        if (args != null && args.containsKey(YEAR_OPTIONAL_KEY)) {
            this.mYearOptional = args.getBoolean(YEAR_OPTIONAL_KEY);
        }
        this.setStyle(1, 0);
        this.mTextColor = this.getResources().getColorStateList(R.color.dialog_text_color_holo_dark);
        this.mDialogBackgroundResId = R.drawable.dialog_full_holo_dark;
        if (this.mTheme != -1) {
            TypedArray a = this.getActivity().getApplicationContext().obtainStyledAttributes(this.mTheme, R.styleable.BetterPickersDialogFragment);
            this.mTextColor = a.getColorStateList(R.styleable.BetterPickersDialogFragment_bpTextColor);
            this.mDialogBackgroundResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpDialogBackground, this.mDialogBackgroundResId);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.date_picker_dialog, null);
        Button doneButton = (Button)view.findViewById(R.id.done_button);
        Button cancelButton = (Button)view.findViewById(R.id.cancel_button);
        cancelButton.setTextColor(this.mTextColor);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DatePickerDialogFragment.this.dismiss();
            }
        });
        doneButton.setTextColor(this.mTextColor);
        doneButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                for (DatePickerDialogHandler handler : DatePickerDialogFragment.this.mDatePickerDialogHandlers) {
                    handler.onDialogDateSet(DatePickerDialogFragment.this.mReference, DatePickerDialogFragment.this.mPicker.getYear(), DatePickerDialogFragment.this.mPicker.getMonthOfYear(), DatePickerDialogFragment.this.mPicker.getDayOfMonth());
                }
                FragmentActivity activity = DatePickerDialogFragment.this.getActivity();
                Fragment fragment = DatePickerDialogFragment.this.getTargetFragment();
                if (activity instanceof DatePickerDialogHandler) {
                    DatePickerDialogHandler act = (DatePickerDialogHandler)activity;
                    act.onDialogDateSet(DatePickerDialogFragment.this.mReference, DatePickerDialogFragment.this.mPicker.getYear(), DatePickerDialogFragment.this.mPicker.getMonthOfYear(), DatePickerDialogFragment.this.mPicker.getDayOfMonth());
                } else if (fragment instanceof DatePickerDialogHandler) {
                    DatePickerDialogHandler frag = (DatePickerDialogHandler)fragment;
                    frag.onDialogDateSet(DatePickerDialogFragment.this.mReference, DatePickerDialogFragment.this.mPicker.getYear(), DatePickerDialogFragment.this.mPicker.getMonthOfYear(), DatePickerDialogFragment.this.mPicker.getDayOfMonth());
                }
                DatePickerDialogFragment.this.dismiss();
            }
        });
        this.mPicker = (DatePicker)view.findViewById(R.id.date_picker);
        this.mPicker.setSetButton(doneButton);
        this.mPicker.setDate(this.mYear, this.mMonthOfYear, this.mDayOfMonth);
        this.mPicker.setYearOptional(this.mYearOptional);
        this.mPicker.setTheme(this.mTheme);
        this.getDialog().getWindow().setBackgroundDrawableResource(this.mDialogBackgroundResId);
        return view;
    }

    public void setDatePickerDialogHandlers(Vector<DatePickerDialogHandler> handlers) {
        this.mDatePickerDialogHandlers = handlers;
    }

    public static interface DatePickerDialogHandler {
        public void onDialogDateSet(int var1, int var2, int var3, int var4);
    }
}

