/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.expirationpicker;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.util.Log;
import com.codetroopers.betterpickers.expirationpicker.ExpirationPickerDialogFragment;
import java.util.Vector;

public class ExpirationPickerBuilder {
    private FragmentManager manager;
    private Integer styleResId;
    private Fragment targetFragment;
    private Integer minimumYear;
    private Integer monthOfYear;
    private Integer year;
    private int mReference = -1;
    private Vector<ExpirationPickerDialogFragment.ExpirationPickerDialogHandler> mExpirationPickerDialogHandlers = new Vector();

    public ExpirationPickerBuilder setFragmentManager(FragmentManager manager) {
        this.manager = manager;
        return this;
    }

    public ExpirationPickerBuilder setStyleResId(int styleResId) {
        this.styleResId = styleResId;
        return this;
    }

    public ExpirationPickerBuilder setTargetFragment(Fragment targetFragment) {
        this.targetFragment = targetFragment;
        return this;
    }

    public ExpirationPickerBuilder setReference(int reference) {
        this.mReference = reference;
        return this;
    }

    public ExpirationPickerBuilder setMinYear(int year) {
        this.minimumYear = year;
        return this;
    }

    public ExpirationPickerBuilder setMonthOfYear(int monthOfYear) {
        this.monthOfYear = monthOfYear;
        return this;
    }

    public ExpirationPickerBuilder setYear(int year) {
        this.year = year;
        return this;
    }

    public ExpirationPickerBuilder addExpirationPickerDialogHandler(ExpirationPickerDialogFragment.ExpirationPickerDialogHandler handler) {
        this.mExpirationPickerDialogHandlers.add(handler);
        return this;
    }

    public ExpirationPickerBuilder removeExpirationPickerDialogHandler(ExpirationPickerDialogFragment.ExpirationPickerDialogHandler handler) {
        this.mExpirationPickerDialogHandlers.remove(handler);
        return this;
    }

    public void show() {
        if (this.manager == null || this.styleResId == null) {
            Log.e((String)"ExpirationPickerBuilder", (String)"setFragmentManager() and setStyleResId() must be called.");
            return;
        }
        FragmentTransaction ft = this.manager.beginTransaction();
        Fragment prev = this.manager.findFragmentByTag("expiration_dialog");
        if (prev != null) {
            ft.remove(prev).commit();
            ft = this.manager.beginTransaction();
        }
        ft.addToBackStack(null);
        ExpirationPickerDialogFragment fragment = ExpirationPickerDialogFragment.newInstance(this.mReference, this.styleResId, this.monthOfYear, this.year, this.minimumYear);
        if (this.targetFragment != null) {
            fragment.setTargetFragment(this.targetFragment, 0);
        }
        fragment.setExpirationPickerDialogHandlers(this.mExpirationPickerDialogHandlers);
        fragment.show(ft, "expiration_dialog");
    }
}

