/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.expirationpicker;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.expirationpicker.ExpirationPicker;
import java.util.Vector;

public class ExpirationPickerDialogFragment
extends DialogFragment {
    private static final String REFERENCE_KEY = "ExpirationPickerDialogFragment_ReferenceKey";
    private static final String THEME_RES_ID_KEY = "ExpirationPickerDialogFragment_ThemeResIdKey";
    private static final String MONTH_KEY = "ExpirationPickerDialogFragment_MonthKey";
    private static final String YEAR_KEY = "ExpirationPickerDialogFragment_YearKey";
    private static final String MINIMUM_YEAR_KEY = "ExpirationPickerDialogFragment_MinimumYearKey";
    private ExpirationPicker mPicker;
    private int mMonthOfYear = -1;
    private int mYear = 0;
    private int mMinimumYear = 0;
    private int mReference = -1;
    private int mTheme = -1;
    private int mDialogBackgroundResId;
    private Vector<ExpirationPickerDialogHandler> mExpirationPickerDialogHandlers = new Vector();
    private ColorStateList mTextColor;

    public static ExpirationPickerDialogFragment newInstance(int reference, int themeResId, Integer monthOfYear, Integer year, Integer minimumYear) {
        ExpirationPickerDialogFragment frag = new ExpirationPickerDialogFragment();
        Bundle args = new Bundle();
        args.putInt(REFERENCE_KEY, reference);
        args.putInt(THEME_RES_ID_KEY, themeResId);
        if (monthOfYear != null) {
            args.putInt(MONTH_KEY, monthOfYear.intValue());
        }
        if (year != null) {
            args.putInt(YEAR_KEY, year.intValue());
        }
        if (minimumYear != null) {
            args.putInt(MINIMUM_YEAR_KEY, minimumYear.intValue());
        }
        frag.setArguments(args);
        return frag;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null && args.containsKey(REFERENCE_KEY)) {
            this.mReference = args.getInt(REFERENCE_KEY);
        }
        if (args != null && args.containsKey(THEME_RES_ID_KEY)) {
            this.mTheme = args.getInt(THEME_RES_ID_KEY);
        }
        if (args != null && args.containsKey(MONTH_KEY)) {
            this.mMonthOfYear = args.getInt(MONTH_KEY);
        }
        if (args != null && args.containsKey(YEAR_KEY)) {
            this.mYear = args.getInt(YEAR_KEY);
        }
        if (args != null && args.containsKey(MINIMUM_YEAR_KEY)) {
            this.mMinimumYear = args.getInt(MINIMUM_YEAR_KEY);
        }
        this.setStyle(1, 0);
        this.mTextColor = this.getResources().getColorStateList(R.color.dialog_text_color_holo_dark);
        this.mDialogBackgroundResId = R.drawable.dialog_full_holo_dark;
        if (this.mTheme != -1) {
            TypedArray a = this.getActivity().getApplicationContext().obtainStyledAttributes(this.mTheme, R.styleable.BetterPickersDialogFragment);
            this.mTextColor = a.getColorStateList(R.styleable.BetterPickersDialogFragment_bpTextColor);
            this.mDialogBackgroundResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpDialogBackground, this.mDialogBackgroundResId);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.expiration_picker_dialog, null);
        Button doneButton = (Button)view.findViewById(R.id.done_button);
        Button cancelButton = (Button)view.findViewById(R.id.cancel_button);
        cancelButton.setTextColor(this.mTextColor);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ExpirationPickerDialogFragment.this.dismiss();
            }
        });
        doneButton.setTextColor(this.mTextColor);
        doneButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                for (ExpirationPickerDialogHandler handler : ExpirationPickerDialogFragment.this.mExpirationPickerDialogHandlers) {
                    handler.onDialogExpirationSet(ExpirationPickerDialogFragment.this.mReference, ExpirationPickerDialogFragment.this.mPicker.getYear(), ExpirationPickerDialogFragment.this.mPicker.getMonthOfYear());
                }
                FragmentActivity activity = ExpirationPickerDialogFragment.this.getActivity();
                Fragment fragment = ExpirationPickerDialogFragment.this.getTargetFragment();
                if (activity instanceof ExpirationPickerDialogHandler) {
                    ExpirationPickerDialogHandler act = (ExpirationPickerDialogHandler)activity;
                    act.onDialogExpirationSet(ExpirationPickerDialogFragment.this.mReference, ExpirationPickerDialogFragment.this.mPicker.getYear(), ExpirationPickerDialogFragment.this.mPicker.getMonthOfYear());
                } else if (fragment instanceof ExpirationPickerDialogHandler) {
                    ExpirationPickerDialogHandler frag = (ExpirationPickerDialogHandler)fragment;
                    frag.onDialogExpirationSet(ExpirationPickerDialogFragment.this.mReference, ExpirationPickerDialogFragment.this.mPicker.getYear(), ExpirationPickerDialogFragment.this.mPicker.getMonthOfYear());
                }
                ExpirationPickerDialogFragment.this.dismiss();
            }
        });
        this.mPicker = (ExpirationPicker)view.findViewById(R.id.expiration_picker);
        this.mPicker.setSetButton(doneButton);
        this.mPicker.setTheme(this.mTheme);
        if (this.mMinimumYear != 0) {
            this.mPicker.setMinYear(this.mMinimumYear);
        }
        if (this.mMonthOfYear != -1 || this.mYear != 0) {
            this.mPicker.setExpiration(this.mYear, this.mMonthOfYear);
        }
        this.getDialog().getWindow().setBackgroundDrawableResource(this.mDialogBackgroundResId);
        return view;
    }

    public void setExpirationPickerDialogHandlers(Vector<ExpirationPickerDialogHandler> handlers) {
        this.mExpirationPickerDialogHandlers = handlers;
    }

    public static interface ExpirationPickerDialogHandler {
        public void onDialogExpirationSet(int var1, int var2, int var3);
    }
}

